using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Ika.Graphics;

namespace TestBoids.Entities
{
    public class Mine : BlockEntity
    {
        float MinSpeed = 0.71f; 

        public Mine(Vector2 position, Sprite sprite, float maxSpeed)
            : base(position, sprite, maxSpeed)
        {  
            MovementType = EntityMovementType.MT_Dynamic;
        }

        public override void Update(float dt)
        {
            Speed = new Vector2(0.1f, MaxSpeed + MinSpeed);
            MaxSpeed = 0.95f * MaxSpeed;

            Collision.UpdatePosition(Position);
        }
    }
}
