using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace Ika.Graphics
{
    /// <summary>
    /// A controller for a 3D camera
    /// </summary>
    public abstract class CameraControler
    {
        /// <summary>
        /// The camera movement speed
        /// </summary>
        float m_speed = 1.0f;
        
        /// <summary>
        /// Gets or sets the camera movement speed
        /// </summary>
        public float Speed
        {
            get{ return m_speed; } 
            set{ m_speed = value; }
        }

        protected abstract void MoveForward(float amount);
        public void Forward(float amount)
        {
            MoveForward(m_speed * amount);
        }
        public void Backward(float amount)
        {
            MoveForward( - m_speed * amount);
        }

        protected abstract void MoveUp(float amount);
        public void Up(float amount)
        {
            MoveUp(m_speed * amount);
        }
        public void Down(float amount)
        {
            MoveUp( - m_speed * amount);
        }

        protected abstract void MoveRight(float amount);
        public void Right(float amount)
        {
            MoveRight(m_speed * amount);
        }
        public void Left(float amount)
        {
            MoveRight( - m_speed * amount);
        }
    }
}
