using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace Ika.Graphics
{
    public class OrthoCam : Camera
    {
        public class OrthoCamControler : CameraControler
        {
            OrthoCam m_camera;
            public OrthoCamControler(OrthoCam camera)
            {
                m_camera = camera;
            }

            protected override void MoveForward(float amount)
            {
            }

            protected override void MoveUp(float amount)
            {
            }

            protected override void MoveRight(float amount)
            {
            }
        }

        public override void SetPointOfInterest(Vector3 point)
        {
        }

        public OrthoCam(Vector2 topLeftcorner, Vector2 bottomRightCorner)
        {
            Eye = Vector3.UnitZ * 500;
            Target = Vector3.Zero;
            Up = Vector3.UnitY;

            ProjectionMatrix = Matrix.CreateOrthographicOffCenter(topLeftcorner.X, bottomRightCorner.X, bottomRightCorner.Y, topLeftcorner.Y, 0.001f, 510);
        }

        protected override CameraControler CreateControler()
        {
            return new OrthoCamControler(this);
        }
    }
}
