using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace Ika.Graphics
{
    public class TopDownCamera : Camera
    {
        class TopDownCameraControler : CameraControler
        {
            TopDownCamera m_camera;
            public TopDownCameraControler(TopDownCamera camera)
            {
                m_camera = camera;
            }

            protected override void MoveForward(float amount)
            {
                m_camera.Height -= amount;
                m_camera.SetPointOfInterest(m_camera.Target);
            }

            protected override void MoveUp(float amount)
            {
                Vector3 target = m_camera.Target + m_camera.Up * amount;
                m_camera.SetPointOfInterest(target);
            }

            protected override void MoveRight(float amount)
            {
                Vector3 right = m_camera.ViewMatrix.Right;
                right.Normalize();
                Vector3 target = m_camera.Target + right * amount;
                m_camera.SetPointOfInterest(target);
            }
        }

        float m_height = 180;
        /// <summary>
        /// Gets the camera height
        /// </summary>
        public float Height
        {
            get { return m_height; }
            set { m_height = value; if (m_height < 0) { m_height = 1.0f; } }
        }

        public override void SetPointOfInterest(Vector3 point)
        {
            Eye = point + Vector3.UnitZ * Height;
            Target = point;
        }

        public TopDownCamera()
        {
            SetPointOfInterest(Vector3.Zero);
            Up = Vector3.UnitX;
        }

        protected override CameraControler CreateControler()
        {
            return new TopDownCameraControler(this);
        }
    }
}
