using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace Ika.Graphics.Effects
{
    public class CombineEffect : EffectWrapper
    {        
        public Texture2D LightMap
        {
            set { m_effect.Parameters["lightMap"].SetValue(value); }
        }

        public bool UseSSAO
        {
            set { m_effect.Parameters["useSSAO"].SetValue(value); }
        }

        public Texture2D AOMap
        {
            set { m_effect.Parameters["AOMap"].SetValue(value); }
        }

        public Texture2D RenderTarget1
        {
            set { m_effect.Parameters["RT1"].SetValue(value); }
        }

        public Texture2D RenderTarget2
        {
            set { m_effect.Parameters["RT2"].SetValue(value); }
        }

        public Texture2D RenderTarget3
        {
            set { m_effect.Parameters["RT3"].SetValue(value); }
        }

        public Texture2D RenderTarget4
        {
            set { m_effect.Parameters["RT4"].SetValue(value); }
        }

        public Color AmbientColor
        {
            set { m_effect.Parameters["ambientColor"].SetValue(value.ToVector4()); }
        }
        
        public Vector2 HalfPixel
        {
            set { m_effect.Parameters["halfPixel"].SetValue(value); }
        }

        public CombineEffect(Effect effect)
            : base(effect)
        {
        }
    }
}
