using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using Ika.Graphics;

namespace Ika.Graphics.Effects
{
    public class DirectionalLightEffect : EffectWrapper
    {
        public Vector3 CameraPosition
        {
            set { m_effect.Parameters["cameraPosition"].SetValue(value); }
        }

        public Color LightColor
        {
            set { m_effect.Parameters["lightColor"].SetValue(value.ToVector3()); }
        }

        public Vector3 LightDirection
        {
            set { m_effect.Parameters["lightDirection"].SetValue(value); }
        }

        public float LightIntensity
        {
            set { m_effect.Parameters["lightIntensity"].SetValue(value); }
        }

         public Texture2D RenderTarget1
        {
            set { m_effect.Parameters["RT1"].SetValue(value); }
        }

        public Texture2D RenderTarget2
        {
            set { m_effect.Parameters["RT2"].SetValue(value); }
        }

        public Texture2D RenderTarget3
        {
            set { m_effect.Parameters["RT3"].SetValue(value); }
        }

        public Vector2 HalfPixel
        {
            set { m_effect.Parameters["halfPixel"].SetValue(value); }
        }

        public DirectionalLight Light
        {
            set
            {
                LightColor = value.LightColor;
                LightIntensity = value.LightIntensity;
                LightDirection = value.LightDirection;
            }
        }

        public DirectionalLightEffect(Effect effect)
            : base(effect)
        {
        }
    }
}
