using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace Ika.Graphics.Effects
{
    /// <summary>
    /// Wrapper class for XNA effects.
    /// This is the base class for all custom effects
    /// </summary>
    public class EffectWrapper
    {
        protected Effect m_effect = null;

        public EffectWrapper(Effect effect)
        {
            m_effect = effect;
        }

        public Effect Effect
        {
            get { return m_effect; }
        }

        public EffectParameterCollection Parameters
        {
            get { return m_effect.Parameters;  }
        }

        public EffectTechniqueCollection Techniques
        {
            get { return m_effect.Techniques; }
        }

        public EffectTechnique CurrentTechnique
        {
            get { return m_effect.CurrentTechnique; }
        }

        public Matrix World
        {
            set { m_effect.Parameters["World"].SetValue(value); }
        }
        public Matrix View
        {
            set { m_effect.Parameters["View"].SetValue(value); }
        }
        public Matrix Projection
        {
            set { m_effect.Parameters["Projection"].SetValue(value); }
        }

        public void Begin()
        {
            m_effect.Begin();
        }

        public void End()
        {
            m_effect.End();
        }
    }
}
