using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework.Graphics;

namespace Ika.Graphics.Effects
{
    public class RenderToGBufferEffect : EffectWrapper
    {
        public bool UseTexture
        {
            set { m_effect.Parameters["useTexture"].SetValue(value); }
        }

        public Color DiffuseColor
        {
            set { m_effect.Parameters["diffuseColor"].SetValue(value.ToVector4()); }
        }

        public Texture2D Texture
        {
            set { m_effect.Parameters["diffuseTexture"].SetValue(value); }
        }

        public bool UseNormal
        {
            set { m_effect.Parameters["useNormal"].SetValue(value); }
        }

        public Texture2D Normal
        {
            set { m_effect.Parameters["normalTexture"].SetValue(value); }
        }

        public float NormalScale
        {
            set { m_effect.Parameters["normalScale"].SetValue(value); }
        }

        public bool UseEmissive
        {
            set { m_effect.Parameters["useEmissive"].SetValue(value); }
        }

        public Texture2D Emissive
        {
            set { m_effect.Parameters["emissiveTexture"].SetValue(value); }
        }

        public float SpecularIntensity
        {
            set { m_effect.Parameters["specularIntensity"].SetValue(value); }
        }

        public float SpecularPower
        {
            set { m_effect.Parameters["specularPower"].SetValue(value); }
        }

        public Material Material
        {
            set
            {
                UseTexture = value.UseDiffuseTexture;
                DiffuseColor = value.DiffuseColor;
                Texture = value.Texture;

                UseNormal = value.UseNormal;
                Normal = value.Normal;
                NormalScale = value.NormalScale;

                UseEmissive = value.UseEmissive;
                Emissive = value.Emissive;
                
                SpecularIntensity = value.SpecularIntensity;
                SpecularPower = value.SpecularPower;
            }
        }

        public RenderToGBufferEffect(Effect effect, Material material)
            : base(effect)
        {
            UseTexture = material.UseDiffuseTexture;
            DiffuseColor = material.DiffuseColor;
            Texture = material.Texture;

            SpecularIntensity = material.SpecularIntensity;
            SpecularPower = material.SpecularPower;
        }

        public RenderToGBufferEffect(Effect effect)
            : base(effect)
        {
            Material = Material.Default;
        }
    }
}
