using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace Ika.Graphics.Effects
{
    public class SSAOEffect : FullScreenEffect
    {

        public int NbrSamples
        {
            set { m_effect.Parameters["nbrSamples"].SetValue(value); }
        }
        
        public float MinScale
        {
            set { m_effect.Parameters["minScale"].SetValue(value); }
        }

        public float MaxScale
        {
            set { m_effect.Parameters["maxScale"].SetValue(value); }
        }

        public float Exponent
        {
            set { m_effect.Parameters["exponent"].SetValue(value); }
        }

        public Texture2D RandomTexture
        {
            set { m_effect.Parameters["RandomTexture"].SetValue(value); }
        }

        public Matrix SceneViewProj
        {
            set { m_effect.Parameters["SceneViewProj"].SetValue(value); }
        }            

        public Texture2D RT1
        {
            set { m_effect.Parameters["RT1"].SetValue(value); }
        }

        public Texture2D RT3
        {
            set { m_effect.Parameters["RT3"].SetValue(value); }
        }

        public Texture2D Diffuse
        {
            set { m_effect.Parameters["diffuse"].SetValue(value); }
        }

        public Vector3 ViewForward
        {
            set { m_effect.Parameters["viewForward"].SetValue(value); }
        }

        public Vector3 ViewLeft
        {
            set { m_effect.Parameters["viewLeft"].SetValue(value); }
        }

        public Vector3 ViewUp
        {
            set { m_effect.Parameters["viewUp"].SetValue(value); }
        }

        public SSAOEffect(Effect effect)
            : base(effect)
        {
        }
    }
}
