using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Ika.Graphics.Effects
{
    public class SpriteEffect : EffectWrapper
    {
        public SpriteEffect(Effect effect)
            : base(effect)
        {
        }

        public Texture2D Texture
        {
            set { m_effect.Parameters["SpriteTexture"].SetValue(value); }
        }

        public float Alpha
        {
            set { m_effect.Parameters["Alpha"].SetValue(value); }
        }

        public Vector2 UVScale
        {
            set { m_effect.Parameters["UVScale"].SetValue(value); }
        }

        public Vector2 UVOffset
        {
            set { m_effect.Parameters["UVOffset"].SetValue(value); }
        }
    }
}
