using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework.Graphics;

namespace Ika.Graphics
{
    /// <summary>
    /// Represents a mesh material.
    /// The material is composed of diffuse, normal and emissive maps.
    /// </summary>
    public class Material
    {
        bool m_useDiffuseTexture;
        public bool UseDiffuseTexture
        {
            get { return m_useDiffuseTexture; }
            set { m_useDiffuseTexture = value; }
        }

        Color m_diffuseColor;
        public Color DiffuseColor
        {
            get { return m_diffuseColor; }
            set { m_diffuseColor = value; }
        }

        Texture2D m_diffuse;
        public Texture2D Texture
        {
            get { return m_diffuse; }
            set { m_diffuse = value; }
        }

        bool m_useNormal;
        public bool UseNormal
        {
            get { return m_useNormal; }
            set { m_useNormal = value; }
        }

        Texture2D m_normal;
        public Texture2D Normal
        {
            get { return m_normal; }
            set { m_normal = value; }
        }

        float m_normalScale;
        public float NormalScale
        {
            get { return m_normalScale; }
            set { m_normalScale = value; }
        }

        bool m_useEmissive;
        public bool UseEmissive
        {
            get { return m_useEmissive; }
            set { m_useEmissive = value; }
        }

        Texture2D m_Emissive;
        public Texture2D Emissive
        {
            get { return m_Emissive; }
            set { m_Emissive = value; }
        }

        float m_specularIntensity;
        public float SpecularIntensity
        {
            get { return m_specularIntensity; }
            set { m_specularIntensity = value; }
        }

        float m_specularPower;
        public float SpecularPower
        {
            get { return m_specularPower; }
            set { m_specularPower = value; }
        }

        /// <summary>
        /// Obtain a new default Material
        /// </summary>
        public static Material Default
        {
            get { return new Material(); }
        }

        public Material()
        {
            UseDiffuseTexture = false;
            DiffuseColor = Color.Black;
            Texture = null;

            UseEmissive = false;
            Emissive = null;

            UseNormal = false;
            Normal = null;
            NormalScale = 1.0f;

            SpecularIntensity = 1.0f;
            SpecularPower = 24.0f;
        }
    }
}
