using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;
using Ika.Graphics;

namespace Ika.Graphics
{
    public class BoundingSphereMesh : Mesh
    {
        List<VertexPositionColor> m_vertexList;
        List<short> m_indexList;

        int m_nbVertex = 64;

        public BoundingSphereMesh(GraphicsDevice device)
        {
            m_vertexList = new List<VertexPositionColor>();
            m_indexList = new List<short>();

            createCircleX();
            createCircleY();
            createCircleZ();

            createBuffers(device);

            m_primitiveType = PrimitiveType.LineList;

            CreateBoundingSphere();
        }

        protected void createCircleX()
        {
            for (int i = 0; i < m_nbVertex;)
            {
                Vector3 pos = new Vector3(0, (float)Math.Sin(2 * Math.PI * i / m_nbVertex), (float)Math.Cos(2 * Math.PI * i / m_nbVertex));
                i++;
                Vector3 pos2 = new Vector3(0, (float)Math.Sin(2 * Math.PI * i / m_nbVertex), (float)Math.Cos(2 * Math.PI * i / m_nbVertex));
                i++;
                VertexPositionColor v1 = new VertexPositionColor(pos, Color.White);
                VertexPositionColor v2 = new VertexPositionColor(pos2, Color.White);
                m_vertexList.Add(v1);
                m_vertexList.Add(v2);
                m_indexList.Add((short)m_vertexList.LastIndexOf(v1));
                m_indexList.Add((short)m_vertexList.LastIndexOf(v2));
                m_primitiveCount++;
                m_verticesCount++;
                m_verticesCount++;
            }
        }

        protected void createCircleY()
        {
            for (int i = 0; i <= m_nbVertex;)
            {
                Vector3 pos1 = new Vector3((float)Math.Cos(2 * Math.PI * i / m_nbVertex), 0, (float)Math.Sin(2 * Math.PI * i / m_nbVertex));
                i++;
                Vector3 pos2 = new Vector3((float)Math.Cos(2 * Math.PI * i / m_nbVertex), 0, (float)Math.Sin(2 * Math.PI * i / m_nbVertex));
                i++;
                VertexPositionColor v1 = new VertexPositionColor(pos1, Color.White);
                VertexPositionColor v2 = new VertexPositionColor(pos2, Color.White);
                m_vertexList.Add(v1);
                m_vertexList.Add(v2);
                m_indexList.Add((short)m_vertexList.LastIndexOf(v1));
                m_indexList.Add((short)m_vertexList.LastIndexOf(v2));
                m_primitiveCount++;
                m_verticesCount++;
                m_verticesCount++;
            }
        }

        protected void createCircleZ()
        {
            for (int i = 0; i <= m_nbVertex;)
            {
                Vector3 pos1 = new Vector3((float)Math.Cos(2 * Math.PI * i / m_nbVertex), (float)Math.Sin(2 * Math.PI * i / m_nbVertex), 0);
                i++;
                Vector3 pos2 = new Vector3((float)Math.Cos(2 * Math.PI * i / m_nbVertex), (float)Math.Sin(2 * Math.PI * i / m_nbVertex), 0);
                i++;
                VertexPositionColor v1 = new VertexPositionColor(pos1, Color.White);
                VertexPositionColor v2 = new VertexPositionColor(pos2, Color.White);
                m_vertexList.Add(v1);
                m_vertexList.Add(v2);
                m_indexList.Add((short)m_vertexList.LastIndexOf(v1));
                m_indexList.Add((short)m_vertexList.LastIndexOf(v2));
                m_primitiveCount++;
                m_verticesCount++;
                m_verticesCount++;
            }
        }

        protected void createBuffers(GraphicsDevice device)
        {
            m_vertexBuffer = new VertexBuffer(device, typeof(VertexPositionColor), m_vertexList.Count, BufferUsage.None);
            m_vertexBuffer.SetData(m_vertexList.ToArray());

            m_indexBuffer = new IndexBuffer(device, typeof(short), m_indexList.Count, BufferUsage.None);
            m_indexBuffer.SetData(m_indexList.ToArray());

            m_vertexDeclaration = new VertexDeclaration(device, VertexPositionColor.VertexElements);
        }

        protected void CreateBoundingSphere()
        {
            BoundingSphere = new BoundingSphere(Vector3.Zero, 1.0f);
        }
    }
}
