using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;
using Ika.Graphics;

namespace Zombids.Graphics
{
    public class LineMesh : Mesh
    {
        List<VertexPositionColor> m_vertexList;
        List<short> m_indexList;

        public LineMesh(GraphicsDevice device)
        {
            m_vertexList = new List<VertexPositionColor>();
            m_indexList = new List<short>();

            createLine();
            createBuffers(device);

            m_primitiveType = PrimitiveType.LineList;

            CreateBoundingSphere();
        }

        protected void createLine()
        {
            VertexPositionColor v1 = new VertexPositionColor(new Vector3(-1.0f, 0.0f, 0.0f), Color.White);
            VertexPositionColor v2 = new VertexPositionColor(new Vector3(1.0f, 0.0f, 0.0f), Color.White);

            m_vertexList.Add(v1);
            m_vertexList.Add(v2);

            m_verticesCount = 2;

            m_indexList.Add((short)m_vertexList.IndexOf(v1));
            m_indexList.Add((short)m_vertexList.IndexOf(v2));

            m_primitiveCount = 1;
        }

        protected void createBuffers(GraphicsDevice device)
        {
            m_vertexBuffer = new VertexBuffer(device, typeof(VertexPositionColor), m_vertexList.Count, BufferUsage.None);
            m_vertexBuffer.SetData(m_vertexList.ToArray());

            m_indexBuffer = new IndexBuffer(device, typeof(short), m_indexList.Count, BufferUsage.None);
            m_indexBuffer.SetData(m_indexList.ToArray());

            m_vertexDeclaration = new VertexDeclaration(device, VertexPositionColor.VertexElements);
        }

        protected void CreateBoundingSphere()
        {
            List<Vector3> points = new List<Vector3>();
            foreach (VertexPositionColor vertex in m_vertexList)
            {
                points.Add( vertex.Position);
            }
            BoundingSphere =  BoundingSphere.CreateFromPoints(points.ToArray());
        }
    }
}
