using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;

namespace Ika.Graphics
{
    public abstract class Mesh
    {
        protected VertexBuffer m_vertexBuffer = null;
        public VertexBuffer VertexBuffer
        {
            get { return m_vertexBuffer; }
        }

        protected IndexBuffer m_indexBuffer = null;
        public IndexBuffer IndexBuffer
        {
            get { return m_indexBuffer; }
        }

        protected VertexDeclaration m_vertexDeclaration = null;
        public VertexDeclaration VertexDeclaration
        {
            get { return m_vertexDeclaration; }
        }

        protected int m_primitiveCount = 0;
        public int PrimitiveCount
        {
            get { return m_primitiveCount; }
        }

        protected int m_verticesCount = 0;
        public int VerticesCount
        {
            get { return m_verticesCount; }
        }

        protected BoundingSphere m_boundingSphere;
        public BoundingSphere BoundingSphere
        {
            get { return m_boundingSphere; }
            set { m_boundingSphere = value; }
        }

        protected PrimitiveType m_primitiveType;
        public PrimitiveType PrimitiveType
        {
            get { return m_primitiveType; }
            set { m_primitiveType = value; }
        }
    }
}
