using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;

namespace Ika.Graphics
{
    public class MeshHelper
    {
        public static BoundingSphere TransformBoundingSphere(BoundingSphere boundingSphere, Matrix World)
        {
            Vector3 scale;
            Quaternion rotation;
            Vector3 translatation;
            World.Decompose(out scale, out rotation, out translatation);
            float scalarScale = MathHelper.Max(scale.X, MathHelper.Max(scale.Y, scale.Z));

            BoundingSphere sphere;
            sphere.Center = boundingSphere.Center + translatation;
            sphere.Radius = boundingSphere.Radius * scalarScale;
            return sphere;
        }
    }
}
