using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;

namespace Ika.Graphics
{
    public class MeshImpl : Mesh
    {
        public MeshImpl(ModelMesh mesh, Matrix meshWorld)
        {
            m_vertexBuffer = mesh.VertexBuffer;
            m_indexBuffer = mesh.IndexBuffer;
            m_vertexDeclaration = mesh.MeshParts[0].VertexDeclaration;

            m_verticesCount = mesh.MeshParts[0].NumVertices;
            m_primitiveCount = mesh.MeshParts[0].PrimitiveCount;

            m_primitiveType = PrimitiveType.TriangleList;

            MatrixDecomposition decomp = new MatrixDecomposition(meshWorld);
            BoundingSphere sphere = mesh.BoundingSphere;

            sphere.Center = Vector3.Zero;
            sphere.Radius *= 1.5f;

            m_boundingSphere = sphere;
        }
    }
}
