using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;

namespace Ika.Graphics
{
    public class PlanMesh : Mesh
    {
        List<VertexPositionNormalTexture> m_vertexList;
        List<short> m_indexList;

        public PlanMesh(GraphicsDevice device)
        {
            m_vertexList = new List<VertexPositionNormalTexture>();
            m_indexList = new List<short>();            

            createQuad();
            createBuffers(device);

            m_primitiveType = PrimitiveType.TriangleList;

            CreateBoundingSphere();
        }

        protected void createQuad()
        {
            VertexPositionNormalTexture v1 = new VertexPositionNormalTexture(new Vector3(-1.0f, -1.0f, 0.0f), new Vector3(0, 0, -1.0f), new Vector2(0.0f, 0.0f));
            VertexPositionNormalTexture v2 = new VertexPositionNormalTexture(new Vector3(1.0f, -1.0f, 0.0f), new Vector3(0, 0, -1.0f), new Vector2(1.0f, 0.0f));
            VertexPositionNormalTexture v3 = new VertexPositionNormalTexture(new Vector3(1.0f, 1.0f, 0.0f), new Vector3(0, 0, -1.0f), new Vector2(1.0f, 1.0f));
            VertexPositionNormalTexture v4 = new VertexPositionNormalTexture(new Vector3(-1.0f, 1.0f, 0.0f), new Vector3(0, 0, -1.0f), new Vector2(0.0f, 1.0f));

            m_vertexList.Add(v1);
            m_vertexList.Add(v2);
            m_vertexList.Add(v3);
            m_vertexList.Add(v4);

            m_verticesCount = 4;

            m_indexList.Add((short)m_vertexList.IndexOf(v1));
            m_indexList.Add((short)m_vertexList.IndexOf(v3));
            m_indexList.Add((short)m_vertexList.IndexOf(v2));

            m_indexList.Add((short)m_vertexList.IndexOf(v1));
            m_indexList.Add((short)m_vertexList.IndexOf(v3));
            m_indexList.Add((short)m_vertexList.IndexOf(v4));

            m_primitiveCount = 2;
        }

        protected void createBuffers(GraphicsDevice device)
        {
            m_vertexBuffer = new VertexBuffer(device, typeof(VertexPositionNormalTexture), m_vertexList.Count, BufferUsage.None);
            m_vertexBuffer.SetData(m_vertexList.ToArray());

            m_indexBuffer = new IndexBuffer(device, typeof(short), m_indexList.Count, BufferUsage.None);
            m_indexBuffer.SetData(m_indexList.ToArray());

            m_vertexDeclaration = new VertexDeclaration(device, VertexPositionNormalTexture.VertexElements);
        }

        protected void CreateBoundingSphere()
        {
            List<Vector3> points = new List<Vector3>();
            foreach (VertexPositionNormalTexture vertex in m_vertexList)
            {
                points.Add( vertex.Position);
            }
            BoundingSphere =  BoundingSphere.CreateFromPoints(points.ToArray());
        }
    }
}
