using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;

namespace Ika.Graphics
{
    /// <summary>
    /// Respresents a textured 2D sprite
    /// </summary>
    public abstract class Sprite
    {
        Texture2D m_texture;
        /// <summary>
        /// Gets the sprite texture
        /// </summary>
        public Texture2D Texture
        {
            get { return m_texture; }
            set { m_texture = value; }
        }

        Vector2 m_origin;
        public Vector2 TextureSourceOrigin
        {
            get { return m_origin; }
            set { m_origin = value; }
        }

        Vector2 m_end;
        public Vector2 TextureSourceEnd
        {
            get { return m_end; }
            set { m_end = value; }
        }

        Vector2 m_size;
        /// <summary>
        /// The world size of the texture 
        /// </summary>
        public Vector2 Size
        {
            get { return m_size; }
            set { m_size = value; }
        }
    }
}
