using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;

namespace Ika.Graphics
{
    /// <summary>
    /// Represents a sprite using a single texture(a Sprite sheet) for multiple image
    /// It assumes the images are arranged horizontally in the sheet
    /// </summary>
    public class SpriteSheet : Sprite
    {
        Vector2 m_spriteSize;
        /// <summary>
        /// The size in pixel of a sprite in the sheet
        /// </summary>
        public Vector2 SpriteSize
        {
            get { return m_spriteSize; }
            set { m_spriteSize = value; }
        }

        protected int m_totalSprites;
        protected int m_usedSprites;
        protected int m_currentSprite;

        /// <summary>
        /// Create a SpriteSheet
        /// </summary>
        /// <param name="texture">The texture containing the Sprite sheet</param>
        /// <param name="size">The world size of the sprite</param>
        /// <param name="totalSprites">The number of sprite locations in the source texture</param>
        /// <param name="usedSprites">The number of sprite locations actually used</param>
        public SpriteSheet(Texture2D texture, Vector2 size, int totalSprites,  int usedSprites)
        {
            Texture = texture;

            m_totalSprites = totalSprites;
            m_usedSprites = usedSprites;

            m_currentSprite = 0;

            m_spriteSize.X = texture.Width / totalSprites;
            m_spriteSize.Y = texture.Height;

            TextureSourceOrigin = Vector2.Zero;
            TextureSourceEnd = SpriteSize;

            Size = size;
        }

        public void SetSprite(int i)
        {
            m_currentSprite = i % m_usedSprites;

            TextureSourceOrigin = Vector2.Zero + Vector2.UnitX * SpriteSize.X * m_currentSprite;
            TextureSourceEnd = TextureSourceOrigin + SpriteSize;
        }

        public void NextSprite()
        {
            SetSprite(m_currentSprite + 1);
        }
    }
}
