using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;

namespace Ika.Graphics
{
    /// <summary>
    /// Represents a basic sprite
    /// </summary>
    public class StaticSprite : Sprite
    {
        public StaticSprite(Texture2D texture, Vector2 size)
        {
            Texture = texture;
            TextureSourceOrigin = Vector2.Zero;
            TextureSourceEnd = new Vector2(Texture.Width, Texture.Height);

            Size = size;
        }

        public StaticSprite(Texture2D texture)
        {
            Texture = texture;
            TextureSourceOrigin = Vector2.Zero;
            TextureSourceEnd = new Vector2(Texture.Width, Texture.Height);

            Size = Vector2.One;
        }
    }
}
