using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using Microsoft.Xna.Framework.Content;

namespace Ika.Graphics
{
    /// <summary>
    /// Holds statistics about a rendered frame.
    /// </summary>
    public class FrameInfo
    {
        int m_primitiveCount = 0;

        public int PrimitiveCount
        {
            get { return m_primitiveCount; }
            set { m_primitiveCount = value; }
        }

        int m_modelCount = 0;
        public int ModelCount
        {
            get { return m_modelCount; }
            set { m_modelCount = value; }
        }

        int m_meshCount = 0;
        public int MeshCount
        {
            get { return m_meshCount; }
            set { m_meshCount = value; }
        }

        int m_lightCount = 0;

        public int LightCount
        {
            get { return m_lightCount; }
            set { m_lightCount = value; }
        }

        public override string ToString()
        {
            return "ModelCount: " + ModelCount + "\n" + "MeshCount: " + MeshCount + "\n" + "PrimitiveCount: " + PrimitiveCount;
        }
    }
}