using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;

namespace TestBoids.Sound
{
    class SoundManager : Microsoft.Xna.Framework.GameComponent
    {
        AudioEngine m_engine;
        WaveBank m_waveBank;
        SoundBank m_soundBank;

        public SoundManager(Game game)
            : base(game)
        {
        }

        public override void Initialize()
        {
            base.Initialize();

            m_engine = new AudioEngine("Content/Sounds/Birds.xgs");
            m_waveBank = new WaveBank(m_engine, "Content/Sounds/Waves.xwb");
            m_soundBank = new SoundBank(m_engine, "Content/Sounds/Sounds.xsb");

            Cue myMusic = m_soundBank.GetCue("rendered");
            myMusic.Play();
        }

        public void PlayCue(String name)
        {
            Cue mySound = m_soundBank.GetCue(name);
            mySound.Play();
        }
    }
}
