/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import processing.core.PConstants;
import processing.core.PImage;

public class PFont
implements PConstants {
    public int charCount;
    public PImage[] images;
    public Font font;
    public String name;
    public String psname;
    public int size;
    public boolean smooth;
    public int mbox2;
    protected float fwidth;
    protected float fheight;
    public int twidth;
    public int theight;
    public int[] value;
    public int[] height;
    public int[] width;
    public int[] setWidth;
    public int[] topExtent;
    public int[] leftExtent;
    public int ascent;
    public int descent;
    protected int[] ascii;
    static final char[] EXTRA_CHARS;
    public static char[] DEFAULT_CHARSET;

    public PFont() {
    }

    public PFont(InputStream inputStream) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.charCount = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        this.size = dataInputStream.readInt();
        this.mbox2 = dataInputStream.readInt();
        this.fwidth = this.size;
        this.fheight = this.size;
        this.twidth = this.theight = (this.mbox2 = (int)Math.pow(2.0, Math.ceil(Math.log(this.mbox2) / Math.log(2.0))));
        this.ascent = dataInputStream.readInt();
        this.descent = dataInputStream.readInt();
        this.value = new int[this.charCount];
        this.height = new int[this.charCount];
        this.width = new int[this.charCount];
        this.setWidth = new int[this.charCount];
        this.topExtent = new int[this.charCount];
        this.leftExtent = new int[this.charCount];
        this.ascii = new int[128];
        for (n = 0; n < 128; ++n) {
            this.ascii[n] = -1;
        }
        for (n = 0; n < this.charCount; ++n) {
            this.value[n] = dataInputStream.readInt();
            this.height[n] = dataInputStream.readInt();
            this.width[n] = dataInputStream.readInt();
            this.setWidth[n] = dataInputStream.readInt();
            this.topExtent[n] = dataInputStream.readInt();
            this.leftExtent[n] = dataInputStream.readInt();
            dataInputStream.readInt();
            if (this.value[n] < 128) {
                this.ascii[this.value[n]] = n;
            }
            if (this.value[n] == 100 && this.ascent == 0) {
                this.ascent = this.topExtent[n];
            }
            if (this.value[n] != 112 || this.descent != 0) continue;
            this.descent = -this.topExtent[n] + this.height[n];
        }
        if (this.ascent == 0 && this.descent == 0) {
            throw new RuntimeException("Please use \"Create Font\" to re-create this font.");
        }
        this.images = new PImage[this.charCount];
        for (n = 0; n < this.charCount; ++n) {
            this.images[n] = new PImage(this.twidth, this.theight, 4);
            int n3 = this.height[n] * this.width[n];
            byte[] byArray = new byte[n3];
            dataInputStream.readFully(byArray);
            int n4 = this.width[n];
            int n5 = this.height[n];
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n4; ++j) {
                    int n6;
                    this.images[n].pixels[i * this.twidth + j] = n6 = byArray[i * n4 + j] & 0xFF;
                }
            }
        }
        if (n2 >= 10) {
            this.name = dataInputStream.readUTF();
            this.psname = dataInputStream.readUTF();
        }
        if (n2 == 11) {
            this.smooth = dataInputStream.readBoolean();
        }
    }

    protected Font findFont() {
        this.font = new Font(this.name, 0, this.size);
        if (!this.font.getPSName().equals(this.psname)) {
            this.font = new Font(this.psname, 0, this.size);
        }
        if (!this.font.getPSName().equals(this.psname)) {
            this.font = null;
        }
        return this.font;
    }

    public void save(OutputStream outputStream) throws IOException {
        int n;
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(this.charCount);
        if (this.name == null || this.psname == null) {
            this.name = "";
            this.psname = "";
        }
        dataOutputStream.writeInt(11);
        dataOutputStream.writeInt(this.size);
        dataOutputStream.writeInt(this.mbox2);
        dataOutputStream.writeInt(this.ascent);
        dataOutputStream.writeInt(this.descent);
        for (n = 0; n < this.charCount; ++n) {
            dataOutputStream.writeInt(this.value[n]);
            dataOutputStream.writeInt(this.height[n]);
            dataOutputStream.writeInt(this.width[n]);
            dataOutputStream.writeInt(this.setWidth[n]);
            dataOutputStream.writeInt(this.topExtent[n]);
            dataOutputStream.writeInt(this.leftExtent[n]);
            dataOutputStream.writeInt(0);
        }
        for (n = 0; n < this.charCount; ++n) {
            for (int i = 0; i < this.height[n]; ++i) {
                for (int j = 0; j < this.width[n]; ++j) {
                    dataOutputStream.write(this.images[n].pixels[i * this.mbox2 + j] & 0xFF);
                }
            }
        }
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeUTF(this.psname);
        dataOutputStream.writeBoolean(this.smooth);
        dataOutputStream.flush();
    }

    public int index(char c) {
        if (this.charCount == 0) {
            return -1;
        }
        if (c < '\u0080') {
            return this.ascii[c];
        }
        return this.indexHunt(c, 0, this.charCount - 1);
    }

    protected int indexHunt(int n, int n2, int n3) {
        int n4 = (n2 + n3) / 2;
        if (n == this.value[n4]) {
            return n4;
        }
        if (n2 >= n3) {
            return -1;
        }
        if (n < this.value[n4]) {
            return this.indexHunt(n, n2, n4 - 1);
        }
        return this.indexHunt(n, n4 + 1, n3);
    }

    public float kern(char c, char c2) {
        return 0.0f;
    }

    public float ascent() {
        return (float)this.ascent / this.fheight;
    }

    public float descent() {
        return (float)this.descent / this.fheight;
    }

    public float width(char c) {
        if (c == ' ') {
            return this.width('i');
        }
        int n = this.index(c);
        if (n == -1) {
            return 0.0f;
        }
        return (float)this.setWidth[n] / this.fwidth;
    }

    public PFont(Font font, boolean bl, char[] cArray) {
        char c;
        int n;
        int n2;
        this.font = font;
        this.smooth = bl;
        this.name = font.getName();
        this.psname = font.getPSName();
        if (cArray != null) {
            Arrays.sort(cArray);
        }
        this.charCount = cArray == null ? 65536 : cArray.length;
        this.size = font.getSize();
        this.fwidth = this.fheight = (float)this.size;
        PImage[] pImageArray = new PImage[this.charCount];
        this.value = new int[this.charCount];
        this.height = new int[this.charCount];
        this.width = new int[this.charCount];
        this.setWidth = new int[this.charCount];
        this.topExtent = new int[this.charCount];
        this.leftExtent = new int[this.charCount];
        this.ascii = new int[128];
        for (n2 = 0; n2 < 128; ++n2) {
            this.ascii[n2] = -1;
        }
        n2 = this.size * 3;
        BufferedImage bufferedImage = new BufferedImage(n2, n2, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int[] nArray = new int[n2 * n2];
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.charCount; ++n) {
            int n5;
            int n6;
            int n7;
            char c2 = c = cArray == null ? (char)n : cArray[n];
            if (!font.canDisplay(c)) continue;
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n2, n2);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(String.valueOf(c), this.size, this.size * 2);
            Raster raster = bufferedImage.getData();
            raster.getSamples(0, 0, n2, n2, 0, nArray);
            int n8 = 1000;
            int n9 = 0;
            int n10 = 1000;
            int n11 = 0;
            boolean bl2 = false;
            for (n7 = 0; n7 < n2; ++n7) {
                for (n6 = 0; n6 < n2; ++n6) {
                    n5 = nArray[n7 * n2 + n6] & 0xFF;
                    if (n5 == 255) continue;
                    if (n6 < n8) {
                        n8 = n6;
                    }
                    if (n7 < n10) {
                        n10 = n7;
                    }
                    if (n6 > n9) {
                        n9 = n6;
                    }
                    if (n7 > n11) {
                        n11 = n7;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                n10 = 0;
                n8 = 0;
                n11 = 0;
                n9 = 0;
            }
            this.value[n4] = c;
            this.height[n4] = n11 - n10 + 1;
            this.width[n4] = n9 - n8 + 1;
            this.setWidth[n4] = fontMetrics.charWidth(c);
            if (c < '\u0080') {
                this.ascii[c] = n4;
            }
            this.topExtent[n4] = this.size * 2 - n10;
            this.leftExtent[n4] = n8 - this.size;
            if (c == 'd') {
                this.ascent = this.topExtent[n4];
            }
            if (c == 'p') {
                this.descent = -this.topExtent[n4] + this.height[n4];
            }
            if (this.width[n4] > n3) {
                n3 = this.width[n4];
            }
            if (this.height[n4] > n3) {
                n3 = this.height[n4];
            }
            pImageArray[n4] = new PImage(this.width[n4], this.height[n4], 4);
            for (n7 = n10; n7 <= n11; ++n7) {
                for (n6 = n8; n6 <= n9; ++n6) {
                    n5 = 255 - (nArray[n7 * n2 + n6] & 0xFF);
                    int n12 = (n7 - n10) * this.width[n4] + (n6 - n8);
                    pImageArray[n4].pixels[n12] = n5;
                }
            }
            ++n4;
        }
        this.charCount = n4;
        if (this.ascent == 0 && this.descent == 0) {
            for (n = 0; n < this.charCount; ++n) {
                int n13;
                c = (char)this.value[n];
                if (Character.isWhitespace(c) || c == '\u00a0' || c == '\u2007' || c == '\u202f') continue;
                if (this.topExtent[n] > this.ascent) {
                    this.ascent = this.topExtent[n];
                }
                if ((n13 = -this.topExtent[n] + this.height[n]) <= this.descent) continue;
                this.descent = n13;
            }
        }
        this.twidth = this.theight = (this.mbox2 = (int)Math.pow(2.0, Math.ceil(Math.log(n3) / Math.log(2.0))));
        this.images = new PImage[this.charCount];
        for (n = 0; n < this.charCount; ++n) {
            this.images[n] = new PImage(this.mbox2, this.mbox2, 4);
            for (c = '\u0000'; c < this.height[n]; ++c) {
                System.arraycopy(pImageArray[n].pixels, c * this.width[n], this.images[n].pixels, c * this.mbox2, this.width[n]);
            }
            pImageArray[n] = null;
        }
    }

    public static String[] list() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        String[] stringArray = new String[fontArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = fontArray[i].getName();
        }
        return stringArray;
    }

    static {
        int n;
        EXTRA_CHARS = new char[]{'\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00ba', '\u00bb', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00ff', '\u0102', '\u0103', '\u0104', '\u0105', '\u0106', '\u0107', '\u010c', '\u010d', '\u010e', '\u010f', '\u0110', '\u0111', '\u0118', '\u0119', '\u011a', '\u011b', '\u0131', '\u0139', '\u013a', '\u013d', '\u013e', '\u0141', '\u0142', '\u0143', '\u0144', '\u0147', '\u0148', '\u0150', '\u0151', '\u0152', '\u0153', '\u0154', '\u0155', '\u0158', '\u0159', '\u015a', '\u015b', '\u015e', '\u015f', '\u0160', '\u0161', '\u0162', '\u0163', '\u0164', '\u0165', '\u016e', '\u016f', '\u0170', '\u0171', '\u0178', '\u0179', '\u017a', '\u017b', '\u017c', '\u017d', '\u017e', '\u0192', '\u02c6', '\u02c7', '\u02d8', '\u02d9', '\u02da', '\u02db', '\u02dc', '\u02dd', '\u03a9', '\u03c0', '\u2013', '\u2014', '\u2018', '\u2019', '\u201a', '\u201c', '\u201d', '\u201e', '\u2020', '\u2021', '\u2022', '\u2026', '\u2030', '\u2039', '\u203a', '\u2044', '\u20ac', '\u2122', '\u2202', '\u2206', '\u220f', '\u2211', '\u221a', '\u221e', '\u222b', '\u2248', '\u2260', '\u2264', '\u2265', '\u25ca', '\uf8ff', '\ufb01', '\ufb02'};
        DEFAULT_CHARSET = new char[94 + EXTRA_CHARS.length];
        int n2 = 0;
        for (n = 33; n <= 126; ++n) {
            PFont.DEFAULT_CHARSET[n2++] = (char)n;
        }
        for (n = 0; n < EXTRA_CHARS.length; ++n) {
            PFont.DEFAULT_CHARSET[n2++] = EXTRA_CHARS[n];
        }
    }
}

