/*
 * Decompiled with CFR 0.152.
 */
package sojamo.drop;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import sojamo.drop.DropEvent;
import sojamo.drop.SDrop;

public class DropHandler
implements DropTargetListener {
    private final SDrop _mySDrop;

    public DropHandler(SDrop sDrop) {
        this._mySDrop = sDrop;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        int n = dropTargetDragEvent.getDropAction();
        if ((n & 1) != 0) {
            // empty if block
        }
        if ((n & 2) != 0) {
            // empty if block
        }
        if ((n & 0x40000000) != 0) {
            // empty if block
        }
        if (!this.isDragAcceptable(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this._mySDrop.getDropListeners().size() > 0) {
            this._mySDrop.updateDropListener((float)dropTargetDragEvent.getLocation().getX(), (float)dropTargetDragEvent.getLocation().getY());
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragAcceptable(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        DropEvent dropEvent = new DropEvent(this._mySDrop, dropTargetDropEvent);
        dropTargetDropEvent.acceptDrop(2);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            DataFlavor dataFlavor = dataFlavorArray[i];
            if (bl) {
                System.out.println("MIME type=" + dataFlavor.getMimeType() + "\n");
            }
            try {
                String[] stringArray;
                Object object;
                if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
                    object = (List)transferable.getTransferData(dataFlavor);
                    stringArray = object.iterator();
                    while (stringArray.hasNext()) {
                        dropEvent = new DropEvent(this._mySDrop, dropTargetDropEvent);
                        File file = (File)stringArray.next();
                        dropEvent.setFile(file);
                        dropEvent.setDropEvent(dropTargetDropEvent);
                        dropEvent.process();
                    }
                }
                if (dataFlavor.equals(DataFlavor.imageFlavor)) {
                    dropEvent = new DropEvent(this._mySDrop, dropTargetDropEvent);
                }
                if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                    dropEvent = new DropEvent(this._mySDrop, dropTargetDropEvent);
                    object = (String)transferable.getTransferData(dataFlavor);
                    if (((String)object).toLowerCase().startsWith("http://") || ((String)object).toLowerCase().startsWith("https://")) {
                        stringArray = ((String)object).split("\n");
                        if (stringArray.length > 0) {
                            object = stringArray[0];
                        }
                        if (((String)object).toLowerCase().endsWith(".jpg") || ((String)object).toLowerCase().endsWith(".jpeg") || ((String)object).toLowerCase().endsWith(".gif") || ((String)object).toLowerCase().endsWith(".png")) {
                            dropEvent.setImage(true);
                        }
                        dropEvent.setURL((String)object);
                    }
                    dropEvent.setText((String)object);
                    dropEvent.process();
                }
                dropEvent.setDropEvent(dropTargetDropEvent);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error: " + exception + "\n");
            }
        }
        dropTargetDropEvent.dropComplete(true);
    }

    public boolean isDragAcceptable(DropTargetDragEvent dropTargetDragEvent) {
        return (dropTargetDragEvent.getDropAction() & 3) != 0;
    }

    public boolean isDropAcceptable(DropTargetDropEvent dropTargetDropEvent) {
        return (dropTargetDropEvent.getDropAction() & 3) != 0;
    }
}

