
void setSK(int[] kicks) {
  OscMessage myOscMessage = new OscMessage("/setSK");
  for (int i=0;i<kicks.length;i++) {
    myOscMessage.add((int)kicks[i]);
  }
  oscP5.send(myOscMessage, myRemoteLocation);
}

void setSS(int[] snares) {
  OscMessage myOscMessage = new OscMessage("/setSS");
  for (int i=0;i<snares.length;i++) {
    myOscMessage.add((int)snares[i]);
  }
  oscP5.send(myOscMessage, myRemoteLocation);
}

void setSH(int[] hhs) {
  OscMessage myOscMessage = new OscMessage("/setSH");
  for (int i=0;i<hhs.length;i++) {
    myOscMessage.add((int)hhs[i]);
  }
  oscP5.send(myOscMessage, myRemoteLocation);
}

void resetSeqBase(int choix) {
  OscMessage myOscMessage = new OscMessage("/resetSB");
  myOscMessage.add((int)choix);  
  oscP5.send(myOscMessage, myRemoteLocation);
}

void setTempo(float tempo) {
  OscMessage myOscMessage = new OscMessage("/setTempo");
  myOscMessage.add((int)tempo);
  oscP5.send(myOscMessage, myRemoteLocation);
}

void setPropBase(float kP, float sP, float hP) {
  OscMessage myOscMessage = new OscMessage("/setPropBase");
  myOscMessage.add((int)kP);
  myOscMessage.add((int)sP);
  myOscMessage.add((int)hP);
  oscP5.send(myOscMessage, myRemoteLocation);
}

void setNewNote(int noteNo, float noteFreq, float notePan) {
  OscMessage myOscMessage = new OscMessage("/setNewNote");
  myOscMessage.add((int)noteNo);
  myOscMessage.add((float)noteFreq);
  myOscMessage.add((float)notePan);  
  oscP5.send(myOscMessage, myRemoteLocation);
}

void playEffect(int effectNb) {
  OscMessage myOscMessage = new OscMessage("/playEffect");
  myOscMessage.add((int)effectNb);
  oscP5.send(myOscMessage, myRemoteLocation);
}

void playLaser(float freq, float pan, int joue, int nb) {
  OscMessage myOscMessage = new OscMessage("/playLaser");
  myOscMessage.add((float)freq);
  myOscMessage.add((float)pan);
  myOscMessage.add((int)joue);
  myOscMessage.add((int)nb);  
  oscP5.send(myOscMessage, myRemoteLocation);
}
