
int nbTX;//nb de tiles en x
int nbTY;//nb de tiles en y
int nbTiles;
Tiles[][] tile;
int tDX;//tile de dpart en x
int tDY;//tile de dpart en y
int tAX;//tile d'arrive en x
int tAY;//tile d'arrive en y
float tM;//taille moyenne d'un tile

class Tiles {
  int cX;//case x
  int cY;//case y
  float x;
  float y;
  int t;
  int nb;
  boolean depart=false;
  float teinte;
  Tiles(float x, float y, int cX, int cY) {
    this.x=x;
    this.y=y;
    this.cX=cX;
    this.cY=cY;
  }
  float getx() {
    return x;
  }
  float gety() {
    return y;
  }
  void setteinte(float teinte) {
    this.teinte=teinte;    
  }
  float getteinte() {
    return teinte;    
  }  
  void setdepart(boolean depart) {
    this.depart=depart;
  }
  boolean getdepart() {
    return depart;
  }    
  void sett(int t) {
    this.t=t;
  }
  int gett() {
    return t;
  }
  void dessine() {
    strokeWeight((tX()+tY())/3);
    if (t==1 || t==2 || t==3 || t==4) stroke(teinte,64,64);
    if (t==5) stroke(teinte,64,128);
    if (depart) stroke(teinte,64,128);
    if (t==1) {
      line(x,y,x+tX(),y);
    }
    if (t==2) {
      line(x,y,x,y-tY());
    }
    if (t==3) {
      line(x,y,x-tX(),y);
    }
    if (t==4) {
      line(x,y,x,y+tY());
    }
    if (t==5) {
      point(x,y);
    }
  }
  void dessinePave() {
    if (t==6) {
      noFill();
      stroke(128,0,64);
      strokeWeight(tM/5);
      rect(x-tX()/3,y-tY()/3,tX()*2/3,tY()*2/3);
      if (cX==selectX&&cY==selectY) {
        strokeWeight(1);
        stroke(16,192,192);
        noFill();
        rect(x-tX()/2,y-tY()/2,tX(),tY());
      }      
    }
  }  
  void indicLibre() {
    if (niveauOk) {  
      noStroke();
      if (t==0) {
        fill(144,256,256,32);
      }
      else{
        fill(16,256,256,32);          
      }
      rect(x-tX()/2,y-tY()/2,tX(),tY());
    }
  }
}

void initTiles() {
  nbTX=50;//nb de tiles en x
  nbTY=50;//nb de tiles en y
  nbTiles=nbTX*nbTY;
  tile=new Tiles[nbTX][nbTY];
  for (int x=0;x<nbTX;x++) {
    for (int y=0;y<nbTY;y++) {
      tile[x][y]=new Tiles((float)x*width/nbTX+mX(),(float)y*height/nbTY+mY(),x,y);
    }
  }
}

void genereT() {
  //0=vide
  //1=droite
  //2=haut
  //3=gauche
  //4=bas
  //5=arrive
  //6=tour
  float[] base=val(4,0,1);
  float lMin=constrain(map(fInput.length,100,1000000,50,200),10,500);
  float lMax=constrain(map(fInput.length,1000,1000000,100,500),10,500);
  int tmpLongueur=floor(map(base[0],0,1,lMin,lMax));//longueur de la chaine
  int tmpDX =floor(map(base[1],0,1,nbTX*1/3,nbTX*2/3));
  int tmpDY =floor(map(base[2],0,1,nbTY*1/3,nbTY*2/3));
  float tmpTeinte =floor(map(base[3],0,1,0,256));
  for (int x=0;x<nbTX;x++) {
    for (int y=0;y<nbTY;y++) {
      tile[x][y].sett(0);
      tile[x][y].setteinte(tmpTeinte);
    }
  }
  int[] tmpTypes=valI(tmpLongueur,1,4);
  int tmpTAX=tmpDX;//tile actuelle traite en X
  int tmpTAY=tmpDY;//tile actuelle traite en Y
  int tmpI=0;//numro trait dans la chaine
  int nbVerifs=0;//nombre de modif/verifs faites
  tile[tmpTAX][tmpTAY].setdepart(true);
  while(tmpI<tmpLongueur) {
    tile[tmpTAX][tmpTAY].sett(tmpTypes[tmpI]);
    if (tmpI==tmpLongueur-1) tile[tmpTAX][tmpTAY].sett(5);
    if (verifT(tmpTAX,tmpTAY,tmpTypes[tmpI])) {
      if (tmpTypes[tmpI]==1) tmpTAX++;
      if (tmpTypes[tmpI]==2) tmpTAY--;
      if (tmpTypes[tmpI]==3) tmpTAX--;
      if (tmpTypes[tmpI]==4) tmpTAY++;
      tmpI++;
      nbVerifs=0;
    }
    else {
      nbVerifs++;
      tmpTypes[tmpI]=max((tmpTypes[tmpI]+1)%5,1);
      if (nbVerifs>3) {
        tile[tmpTAX][tmpTAY].sett(5);
        tmpI=tmpLongueur;
      }
    }
  }
}

boolean verifT(int tAX, int tAY, int t) {//est vrai si la tile est libre et existante
  boolean verifT=true;
  if (t==1) {
    if (tAX+1>=nbTX) {
      verifT=false;
    }
    else{
      if (tile[tAX+1][tAY].gett()!=0) verifT=false;
    }
  }
  if (t==2) {
    if (tAY-1<0) {
      verifT=false;    
    }
    else{
      if (tile[tAX][tAY-1].gett()!=0) verifT=false;
    }
  }
  if (t==3) {
    if (tAX-1<0) {
      verifT=false;    
    }
    else{
      if (tile[tAX-1][tAY].gett()!=0) verifT=false;
    }
  }
  if (t==4) {
    if (tAY+1>=nbTY) {
      verifT=false;    
    }
    else{
      if (tile[tAX][tAY+1].gett()!=0) verifT=false;
    }
  }
  return verifT;
}

void recentreMap() {
  if (tile.length>2) {
    nViable=true;
  }
  else{
    nViable=false;
  }
  int dX=-1;//debut en x
  int dY=-1;//debut en y
  int fX=-1;//fin en x
  int fY=-1;//fin en y
  boolean ok=false;
  for (int x=0;x<nbTX&&!ok;x++) {
    for (int y=0;y<nbTY&&!ok;y++) {
      if (tile[x][y].gett()!=0) {
        dX=constrain(x-3,0,nbTX-1);
        ok=true;
      }
    }
  }
  ok=false;
  for (int y=0;y<nbTY&&!ok;y++) {  
    for (int x=0;x<nbTX&&!ok;x++) {
      if (tile[x][y].gett()!=0) {
        dY=constrain(y-3,0,nbTY-1);
        ok=true;
      }
    }
  }
  ok=false;
  for (int x=nbTX-1;x>=0&&!ok;x--) {
    for (int y=nbTY-1;y>=0&&!ok;y--) {
      if (tile[x][y].gett()!=0) {
        fX=constrain(x+3,0,nbTX-1);
        ok=true;
      }
    }
  }
  ok=false;  
  for (int y=nbTY-1;y>=0&&!ok;y--) {
    for (int x=nbTX-1;x>=0&&!ok;x--) {
      if (tile[x][y].gett()!=0) {
        fY=constrain(y+3,0,nbTY-1);
        ok=true;        
      }
    }
  }
  Tiles[][] tmpTile=tile;
  nbTX=(fX-dX)+1;//nb de tiles en x
  nbTY=(fY-dY)+1;//nb de tiles en y
  nbTiles=nbTX*nbTY;
  float mX=(float)width/(nbTX*2);
  float mY=(float)height/(nbTY*2);  
  for (int x=0;x<nbTX;x++) {
    for (int y=0;y<nbTY;y++) {
      tile[x][y]=new Tiles((float)x*width/nbTX+mX,(float)y*height/nbTY+mY,x,y);
      tile[x][y].sett(tmpTile[x+dX][y+dY].gett());
      tile[x][y].setdepart(tmpTile[x+dX][y+dY].getdepart());
      tile[x][y].setteinte(tmpTile[x+dX][y+dY].getteinte());      
      if (tile[x][y].getdepart()) {
        tDX=x;
        tDY=y;
      }
      if (tile[x][y].gett()==5) {
        tAX=x;
        tAY=y;
      }
    }
  }
  tM=(width/nbTX+height/nbTY)/2;
  nbTowers=nbTX*nbTY;
  tower=new Towers[nbTowers];
}

void setSeqBase() {
  int[] nbElem=valI(3,0,16);
  int nbKicks=nbElem[0];
  int nbSnares=nbElem[1];
  int nbHhs=nbElem[2];
  int[] kicks=valI(nbKicks,0,16);
  int[] snares=valI(nbSnares,0,16);
  int[] hhs=valI(nbHhs,0,16);
  resetSeqBase(1);
  setSK(kicks);
  setSS(snares);
  setSH(hhs);
  float tempo=val(1,100,300)[0];
  setTempo(tempo);
  float[] props=val(3,0,1);
  float kInitPitch=map(props[0],0,1,500,2000);
  float sFiltreCut=map(props[1],0,1,500,2000);
  float hFadeTime=map(props[2],0,1,1,300);
  setPropBase(kInitPitch,sFiltreCut,hFadeTime);
}

void drawTiles() {
  pushMatrix();
  if(!niveauOk) {
    translate(width/4,height/4);
    scale(0.5,0.5);
  }
  if (nPret) {
  for (int x=0;x<nbTX;x++) {
    for (int y=0;y<nbTY;y++) {
      tile[x][y].dessinePave();
    }
  }
  for (int x=0;x<nbTX;x++) {
    for (int y=0;y<nbTY;y++) {
      tile[x][y].dessine();
    }
  }  
  tile[tAX][tAY].dessine();
  tile[tDX][tDY].dessine();
  }
  popMatrix();  
}

void indicLibres() {
  if (tProj.getactive()) {
    for (int x=0;x<nbTX;x++) {
      for (int y=0;y<nbTY;y++) {
        tile[x][y].indicLibre();
      }
    }
  }
}

float tX() {
  return (float)width/nbTX;
}
float tY() {
  return (float)height/nbTY;
}

float mX() {
  return (float)width/(nbTX*2);
}

float mY() {
  return (float)height/(nbTY*2);  
}

void selectionT() {  
}
