/*
 * Decompiled with CFR 0.152.
 */
package krister.Ess;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import krister.Ess.AudioOutput;
import krister.Ess.Ess;
import krister.Ess.SPIWorkaround;
import processing.core.PApplet;

public final class AudioChannel
extends AudioOutput {
    protected PlayThread playThread;
    private int rCue;
    private int rLoop;
    private int rIn;
    private int rOut;
    private int bufferSamplesStart;
    private AudioOutput.EventDispatcher audioChannelDoneED;
    private AudioOutput.EventDispatcher audioChannelLoopED;
    public float[] samples;
    public int cue;
    public int loop;
    public int in;
    public int out;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;
    static /* synthetic */ Class class$krister$Ess$AudioChannel;
    static /* synthetic */ Class class$krister$Ess$AudioOutput;

    public AudioChannel() {
        this.setup(Ess.DEFAULT_BUFFER_SIZE, 44100.0f);
    }

    public AudioChannel(int n) {
        this.setup(Ess.DEFAULT_BUFFER_SIZE, 44100.0f);
        this.initChannel(n);
    }

    public AudioChannel(int n, float f) {
        this.setup(Ess.DEFAULT_BUFFER_SIZE, f);
        this.initChannel(n);
    }

    public AudioChannel(String string) {
        this.setup(Ess.DEFAULT_BUFFER_SIZE, 44100.0f);
        this.loadSound(string);
    }

    public AudioChannel(String string, int n) {
        this.setup(Ess.DEFAULT_BUFFER_SIZE, 44100.0f);
        this.loadSound(string, n);
    }

    public void destroy() {
        if (this.audioChannelDoneED != null) {
            this.audioChannelDoneED.kill = true;
        }
        if (this.audioChannelLoopED != null) {
            this.audioChannelLoopED.kill = true;
        }
        if (this.audioOutputFadeED != null) {
            this.audioOutputFadeED.kill = true;
        }
        if (this.audioOutputPanED != null) {
            this.audioOutputPanED.kill = true;
        }
        this.stopSound();
        this.stopFade();
        this.stopPan();
        this.audioChannelDoneED = null;
        this.audioChannelLoopED = null;
        this.audioOutputFadeED = null;
        this.audioOutputPanED = null;
        this.playThread = null;
        this.fadeThread = null;
        this.panThread = null;
        this.line.stop();
        this.line.close();
        Ess.unregisterAudioChannel(this);
    }

    public void sampleRate(float f) {
        this.sampleRate(f, false);
    }

    public void sampleRate(float f, boolean bl) {
        this.stopSound();
        this.line.stop();
        this.line.close();
        if (bl) {
            float f2 = this.rSampleRate;
            this.setupLine(this.buffer.length, f);
            this.samples = Ess.rateConvert(this.samples, f2, f);
            this.rIn = (int)((float)this.rIn / f2 * f);
            this.rOut = (int)((float)this.rOut / f2 * f);
            this.rCue = (int)((float)this.rCue / f2 * f);
            this.in = this.rIn = Math.min(this.samples.length - 1, Math.max(0, this.rIn));
            this.out = this.rOut = Math.min(this.samples.length - 1, Math.max(0, this.rOut));
            this.cue = this.rCue = Math.min(this.rOut, this.rCue);
        } else {
            this.setupLine(this.buffer.length, f);
        }
        this.setTimeFields();
    }

    public void bufferSize(int n) {
        this.stopSound();
        this.line.stop();
        this.line.close();
        this.setupLine(n, this.rSampleRate);
    }

    public void initChannel(int n) {
        this.playThread.blockWrite = true;
        while (this.playThread.writing) {
        }
        this.samples = new float[n];
        this.rIn = 0;
        this.in = 0;
        this.out = this.rOut = n - 1;
        this.rCue = 0;
        this.cue = 0;
        this.setTimeFields();
        this.playThread.blockWrite = false;
    }

    public void adjustChannel(int n, int n2) {
        this.playThread.blockWrite = true;
        while (this.playThread.writing) {
        }
        int n3 = 0;
        if (n2 == 1) {
            if (n < 0) {
                n3 = -n;
                float[] fArray = new float[this.samples.length + n];
                System.arraycopy(this.samples, -n, fArray, 0, fArray.length);
                this.samples = fArray;
            } else {
                n3 = n;
                float[] fArray = new float[this.samples.length + n];
                System.arraycopy(this.samples, 0, fArray, n, this.samples.length);
                this.samples = fArray;
            }
        } else if (n2 == 2) {
            if (n < 0) {
                float[] fArray = new float[this.samples.length + n];
                System.arraycopy(this.samples, 0, fArray, 0, fArray.length);
                this.samples = fArray;
            } else {
                float[] fArray = new float[this.samples.length + n];
                System.arraycopy(this.samples, 0, fArray, 0, this.samples.length);
                this.samples = fArray;
            }
        }
        this.in = this.rIn = Math.min(this.samples.length - 1, Math.max(0, this.rIn + n3));
        this.out = this.rOut = Math.min(this.samples.length - 1, Math.max(0, this.rOut));
        this.cue = this.rCue = Math.min(this.rOut, Math.max(0, this.rCue + n3));
        this.setTimeFields();
        this.playThread.blockWrite = false;
    }

    public void loadSound(String string) {
        this.loadSound(string, 2);
    }

    public void loadSound(String string, int n) {
        AudioInputStream audioInputStream = null;
        try {
            Object object;
            if (string.startsWith("http://")) {
                object = new URL(string);
                audioInputStream = SPIWorkaround.getAudioInputStream((URL)object);
            } else {
                object = Ess.parent.getClass().getClassLoader().getResource("data/" + string);
                if (object != null) {
                    audioInputStream = SPIWorkaround.getAudioInputStream((URL)object);
                } else {
                    File file = new File(Ess.parent.dataPath(string));
                    audioInputStream = SPIWorkaround.getAudioInputStream(file);
                }
            }
            try {
                object = audioInputStream.getFormat();
                int n2 = ((AudioFormat)object).getChannels();
                if (n2 > 2) {
                    n2 = 1;
                }
                AudioFormat audioFormat = new AudioFormat(((AudioFormat)object).getSampleRate(), 16, n2, true, true);
                AudioInputStream audioInputStream2 = SPIWorkaround.getAudioInputStream(audioFormat, audioInputStream, string);
                int n3 = 524288;
                byte[] byArray = new byte[n3];
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                while ((n4 = audioInputStream2.read(byArray, n6 + n7, n3 - n6)) != -1) {
                    if ((n6 += n4) == n3) {
                        byte[] byArray2 = byArray;
                        byArray = new byte[(n7 += n3) + n3];
                        System.arraycopy(byArray2, 0, byArray, 0, n7);
                        n6 = 0;
                    }
                    n5 += n4;
                }
                if (n2 == 2) {
                    int n8 = 0;
                    switch (n) {
                        case -1: {
                            int n9;
                            for (n9 = 0; n9 < n5; n9 += 4) {
                                byArray[n8] = byArray[n9];
                                byArray[n8 + 1] = byArray[n9 + 1];
                                n8 += 2;
                            }
                            break;
                        }
                        case 1: {
                            int n9;
                            for (n9 = 0; n9 < n5; n9 += 4) {
                                byArray[n8] = byArray[n9 + 2];
                                byArray[n8 + 1] = byArray[n9 + 3];
                                n8 += 2;
                            }
                            break;
                        }
                        case 2: {
                            int n9 = n5 / 2;
                            for (int i = 0; i < n9; i += 2) {
                                int n10 = Ess.getFrame(byArray, i);
                                int n11 = Ess.getFrame(byArray, i + 1);
                                Ess.setFrame(byArray, n8, (int)((double)n10 * 0.5 + (double)n11 * 0.5));
                                ++n8;
                            }
                            break;
                        }
                    }
                    n5 /= 2;
                }
                this.stopSound();
                this.line.stop();
                this.line.close();
                this.setupLine(this.buffer.length, ((AudioFormat)object).getSampleRate());
                this.samples = new float[n5 / 2];
                for (int i = 0; i < this.samples.length; ++i) {
                    this.samples[i] = (float)Ess.getFrame(byArray, i) / 32767.0f;
                }
                this.rIn = 0;
                this.in = 0;
                this.out = this.rOut = n5 / 2 - 1;
                this.rCue = 0;
                this.cue = 0;
                this.setTimeFields();
            }
            catch (Exception exception) {
                PApplet.println((String)("Unable to load sound " + string));
            }
        }
        catch (Exception exception) {
            PApplet.println((String)("Unable to load sound " + string));
        }
    }

    public void saveSound(String string) {
        this.saveSound(string, 0, this.samples.length);
    }

    public void saveSound(String string, int n, int n2) {
        n2 = Math.min(n + n2, this.samples.length) - n;
        int n3 = 1;
        if (string.endsWith(".wav")) {
            n3 = 2;
        }
        byte[] byArray = new byte[this.samples.length * 2];
        for (int i = 0; i < n2; ++i) {
            Ess.setFrame(byArray, i, (int)(this.samples[i + n] * 32767.0f));
        }
        File file = new File(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n * 2, n2 * 2);
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, new AudioFormat(this.rSampleRate, 16, 1, true, true), n2);
        try {
            if (n3 == 2) {
                AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, file);
            } else {
                AudioSystem.write(audioInputStream, AudioFileFormat.Type.AIFF, file);
            }
        }
        catch (IOException iOException) {
            PApplet.println((String)("Unable to save sound " + string));
        }
    }

    public void play() {
        this.play(1);
    }

    public void play(int n) {
        if (this.samples != null) {
            this.loop = this.rLoop = n;
            this.playThread.resetLoop = this.rLoop;
            this.playThread.resetIn = this.rCue;
            if (this.rState != 2) {
                this.cue(this.rCue);
                new Thread(Ess.tg, this.playThread).start();
            } else {
                this.playThread.reset = true;
            }
        }
    }

    public void stop() {
        this.stopSound();
        this.cue(this.rIn);
    }

    public void pause() {
        this.stopSound();
    }

    public void resume() {
        if (this.samples != null && this.rState != 2) {
            new Thread(Ess.tg, this.playThread).start();
        }
    }

    public void cue(int n) {
        this.playThread.blockWrite = true;
        while (this.playThread.writing) {
        }
        this.cue = this.rCue = Math.min(this.rOut, Math.max(0, n));
        this.playThread.blockWrite = false;
    }

    public void loop() {
        this.loop(-1);
    }

    public void loop(int n) {
        this.playThread.blockWrite = true;
        while (this.playThread.writing) {
        }
        this.loop = this.rLoop = n;
        this.playThread.blockWrite = false;
    }

    public void in(int n) {
        this.playThread.blockWrite = true;
        while (this.playThread.writing) {
        }
        if ((n = Math.min(this.samples.length - 1, Math.max(0, n))) > this.rOut) {
            n = this.rOut;
        }
        this.in = this.rIn = n;
        this.playThread.blockWrite = false;
    }

    public void out(int n) {
        this.playThread.blockWrite = true;
        while (this.playThread.writing) {
        }
        if ((n = Math.min(this.samples.length - 1, Math.max(0, n))) < this.rIn) {
            n = this.rIn;
        }
        if (this.rCue > n) {
            this.cue = this.rCue = n;
        }
        this.out = this.rOut = n;
        this.playThread.blockWrite = false;
    }

    public void snapInToZero() {
        this.snapInToZero(this.samples.length);
    }

    public void snapInToZero(int n) {
        this.playThread.blockWrite = true;
        while (this.playThread.writing) {
        }
        int n2 = this.rIn;
        int n3 = this.rIn;
        while (n-- > 0) {
            if (--n2 < 0) {
                ++n2;
            }
            if (this.samples[n2] == 0.0f && this.samples[n2 + 1] == 0.0f) {
                this.in = this.rIn = n2;
                break;
            }
            if (++n3 >= this.samples.length) {
                --n3;
            }
            if (this.samples[n3] == 0.0f && this.samples[n3 + 1] == 0.0f) {
                this.in = this.rIn = n3;
                break;
            }
            if (n2 != 0 || n3 != this.samples.length - 1) continue;
        }
        this.playThread.blockWrite = false;
    }

    public void snapOutToZero() {
        this.snapOutToZero(this.samples.length);
    }

    public void snapOutToZero(int n) {
        this.playThread.blockWrite = true;
        while (this.playThread.writing) {
        }
        int n2 = this.rOut;
        int n3 = this.rOut;
        while (n-- > 0) {
            if (++n3 >= this.samples.length) {
                --n3;
            }
            if (this.samples[n3] == 0.0f && this.samples[n3 + 1] == 0.0f) {
                this.out = this.rOut = n3;
                break;
            }
            if (--n2 < 0) {
                ++n2;
            }
            if (this.samples[n2] == 0.0f && this.samples[n2 + 1] == 0.0f) {
                this.out = this.rOut = n2;
                break;
            }
            if (n2 != 0 || n3 != this.samples.length - 1) continue;
        }
        this.cue = this.rCue = Math.min(this.rOut, this.rCue);
        this.playThread.blockWrite = false;
    }

    public int getCurrentPlayFrame() {
        if (this.rState == 2) {
            int n;
            int n2;
            float f = (float)this.frames((int)(System.currentTimeMillis() - (long)this.rBufferStartTime)) / (float)this.buffer.length;
            int n3 = (int)((1.0f - f) * (float)(n2 = this.bufferSamplesStart) + f * (float)(n = n2 + this.buffer.length - 1));
            if (n3 > this.rOut) {
                n3 = this.rLoop == 0 ? 0 : (n3 - this.rIn) % (this.rOut - this.rIn + 1) + this.rIn;
            }
            return n3;
        }
        return 0;
    }

    protected final float[] getAudioData() {
        return this.samples;
    }

    protected final int getOut() {
        return this.rOut;
    }

    private void setupLine(int n, float f) {
        this.sampleRate = this.rSampleRate = f;
        this.format = new AudioFormat(this.rSampleRate, 16, 2, true, true);
        this.info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = AudioChannel.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, this.format);
        try {
            this.line = (SourceDataLine)Ess.outputMixer.getLine(this.info);
            this.buffer = new float[n];
            this.buffer2 = new float[n * 2];
            this.zeroBuffer = new byte[n * 4];
            this.stereoBuffer = new byte[n * 4];
            this.line.open(this.format, n * 2);
            this.line.start();
        }
        catch (LineUnavailableException lineUnavailableException) {
            lineUnavailableException.printStackTrace();
        }
    }

    private void stopSound() {
        if (this.rState == 2) {
            this.playThread.stop();
            if (this.line != null) {
                this.line.flush();
            }
        }
    }

    private void setTimeFields() {
        if (this.samples != null) {
            this.duration = this.ms(this.samples.length);
            this.size = this.samples.length;
        }
    }

    private void setup(int n, float f) {
        Method method;
        this.playThread = new PlayThread();
        this.fadeThread = new AudioOutput.FadeThread(this);
        this.panThread = new AudioOutput.PanThread(this);
        this.updateBuffer2 = true;
        this.softClip = false;
        this.smoothPan = false;
        this.size = 0;
        this.rState = 1;
        this.state = 1;
        this.duration = 0;
        this.rCue = 0;
        this.cue = 0;
        this.rLoop = 0;
        this.loop = 0;
        this.rIn = 0;
        this.in = 0;
        this.rOut = 0;
        this.out = 0;
        this.rPanning = false;
        this.rFading = false;
        this.panning = false;
        this.fading = false;
        this.setupLine(n, f);
        this.volume(1.0f);
        this.pan(0.0f);
        this.mute(false);
        Ess.registerAudioChannel(this);
        try {
            method = Ess.parent.getClass().getMethod("audioChannelDone", class$krister$Ess$AudioChannel == null ? (class$krister$Ess$AudioChannel = AudioChannel.class$("krister.Ess.AudioChannel")) : class$krister$Ess$AudioChannel);
            this.audioChannelDoneED = new AudioOutput.EventDispatcher(this, method, this);
            new Thread(Ess.tg, this.audioChannelDoneED).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            method = Ess.parent.getClass().getMethod("audioChannelLoop", class$krister$Ess$AudioChannel == null ? (class$krister$Ess$AudioChannel = AudioChannel.class$("krister.Ess.AudioChannel")) : class$krister$Ess$AudioChannel);
            this.audioChannelLoopED = new AudioOutput.EventDispatcher(this, method, this);
            new Thread(Ess.tg, this.audioChannelLoopED).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            method = Ess.parent.getClass().getMethod("audioOutputFade", class$krister$Ess$AudioOutput == null ? (class$krister$Ess$AudioOutput = AudioChannel.class$("krister.Ess.AudioOutput")) : class$krister$Ess$AudioOutput);
            this.audioOutputFadeED = new AudioOutput.EventDispatcher(this, method, this);
            new Thread(Ess.tg, this.audioOutputFadeED).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            method = Ess.parent.getClass().getMethod("audioOutputPan", class$krister$Ess$AudioOutput == null ? (class$krister$Ess$AudioOutput = AudioChannel.class$("krister.Ess.AudioOutput")) : class$krister$Ess$AudioOutput);
            this.audioOutputPanED = new AudioOutput.EventDispatcher(this, method, this);
            new Thread(Ess.tg, this.audioOutputPanED).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class PlayThread
    implements Runnable {
        public boolean blockWrite;
        public boolean writing;
        public boolean kill;
        public boolean reset;
        public int resetIn;
        public int resetLoop;
        private float startPan;

        private PlayThread() {
        }

        public void run() {
            this.reset = false;
            this.kill = false;
            this.writing = false;
            this.blockWrite = false;
            int n = AudioChannel.this.rCue;
            int n2 = AudioChannel.this.buffer.length;
            this.startPan = AudioChannel.this.rPan;
            boolean bl = false;
            AudioChannel.this.bufferStartTime = AudioChannel.this.rBufferStartTime = (AudioChannel.this.bufferSamplesStart = 0);
            AudioChannel.this.rState = 2;
            AudioChannel.this.state = 2;
            int n3 = AudioChannel.this.rCue;
            int n4 = AudioChannel.this.rCue;
            while (!(AudioChannel.this.rLoop <= 0 && AudioChannel.this.rLoop != -1 || this.kill)) {
                while (this.blockWrite) {
                }
                this.writing = true;
                int n5 = n2;
                n3 = n4 = AudioChannel.this.rCue;
                while (n5 > 0 && !this.kill && !this.reset) {
                    int n6 = AudioChannel.this.rOut - n4 + 1;
                    if (n6 < n5) {
                        System.arraycopy(AudioChannel.this.samples, n4, AudioChannel.this.buffer, n2 - n5, n6);
                        n5 -= n6;
                        bl = true;
                    } else {
                        System.arraycopy(AudioChannel.this.samples, n4, AudioChannel.this.buffer, n2 - n5, n5);
                        n5 = 0;
                        if ((n4 += n5) >= AudioChannel.this.rOut) {
                            bl = true;
                        }
                    }
                    if (!bl || this.reset) continue;
                    if (AudioChannel.this.rLoop == 1) {
                        for (int i = n2 - n5; i < n2; ++i) {
                            AudioChannel.this.buffer[i] = 0.0f;
                        }
                        n5 = 0;
                        AudioChannel.this.loop = AudioChannel.this.rLoop = 0;
                    } else {
                        if (AudioChannel.this.rLoop != -1) {
                            AudioChannel.this.rLoop--;
                            AudioChannel.this.loop = AudioChannel.this.rLoop;
                        }
                        n4 = AudioChannel.this.rIn;
                        if (AudioChannel.this.audioChannelLoopED != null) {
                            ((AudioChannel)AudioChannel.this).audioChannelLoopED.trigger = true;
                        }
                    }
                    bl = false;
                }
                this.writing = false;
                if (this.reset) {
                    AudioChannel.this.loop = AudioChannel.this.rLoop = this.resetLoop;
                    n4 = this.resetIn;
                    n3 = AudioChannel.this.cue = (AudioChannel.this.rCue = n4);
                    this.reset = false;
                    continue;
                }
                if (this.kill) continue;
                AudioChannel.this.cue = AudioChannel.this.rCue = n4;
                if (AudioChannel.this.updateBuffer2) {
                    System.arraycopy(AudioChannel.this.buffer2, n2, AudioChannel.this.buffer2, 0, n2);
                    System.arraycopy(AudioChannel.this.buffer, 0, AudioChannel.this.buffer2, n2, n2);
                }
                this.outputBuffer(AudioChannel.this.buffer, n3);
            }
            if (!this.kill) {
                AudioChannel.this.line.drain();
                AudioChannel.this.cue = AudioChannel.this.rCue = AudioChannel.this.rIn;
                if (AudioChannel.this.audioChannelDoneED != null) {
                    ((AudioChannel)AudioChannel.this).audioChannelDoneED.trigger = true;
                }
            }
            AudioChannel.this.rState = 1;
            AudioChannel.this.state = 1;
        }

        private void outputBuffer(float[] fArray, int n) {
            int n2 = fArray.length;
            if (!Ess.getMasterMute() && !AudioChannel.this.rMute) {
                int n3 = n2;
                float f = AudioChannel.this.rVolume * Ess.getMasterVolume();
                int n4 = 0;
                if (this.startPan == AudioChannel.this.rPan || !AudioChannel.this.smoothPan) {
                    this.startPan = AudioChannel.this.rPan;
                    float f2 = (this.startPan + 1.0f) / 2.0f;
                    float f3 = 1.0f - f2;
                    for (int i = 0; i < n3; ++i) {
                        float f4 = fArray[i] * f;
                        if (AudioChannel.this.softClip) {
                            f4 = AudioOutput.softClip(f4);
                        }
                        Ess.setFrame(AudioChannel.this.stereoBuffer, n4++, (int)((f4 *= 32767.0f) * f3));
                        Ess.setFrame(AudioChannel.this.stereoBuffer, n4++, (int)(f4 * f2));
                    }
                } else {
                    float f5 = (this.startPan + 1.0f) / 2.0f;
                    float f6 = 1.0f - f5;
                    for (int i = 0; i < n3; ++i) {
                        float f7 = fArray[i] * f;
                        if (AudioChannel.this.softClip) {
                            f7 = AudioOutput.softClip(f7);
                        }
                        if ((int)(f7 *= 32767.0f) == 0) {
                            this.startPan = AudioChannel.this.rPan;
                            f5 = (AudioChannel.this.rPan + 1.0f) / 2.0f;
                            f6 = 1.0f - f5;
                        }
                        Ess.setFrame(AudioChannel.this.stereoBuffer, n4++, (int)(f7 * f6));
                        Ess.setFrame(AudioChannel.this.stereoBuffer, n4++, (int)(f7 * f5));
                    }
                }
                AudioChannel.this.bufferStartTime = AudioChannel.this.rBufferStartTime = Ess.parent.millis();
                AudioChannel.this.bufferSamplesStart = n;
                AudioChannel.this.line.write(AudioChannel.this.stereoBuffer, 0, n2 * 4);
            } else {
                AudioChannel.this.bufferStartTime = AudioChannel.this.rBufferStartTime = Ess.parent.millis();
                AudioChannel.this.bufferSamplesStart = n;
                AudioChannel.this.line.write(AudioChannel.this.zeroBuffer, 0, n2 * 4);
            }
        }

        private void stop() {
            this.kill = true;
            while (AudioChannel.this.rState != 1) {
            }
        }
    }
}

