/*
 * Decompiled with CFR 0.152.
 */
package krister.Ess;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import krister.Ess.AudioOutput;
import krister.Ess.Ess;
import krister.Ess.SPIWorkaround;
import processing.core.PApplet;

public final class AudioFile {
    private int mode;
    private float rSampleRate = 0.0f;
    private int mixMode;
    private int numChannels;
    private AudioInputStream acs;
    private byte[] inputBuffer;
    private File fileOut;
    private int fileType;
    private byte[] convBuffer;
    private byte[] outputBuffer;
    private int outputBufferPtr;
    private int outputBufferGrowSize = 0x100000;
    public float sampleRate;

    public AudioFile() {
    }

    public AudioFile(String string, float f, int n) {
        this.open(string, f, n, 2);
    }

    public AudioFile(String string, float f, int n, int n2) {
        this.open(string, f, n, n2);
    }

    public void destroy() {
        if (this.mode != 0) {
            this.close();
        }
    }

    public void outputBufferGrowSize(int n) {
        this.outputBufferGrowSize = n * 2;
    }

    public void open(String string, float f, int n) {
        this.open(string, f, n, 2);
    }

    public void open(String string, float f, int n, int n2) {
        if (this.mode != 0) {
            this.close();
        }
        this.sampleRate = this.rSampleRate = f;
        if (n == 1) {
            try {
                Object object;
                Object object2;
                this.mixMode = n2;
                AudioInputStream audioInputStream = null;
                if (string.startsWith("http://")) {
                    object2 = new URL(string);
                    audioInputStream = SPIWorkaround.getAudioInputStream((URL)object2);
                } else {
                    object2 = Ess.parent.getClass().getClassLoader().getResource("data/" + string);
                    if (object2 != null) {
                        audioInputStream = SPIWorkaround.getAudioInputStream((URL)object2);
                    } else {
                        object = new File(Ess.parent.dataPath(string));
                        audioInputStream = SPIWorkaround.getAudioInputStream((File)object);
                    }
                }
                object2 = audioInputStream.getFormat();
                this.numChannels = ((AudioFormat)object2).getChannels();
                if (this.numChannels > 2) {
                    this.numChannels = 1;
                }
                object = new AudioFormat(((AudioFormat)object2).getSampleRate(), 16, this.numChannels, true, true);
                this.acs = SPIWorkaround.getAudioInputStream((AudioFormat)object, audioInputStream, string);
                this.mode = n;
                this.sampleRate = this.rSampleRate = ((AudioFormat)object2).getSampleRate();
            }
            catch (Exception exception) {
                PApplet.println((String)("Unable to open sound " + string));
            }
        } else if (n == 2) {
            this.fileOut = new File(string);
            this.fileType = string.endsWith(".wav") ? 2 : 1;
            this.mode = n;
        }
    }

    public int read(AudioOutput audioOutput) {
        return this.read(audioOutput.getAudioData(), 0, audioOutput.getAudioData().length);
    }

    public int read(AudioOutput audioOutput, int n, int n2) {
        return this.read(audioOutput.getAudioData(), n, n2);
    }

    public int read(float[] fArray) {
        return this.read(fArray, 0, fArray.length);
    }

    public int read(float[] fArray, int n, int n2) {
        int n3 = 0;
        n2 = Math.min(n + n2, fArray.length) - n;
        if (this.inputBuffer == null || this.inputBuffer.length < n2 * 2 * this.numChannels) {
            this.inputBuffer = new byte[n2 * 2 * this.numChannels];
        }
        try {
            int n4;
            int n5 = n2 * 2 * this.numChannels;
            int n6 = 0;
            int n7 = 0;
            while ((n6 = this.acs.read(this.inputBuffer, n7, n5 - n7)) != -1) {
                n7 += n6;
                if ((n3 += n6) != n5) continue;
            }
            n3 /= 2;
            if (this.numChannels == 2) {
                n4 = n;
                switch (this.mixMode) {
                    case -1: {
                        int n8;
                        for (n8 = 0; n8 < n3; n8 += 2) {
                            fArray[n4++] = (float)Ess.getFrame(this.inputBuffer, n8) / 32767.0f;
                        }
                        break;
                    }
                    case 1: {
                        int n8;
                        for (n8 = 0; n8 < n3; n8 += 2) {
                            fArray[n4++] = (float)Ess.getFrame(this.inputBuffer, n8 + 1) / 32767.0f;
                        }
                        break;
                    }
                    case 2: {
                        int n8;
                        for (n8 = 0; n8 < n3; n8 += 2) {
                            fArray[n4++] = (float)(Ess.getFrame(this.inputBuffer, n8) + Ess.getFrame(this.inputBuffer, n8 + 1)) / 65534.0f;
                        }
                        break;
                    }
                }
                n3 /= 2;
            } else {
                for (n4 = 0; n4 < n3; ++n4) {
                    fArray[n4 + n] = (float)Ess.getFrame(this.inputBuffer, n4) / 32767.0f;
                }
            }
            for (n4 = n3; n4 < n2; ++n4) {
                fArray[n4 + n] = 0.0f;
            }
        }
        catch (IOException iOException) {
            PApplet.println((String)("Unable to load sound " + fArray));
        }
        return n3;
    }

    public void write(AudioOutput audioOutput) {
        this.write(audioOutput.getAudioData(), 0, audioOutput.getAudioData().length);
    }

    public void write(AudioOutput audioOutput, int n, int n2) {
        this.write(audioOutput.getAudioData(), n, n2);
    }

    public void write(float[] fArray) {
        this.write(fArray, 0, fArray.length);
    }

    public void write(float[] fArray, int n, int n2) {
        n2 = Math.min(n + n2, fArray.length) - n;
        if (this.outputBuffer == null) {
            this.outputBuffer = new byte[this.outputBufferGrowSize];
            this.outputBufferPtr = 0;
            this.convBuffer = new byte[n2 * 2];
        }
        for (int i = 0; i < n2; ++i) {
            Ess.setFrame(this.convBuffer, i, (int)(fArray[i + n] * 32767.0f));
        }
        if (this.outputBufferPtr + this.convBuffer.length >= this.outputBuffer.length) {
            byte[] byArray = this.outputBuffer;
            this.outputBuffer = new byte[Math.max(this.outputBufferPtr + this.convBuffer.length, this.outputBuffer.length + this.outputBufferGrowSize)];
            System.arraycopy(byArray, 0, this.outputBuffer, 0, byArray.length);
            byArray = null;
        }
        System.arraycopy(this.convBuffer, 0, this.outputBuffer, this.outputBufferPtr, this.convBuffer.length);
        this.outputBufferPtr += this.convBuffer.length;
    }

    public void close() {
        if (this.mode == 1) {
            this.acs = null;
            this.inputBuffer = null;
        } else if (this.mode == 2) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.outputBuffer, 0, this.outputBufferPtr);
            AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, new AudioFormat(this.sampleRate, 16, 1, true, true), this.outputBufferPtr / 2);
            try {
                if (this.fileType == 2) {
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, this.fileOut);
                } else {
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.AIFF, this.fileOut);
                }
            }
            catch (IOException iOException) {
                PApplet.println((String)("Unable to save sound " + this.fileOut));
            }
            this.fileOut = null;
            this.outputBuffer = null;
            this.convBuffer = null;
        }
        this.mode = 0;
        this.sampleRate = 0.0f;
    }
}

