
class World {
  int score;
  boolean alive;
  int[] population;
  int[] nextPopulation;

  int updatedTo=-1;

  int no;

  int totalPopulation;

  int eatingPack=10;
  int defaultPopulation=30;

  World(int nbRaces, int no) {
    this.no=no;
    score=0;
    alive=true;
    population = new int[nbRaces];
    nextPopulation = new int[nbRaces];    
    for (int i=0;i<population.length;i++) {
      population[i]=defaultPopulation;
      nextPopulation[i]=population[i];
    }
  }

  void displayPopulation() {
    int offset=0;
    for (int i=0;i<population.length;i++) {
      for (int j=0;j<population[i];j++) {
        if (phase==4 && currentAnimatedWorld==no && totalPopulation>=getGlobalPopuNumber(i,j) && totalPopulation<=getGlobalPopuNumber(i,j)+10) {
          raceManager.displayCoin(abs(totalPopulation-getGlobalPopuNumber(i,j))/3%3,(offset%10)*10,floor(offset/10)*10);
        }
        else if (j<nextPopulation[i] || getGlobalPopuNumber(i,j)>updatedTo) {
          raceManager.displayImage(i,(offset%10)*10,floor(offset/10)*10);
        } 
        else if (getGlobalPopuNumber(i,j)>updatedTo-2 && currentAnimatedWorld==no) {
          raceManager.displayPopped((offset%10)*10,floor(offset/10)*10);
        }
        offset++;
      }
    }
  }

  int getGlobalPopuNumber(int pop, int ind) {
    int result=0;
    for (int i=0;i<=pop;i++) {
      if (i<pop) result+=population[i];
      else result+=ind;
    }
    return result;
  }

  void pizzaTime() {
    nextPopulation = new int[population.length];
    for (int i=0;i<population.length;i++) {
      nextPopulation[i]=population[i];
      for (int j=0;j<population.length;j++) {
        if (population[j]>0) {
          nextPopulation[i]-=raceManager.eats[j][i]*ceil((float)population[j]/eatingPack);
          nextPopulation[i]=max(nextPopulation[i],0);
        }
      }
    }
  }

  boolean animScore() {
    if (totalPopulation<getTotalPop()) {
      totalPopulation++;
      score++;
      earnSounds[totalPopulation%earnSounds.length].play(1);
      return false;
    }
    else {
      return true;
    }
  }

  void displayScore() {
    for (int i=0;i<score;i++) {
      noStroke();
      fill(0x20,0xFF,0xFF);
      rect(i%100,floor(i/100)*10,1,10);
    }
  }

  void displayPodium() {
    noStroke();
    fill(0x20,0xFF,0xFF);
    rect(0,0,50,score/5);
  }

  boolean isThisPopuStill(int globalNo) {
    for (int i=0;i<population.length;i++) {
      if (globalNo>=population[i]) {
        globalNo-=population[i];
      }
      else {
        if (globalNo<=nextPopulation[i]) return true;
        else return false;
      }
    }
    return false;
  }

  boolean popNext() {
    if (updatedTo<getTotalPop()) {
      updatedTo++;
      while(isThisPopuStill(updatedTo)) {
        updatedTo++;
      }
      if (updatedTo<getTotalPop()) popSounds[updatedTo%popSounds.length].play(1);
    }
    else {
      return true;
    }
    return false;
  }

  int getTotalPop() {
    int result=0;
    for (int i=0;i<population.length;i++) {
      result+=population[i];
    }
    return result;
  }

  void updatePopulation() {
    for (int i=0;i<population.length;i++) {
      population[i]=nextPopulation[i];
    }
  }
}

