import processing.core.*; 
import processing.xml.*; 

import ddf.minim.*; 
import ddf.minim.signals.*; 
import ddf.minim.analysis.*; 
import ddf.minim.effects.*; 
import krister.Ess.*; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class choix06 extends PApplet {







PFont font;

RaceManager raceManager;
World[] worlds = new World[3];
int currentPlayer=0;
boolean freePlayerChoice = false;
int nbTurns = worlds.length*2;

float currentCharactersAnim=0;

int nbRacesDefault=4;
int maxExchange=10;

PImage[] coins;

Minim minim;
AudioSample[] sounds;

Proverb proverb;

int phase=0;
// 0 = en attente de jeu
// 1 = game over
// 2 = d\u00e9placement des animaux
// 3 = poppage des animaux
// 4 = scoring

int currentAnimatedWorld=-1;

int frameSkip=2;
int thisFrameSkip=frameSkip;

int targetRace;
int targetPlayer;
int toBeExchanged;


AudioChannel[] popSounds= new AudioChannel[30];
AudioChannel[] earnSounds= new AudioChannel[30];
AudioChannel[] moveSounds= new AudioChannel[30];
AudioChannel[] letspSounds= new AudioChannel[20];
AudioChannel[] randSounds= new AudioChannel[40];
int freqEchant=44100;

public void setup() {
  noSmooth();

  size(500,500);
  colorMode(HSB);

  font=loadFont("DG-mono-1-8.vlw");
  textFont(font,8);

  coins = new PImage[3];
  for (int i=0;i<coins.length;i++) {
    coins[i] = loadImage(dataPath("coin0"+i+".png"));
  }

  proverb=new Proverb();

  // minim = new Minim(this);
  //sounds = new AudioSample[3];
  //sounds[0] = minim.loadSample(dataPath("pop.wav"));
  //sounds[1] = minim.loadSample(dataPath("move.wav"));
  //sounds[2] = minim.loadSample(dataPath("earn.wav"));

  raceManager = new RaceManager();
  for (int i=0;i<worlds.length;i++) worlds[i] = new World(raceManager.nbRaces,i);

  Ess.start(this);
  for (int i=0;i<popSounds.length;i++) {
    popSounds[i]=new AudioChannel();
    popSounds[i].sampleRate(freqEchant);
    int sLength=500;
    popSounds[i].initChannel(sLength);
    popSounds[i].samples=generatePop(i,sLength);
  }
  for (int i=0;i<earnSounds.length;i++) {
    earnSounds[i]=new AudioChannel();
    earnSounds[i].sampleRate(freqEchant);
    int sLength=1000;
    earnSounds[i].initChannel(sLength);
    earnSounds[i].samples=generateEarn(i,sLength);
  }
  for (int i=0;i<moveSounds.length;i++) {
    moveSounds[i]=new AudioChannel();
    moveSounds[i].sampleRate(freqEchant);
    int sLength=200;
    moveSounds[i].initChannel(sLength);
    moveSounds[i].samples=generateMove(i,sLength);
  }
  for (int i=0;i<letspSounds.length;i++) {
    letspSounds[i]=new AudioChannel();
    letspSounds[i].sampleRate(freqEchant);
    int sLength=50000;
    letspSounds[i].initChannel(sLength);
    letspSounds[i].samples=generateLetsp(i,sLength);
  }
  for (int i=0;i<randSounds.length;i++) {
    randSounds[i]=new AudioChannel();
    randSounds[i].sampleRate(freqEchant);
    int sLength=20000;
    randSounds[i].initChannel(sLength);
    randSounds[i].samples=generateRand(i,sLength);
  }

  letspSounds[floor(random(letspSounds.length))].play(1);
}

public float[] generatePop(int i, int sL) {
  float[] son = new float[sL];
  float freqBase = 3500-i*100;
  for (int s=0;s<son.length;s++) {
    float freq = freqBase + pow((float)(son.length-s)/son.length,5)*1000;
    son[s]=sin((float)s*TWO_PI/(freqEchant/freq))*((float)(son.length-s)/son.length)*min(1,(float)s*2/sL);
  }
  return son;
}

public float[] generateEarn(int i, int sL) {
  float[] son = new float[sL];
  float freqBase = 4000+sin((float)i/10)*120;
  for (int s=0;s<son.length;s++) {
    float freq = freqBase;
    son[s]=sin((float)s*TWO_PI/(freqEchant/freq))*pow((float)(son.length-s)/son.length,5)*min(1,(float)s*4/sL);
  }
  return son;
}

public float[] generateMove(int i, int sL) {
  float[] son = new float[sL];
  float freqBase = 2000+sin((float)i*TWO_PI/30)*1500;
  for (int s=0;s<son.length;s++) {
    float freq = freqBase + sin((float)(son.length-s)*TWO_PI/son.length)*500;
    son[s]=sin((float)s*TWO_PI/(freqEchant/freq))*((float)(son.length-s)/son.length)*min(1,(float)s*2/sL);
  }
  return son;
}

public float[] generateLetsp(int i, int sL) {
  float[] son = new float[sL];
  float[] freqBase = new float[3];
  for (int f=0;f<freqBase.length;f++) {
    freqBase[f]=random(700)+20;
    if (f==freqBase.length-1)freqBase[f]=freqBase[0]+random(-10,10);
  }
  for (int s=0;s<son.length;s++) {
    son[s]=0;
    for (int f=0;f<freqBase.length;f++) {
      son[s]+=sin((float)s*TWO_PI/(freqEchant/freqBase[f]));
    }
    son[s]*=((float)(son.length-s)/son.length)*min(1,(float)s*5/sL)/freqBase.length;
  }
  return son;
}

public float[] generateRand(int i, int sL) {
  float[] son = new float[sL];
  float[] freqBase = new float[floor(random(5))+1];
  for (int f=0;f<freqBase.length;f++) {
    freqBase[f]=random(700)+500;
    if (f==freqBase.length-1)freqBase[f]=freqBase[0]+random(-10,10);
  }
  for (int s=0;s<son.length;s++) {
    son[s]=0;
    for (int f=0;f<freqBase.length;f++) {
      son[s]+=sin((float)s*TWO_PI/(freqEchant/freqBase[f]));
    }
    son[s]*=((float)(son.length-s)/son.length)*min(1,(float)s*5/sL)/(freqBase.length+2);
  }
  return son;
}

public void draw() {
  if (random(1000)<1) randSounds[floor(random(randSounds.length))].play(1);
  background(0);
  if (phase==0) {
    displayStats();
  }
  if (phase==1) {
    displayPodium();
  }
  if (phase==2) {
    if (thisFrameSkip>0) {
      thisFrameSkip--;
    }
    else {
      if (toBeExchanged==0) {
        currentAnimatedWorld=-1;
        phase=3;
        pizzaTime();
      } 
      else {
        toBeExchanged--;
        worlds[(currentPlayer-1+worlds.length)%worlds.length].population[targetRace]++;
        worlds[targetPlayer].population[targetRace]--;
        moveSounds[toBeExchanged%moveSounds.length].play(1);
      }
    }      
    displayStats();
  }
  if (phase==3) {
    if (thisFrameSkip>0) {
      thisFrameSkip--;
    } 
    else {
      thisFrameSkip=frameSkip;
      if (currentAnimatedWorld==-1) currentAnimatedWorld=0;
      if (worlds[currentAnimatedWorld].popNext()) currentAnimatedWorld++;
      if (currentAnimatedWorld>=worlds.length) {
        currentAnimatedWorld=-1;
        phase=4;
        for (int w=0;w<worlds.length;w++) {
          worlds[w].updatedTo=-1;
          worlds[w].totalPopulation=0;
          worlds[w].updatePopulation();
        }
      }
    }
    displayStats();
    fill(0xA0);
    noStroke();
    text("Creatures eat each other now.",140,90);
  }
  if (phase==4) {
    if (thisFrameSkip>0) {
      thisFrameSkip--;
    } 
    else {
      if (currentAnimatedWorld==-1) currentAnimatedWorld=0;
      if (worlds[currentAnimatedWorld].animScore()) currentAnimatedWorld++;
      if (currentAnimatedWorld>=worlds.length) {
        currentAnimatedWorld=-1;
        phase=0;
        letspSounds[floor(random(letspSounds.length))].play(1);        
        if (nbTurns==0) {
          phase=1;
          letspSounds[floor(random(letspSounds.length))].play(1);
        }
      }
    }
    displayStats();
    fill(0xA0);
    noStroke();
    text("Each player earns money for his remaining creatures.",50,90);
  }
  currentCharactersAnim=currentCharactersAnim+0.05f;
}

public void displayPodium() {
  for (int i=0;i<worlds.length;i++) {
    pushMatrix();
    translate(10+i*150,10);
    worlds[i].displayPodium();
    popMatrix();
  }
  noStroke();
  fill(0xF0);
  text(winner(),10,300);
  fill(0x20,0xFF,0xFF);  
  for (int i=0;i<worlds.length;i++) {
    text("Player "+(i+1)+" score : "+worlds[i].score,10,315+15*i);
  }
  fill(0xF0);
  text(proverb.theText,10,315+15*worlds.length,490,50);
}

public void displayTurn() {
  noStroke();
  fill(0,0,0x80);
  text ("remaining turns : "+nbTurns,300,16);
  rect(300,25,nbTurns*10,10);
}

public void displayStats() {
  displayTurn(); 
  displayGeneralStats();  
  for (int i=0;i<worlds.length;i++) {
    pushMatrix();
    translate(50+i*150,170);
    stroke(0x40);
    noFill();
    if (phase==0 && currentPlayer==i) stroke(0xFF);
    rect(currentPlayer-20,-30,140,340);
    worlds[i].displayScore();
    noStroke();
    fill(0xA0);
    text("Player "+(i+1),20,-10);
    translate(0,85);    
    worlds[i].displayPopulation();
    popMatrix();
  }
}

public void pizzaTime() {
  for (int w=0;w<worlds.length;w++) {
    worlds[w].pizzaTime();
  }
}

public void keyPressed() {
  if (phase==0) {
    if (keyCode==ENTER) {
      targetRace = -1;
      targetPlayer = -1;
      nextPlayer();
      toBeExchanged=0;
    }
    if (keyCode>96 && keyCode<97+nbRacesDefault) {
      targetRace = keyCode-97;
      targetPlayer = (currentPlayer+1)%worlds.length;      
      while (!worlds[targetPlayer].alive) targetPlayer = (targetPlayer+1)%worlds.length;    
      nextPlayer();
      toBeExchanged=min(worlds[targetPlayer].population[targetRace],maxExchange);
    }
  } 
  else if (phase==1) {
    phase=0;
    letspSounds[floor(random(letspSounds.length))].play(1);
    nbRacesDefault=(nbRacesDefault-3)%2+4;
    raceManager = new RaceManager();
    for (int i=0;i<worlds.length;i++) worlds[i] = new World(raceManager.nbRaces,i);
    nbTurns = worlds.length * 2;
    proverb = new Proverb();
  }
}

public void nextPlayer() {
  currentPlayer = (currentPlayer+1)%worlds.length;
  while (!worlds[currentPlayer].alive) currentPlayer = (currentPlayer+1)%worlds.length;
  phase=2;
  nbTurns--;
}

public void mousePressed() {
  if (freePlayerChoice) {
    targetPlayer=floor(mouseX/150)%worlds.length;
    targetRace=floor((mouseY-10)/20)%raceManager.nbRaces;
    toBeExchanged=worlds[targetPlayer].population[targetRace];
    nextPlayer();
  }
}

public void stop() {
  //for (int i=0;i<sounds.length;i++) {
  //  sounds[i].close();
  //}
  //minim.stop();
  Ess.stop();
  super.stop();
}

public void displayGeneralStats() {
  pushMatrix();
  translate(100,10);
  text ("each turn : ",-90,6);
  for (int i=0;i<nbRacesDefault;i++) {
    noStroke();
    fill(0xA0);
    raceManager.displayImageStill(i,10,i*15);
    text ("kills",25,i*15+6);
    int offsetX=72;
    for (int j=0;j<nbRacesDefault;j++) {
      for (int k=0;k<raceManager.eats[i][j];k++) {
        raceManager.displayImageStill(j,offsetX,i*15);
        offsetX+=10;
      }
    }
  }
  popMatrix();
  if (phase==0) {
    noStroke();
    fill(0xA0);
    text("Player "+(currentPlayer+1)+" chooses a kind of ",140,90);
    text("creature to steal from player "+((currentPlayer+1)%worlds.length+1)+".",120,100);
    text(maxExchange + " creatures max will be stolen. Use numeric pad.",60,110);
    fill(0xFF);
    for (int i=0;i<=nbRacesDefault;i++) {
      if (i<nbRacesDefault) {
        text((i+1)+" = ",70*(i+1)-(nbRacesDefault-4)*43,125);
        raceManager.displayImageStill(i,30+70*(i+1)-(nbRacesDefault-4)*43,118);
      }
      else {
        text("enter = pass",70*(i+1)-(nbRacesDefault-4)*43,125);
      }
    }
  }
}

public String winner() {
  String result="Player ";
  int m=0;
  int w=-1;
  for (int i=0;i<worlds.length;i++) {
    if (worlds[i].score>m) {
      m=worlds[i].score;
      w=i;
    }
  }
  result+=(w+1)+" wins";
  for (int i=0;i<worlds.length;i++) {
    if (worlds[i].score==m && i!=w) {
      result+=" but player "+(i+1)+" also wins";
    }
  }
  result+=".";
  return result;
}

class Proverb {
  String[] tpA = {
    "Don't forget that ",
    "Next time remember that ",
    "The important thing you have to know is that ",
    "Now let's add one rule : ",
    "You didn't use this option : ",
    "Here's a simple trick :"
  };
  String[] colors = {
    "red",
    "green",
    "spiky",
    "strange"
  };
  String[] animals = {
    "fish",
    "frog",
    "shape",
    "creature"
  };
  String[] actions = {
    "reaches the bottom of the screen",
    "is completely extinct",
    "eats everything on the screen",
    "is owned by only one player"
  };
  String[] tpB = {
    tpA[floor(random(tpA.length))]+"you win a bonus when a "+colors[floor(random(colors.length))]+" "+animals[floor(random(animals.length))]+" "+actions[floor(random(actions.length))]+".",
    tpA[floor(random(tpA.length))]+"the secret level can only be accessed when a "+colors[floor(random(colors.length))]+" "+animals[floor(random(animals.length))]+" "+actions[floor(random(actions.length))]+".",
    tpA[floor(random(tpA.length))]+"you have more chances to loose when a "+colors[floor(random(colors.length))]+" "+animals[floor(random(animals.length))]+" "+actions[floor(random(actions.length))]+".",
    tpA[floor(random(tpA.length))]+"the gameplay completely changes when a "+colors[floor(random(colors.length))]+" "+animals[floor(random(animals.length))]+" "+actions[floor(random(actions.length))]+".",
    tpA[floor(random(tpA.length))]+"money has no value unless a "+colors[floor(random(colors.length))]+" "+animals[floor(random(animals.length))]+" "+actions[floor(random(actions.length))]+".",
    "Here's how the eating part works : let's say green eats 1 red & 2 blues ; if there is at least 1 green in a player's set, each turn 1 red & 2 blue will disappear + additional 1 red & 2 blues for each 10 greens there."
  };
  String theText;
  Proverb() {
    theText=tpB[floor(random(tpB.length))];
  }
}


class RaceManager {
  int nbRaces;
  int[][] eats;
  int[] c;
  PImage[][] raceImages;
  PImage popped;

  RaceManager() {
    this.nbRaces=nbRacesDefault;
    c = new int[nbRaces];
    raceImages = new PImage[nbRaces][floor(random(random(10))+2)];
    popped = loadImage(dataPath("pop00.png"));
    eats = new int[nbRaces][nbRaces];
    for (int i=0;i<nbRaces;i++) {
      int[] preys = new int[2];
      for (int p=0;p<preys.length;p++) {
        preys[p]=floor(random(nbRaces));
        while (preys[p]==i) preys[p]=floor(random(nbRaces));
      }
      for (int j=0;j<nbRaces;j++) {
        eats[i][j] = 0;
      }
      for (int j=0;j<nbRaces;j++) {
        for (int p=0;p<preys.length;p++) {
          if (preys[p]==j) eats[i][j]+=(p+1);
        }
      }
      c[i]=color(0xFF*i/nbRaces,0xFF,0xFF);
      float[] longB = new float[ceil(TWO_PI/0.1f)+10];
      longB[0]=2;
      for (int a=1;a<longB.length;a++) {
        longB[a]=constrain(longB[a-1]+random(-1.5f,1.5f),1,4);
      }
      for (int j=0;j<raceImages[i].length;j++) {
        //raceImages[i][j]=loadImage(dataPath("race0"+i+"_"+j+".png"));
        raceImages[i][j]=generateRaceImage(i,nbRaces,longB);
      }
    }
  }

  public PImage generateRaceImage(int i, int total, float[] longB) {
    PImage result = createImage(8,8,HSB);
    int thisHue=floor((float)i*0xFF/total);
    for (int x=0;x<result.width;x++) {
      for (int y=0;y<result.height;y++) { 
        result.set(x,y,color(thisHue,0xD0,0xF8));
      }
    }
    int i2=0;
    for (float a=0;a<TWO_PI;a+=0.1f) {
      i2++;
      longB[i2]+=random(-1,1);
      for (int l=8;l>longB[i2];l--) {
        result.set(4+round(cos(a)*l),4+round(sin(a)*l),color(0x00,0x00));
        if (1>abs(l - longB[i2])) result.set(4+round(cos(a)*l),4+round(sin(a)*l),color(thisHue,0x80,0xA0));
      }
    }
    return result;
  }

  public void displayRect(int i, int x, int y) {
    noStroke();
    fill(c[i]);
    rect(x,y,10,10);
  }

  public void displayImage(int i, int x, int y) {
    image(raceImages[i][floor(currentCharactersAnim%raceImages[i].length)],x,y);
  }

  public void displayImageStill(int i, int x, int y) {
    image(raceImages[i][0],x,y);
  }

  public void displayPopped(int x, int y) {
    noFill();
    stroke(0x00,random(0x50)+0xA0,random(0x50)+0xA0);
    int nbLines = floor(random(16)+1);
    for (int i=0;i<nbLines;i++) {
      float lineLength = random(3)+1;
      float angle = (float)i*TWO_PI/nbLines;
      line(x+4+cos(angle)*4,y+4+sin(angle)*4,x+4+cos(angle)*lineLength,y+4+sin(angle)*lineLength);
    }
    //image(popped,x,y);
  }

  public void displayCoin(int i, int x, int y) {
    fill(0x20,random(0x40)+0xB0,random(0x40)+0xB0);
    stroke(0x20,random(0x50)+0xA0,random(0x50)+0xA0);
    ellipse(x+4,y+4,random(8),8);
    //image(coins[i],x,y);
  }
}


class World {
  int score;
  boolean alive;
  int[] population;
  int[] nextPopulation;

  int updatedTo=-1;

  int no;

  int totalPopulation;

  int eatingPack=10;
  int defaultPopulation=30;

  World(int nbRaces, int no) {
    this.no=no;
    score=0;
    alive=true;
    population = new int[nbRaces];
    nextPopulation = new int[nbRaces];    
    for (int i=0;i<population.length;i++) {
      population[i]=defaultPopulation;
      nextPopulation[i]=population[i];
    }
  }

  public void displayPopulation() {
    int offset=0;
    for (int i=0;i<population.length;i++) {
      for (int j=0;j<population[i];j++) {
        if (phase==4 && currentAnimatedWorld==no && totalPopulation>=getGlobalPopuNumber(i,j) && totalPopulation<=getGlobalPopuNumber(i,j)+10) {
          raceManager.displayCoin(abs(totalPopulation-getGlobalPopuNumber(i,j))/3%3,(offset%10)*10,floor(offset/10)*10);
        }
        else if (j<nextPopulation[i] || getGlobalPopuNumber(i,j)>updatedTo) {
          raceManager.displayImage(i,(offset%10)*10,floor(offset/10)*10);
        } 
        else if (getGlobalPopuNumber(i,j)>updatedTo-2 && currentAnimatedWorld==no) {
          raceManager.displayPopped((offset%10)*10,floor(offset/10)*10);
        }
        offset++;
      }
    }
  }

  public int getGlobalPopuNumber(int pop, int ind) {
    int result=0;
    for (int i=0;i<=pop;i++) {
      if (i<pop) result+=population[i];
      else result+=ind;
    }
    return result;
  }

  public void pizzaTime() {
    nextPopulation = new int[population.length];
    for (int i=0;i<population.length;i++) {
      nextPopulation[i]=population[i];
      for (int j=0;j<population.length;j++) {
        if (population[j]>0) {
          nextPopulation[i]-=raceManager.eats[j][i]*ceil((float)population[j]/eatingPack);
          nextPopulation[i]=max(nextPopulation[i],0);
        }
      }
    }
  }

  public boolean animScore() {
    if (totalPopulation<getTotalPop()) {
      totalPopulation++;
      score++;
      earnSounds[totalPopulation%earnSounds.length].play(1);
      return false;
    }
    else {
      return true;
    }
  }

  public void displayScore() {
    for (int i=0;i<score;i++) {
      noStroke();
      fill(0x20,0xFF,0xFF);
      rect(i%100,floor(i/100)*10,1,10);
    }
  }

  public void displayPodium() {
    noStroke();
    fill(0x20,0xFF,0xFF);
    rect(0,0,50,score/5);
  }

  public boolean isThisPopuStill(int globalNo) {
    for (int i=0;i<population.length;i++) {
      if (globalNo>=population[i]) {
        globalNo-=population[i];
      }
      else {
        if (globalNo<=nextPopulation[i]) return true;
        else return false;
      }
    }
    return false;
  }

  public boolean popNext() {
    if (updatedTo<getTotalPop()) {
      updatedTo++;
      while(isThisPopuStill(updatedTo)) {
        updatedTo++;
      }
      if (updatedTo<getTotalPop()) popSounds[updatedTo%popSounds.length].play(1);
    }
    else {
      return true;
    }
    return false;
  }

  public int getTotalPop() {
    int result=0;
    for (int i=0;i<population.length;i++) {
      result+=population[i];
    }
    return result;
  }

  public void updatePopulation() {
    for (int i=0;i<population.length;i++) {
      population[i]=nextPopulation[i];
    }
  }
}

  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#D4D0C8", "choix06" });
  }
}
