
class RaceManager {
  int nbRaces;
  int[][] eats;
  color[] c;
  PImage[][] raceImages;
  PImage popped;

  RaceManager() {
    this.nbRaces=nbRacesDefault;
    c = new color[nbRaces];
    raceImages = new PImage[nbRaces][floor(random(random(10))+2)];
    popped = loadImage(dataPath("pop00.png"));
    eats = new int[nbRaces][nbRaces];
    for (int i=0;i<nbRaces;i++) {
      int[] preys = new int[2];
      for (int p=0;p<preys.length;p++) {
        preys[p]=floor(random(nbRaces));
        while (preys[p]==i) preys[p]=floor(random(nbRaces));
      }
      for (int j=0;j<nbRaces;j++) {
        eats[i][j] = 0;
      }
      for (int j=0;j<nbRaces;j++) {
        for (int p=0;p<preys.length;p++) {
          if (preys[p]==j) eats[i][j]+=(p+1);
        }
      }
      c[i]=color(0xFF*i/nbRaces,0xFF,0xFF);
      float[] longB = new float[ceil(TWO_PI/0.1)+10];
      longB[0]=2;
      for (int a=1;a<longB.length;a++) {
        longB[a]=constrain(longB[a-1]+random(-1.5,1.5),1,4);
      }
      for (int j=0;j<raceImages[i].length;j++) {
        //raceImages[i][j]=loadImage(dataPath("race0"+i+"_"+j+".png"));
        raceImages[i][j]=generateRaceImage(i,nbRaces,longB);
      }
    }
  }

  PImage generateRaceImage(int i, int total, float[] longB) {
    PImage result = createImage(8,8,HSB);
    int thisHue=floor((float)i*0xFF/total);
    for (int x=0;x<result.width;x++) {
      for (int y=0;y<result.height;y++) { 
        result.set(x,y,color(thisHue,0xD0,0xF8));
      }
    }
    int i2=0;
    for (float a=0;a<TWO_PI;a+=0.1) {
      i2++;
      longB[i2]+=random(-1,1);
      for (int l=8;l>longB[i2];l--) {
        result.set(4+round(cos(a)*l),4+round(sin(a)*l),color(0x00,0x00));
        if (1>abs(l - longB[i2])) result.set(4+round(cos(a)*l),4+round(sin(a)*l),color(thisHue,0x80,0xA0));
      }
    }
    return result;
  }

  void displayRect(int i, int x, int y) {
    noStroke();
    fill(c[i]);
    rect(x,y,10,10);
  }

  void displayImage(int i, int x, int y) {
    image(raceImages[i][floor(currentCharactersAnim%raceImages[i].length)],x,y);
  }

  void displayImageStill(int i, int x, int y) {
    image(raceImages[i][0],x,y);
  }

  void displayPopped(int x, int y) {
    noFill();
    stroke(0x00,random(0x50)+0xA0,random(0x50)+0xA0);
    int nbLines = floor(random(16)+1);
    for (int i=0;i<nbLines;i++) {
      float lineLength = random(3)+1;
      float angle = (float)i*TWO_PI/nbLines;
      line(x+4+cos(angle)*4,y+4+sin(angle)*4,x+4+cos(angle)*lineLength,y+4+sin(angle)*lineLength);
    }
    //image(popped,x,y);
  }

  void displayCoin(int i, int x, int y) {
    fill(0x20,random(0x40)+0xB0,random(0x40)+0xB0);
    stroke(0x20,random(0x50)+0xA0,random(0x50)+0xA0);
    ellipse(x+4,y+4,random(8),8);
    //image(coins[i],x,y);
  }
}

