
import ddf.minim.*;
import ddf.minim.signals.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;

PFont font;

RaceManager raceManager;
World[] worlds = new World[3];
int currentPlayer=0;
boolean freePlayerChoice = false;
int nbTurns = worlds.length*2;

float currentCharactersAnim=0;

int nbRacesDefault=4;
int maxExchange=10;

PImage[] coins;

Minim minim;
AudioSample[] sounds;

Proverb proverb;

int phase=0;
// 0 = en attente de jeu
// 1 = game over
// 2 = déplacement des animaux
// 3 = poppage des animaux
// 4 = scoring

int currentAnimatedWorld=-1;

int frameSkip=2;
int thisFrameSkip=frameSkip;

int targetRace;
int targetPlayer;
int toBeExchanged;

import krister.Ess.*;
AudioChannel[] popSounds= new AudioChannel[30];
AudioChannel[] earnSounds= new AudioChannel[30];
AudioChannel[] moveSounds= new AudioChannel[30];
AudioChannel[] letspSounds= new AudioChannel[20];
AudioChannel[] randSounds= new AudioChannel[40];
int freqEchant=44100;

void setup() {
  noSmooth();

  size(500,500);
  colorMode(HSB);

  font=loadFont("DG-mono-1-8.vlw");
  textFont(font,8);

  coins = new PImage[3];
  for (int i=0;i<coins.length;i++) {
    coins[i] = loadImage(dataPath("coin0"+i+".png"));
  }

  proverb=new Proverb();

  // minim = new Minim(this);
  //sounds = new AudioSample[3];
  //sounds[0] = minim.loadSample(dataPath("pop.wav"));
  //sounds[1] = minim.loadSample(dataPath("move.wav"));
  //sounds[2] = minim.loadSample(dataPath("earn.wav"));

  raceManager = new RaceManager();
  for (int i=0;i<worlds.length;i++) worlds[i] = new World(raceManager.nbRaces,i);

  Ess.start(this);
  for (int i=0;i<popSounds.length;i++) {
    popSounds[i]=new AudioChannel();
    popSounds[i].sampleRate(freqEchant);
    int sLength=500;
    popSounds[i].initChannel(sLength);
    popSounds[i].samples=generatePop(i,sLength);
  }
  for (int i=0;i<earnSounds.length;i++) {
    earnSounds[i]=new AudioChannel();
    earnSounds[i].sampleRate(freqEchant);
    int sLength=1000;
    earnSounds[i].initChannel(sLength);
    earnSounds[i].samples=generateEarn(i,sLength);
  }
  for (int i=0;i<moveSounds.length;i++) {
    moveSounds[i]=new AudioChannel();
    moveSounds[i].sampleRate(freqEchant);
    int sLength=200;
    moveSounds[i].initChannel(sLength);
    moveSounds[i].samples=generateMove(i,sLength);
  }
  for (int i=0;i<letspSounds.length;i++) {
    letspSounds[i]=new AudioChannel();
    letspSounds[i].sampleRate(freqEchant);
    int sLength=50000;
    letspSounds[i].initChannel(sLength);
    letspSounds[i].samples=generateLetsp(i,sLength);
  }
  for (int i=0;i<randSounds.length;i++) {
    randSounds[i]=new AudioChannel();
    randSounds[i].sampleRate(freqEchant);
    int sLength=20000;
    randSounds[i].initChannel(sLength);
    randSounds[i].samples=generateRand(i,sLength);
  }

  letspSounds[floor(random(letspSounds.length))].play(1);
}

float[] generatePop(int i, int sL) {
  float[] son = new float[sL];
  float freqBase = 3500-i*100;
  for (int s=0;s<son.length;s++) {
    float freq = freqBase + pow((float)(son.length-s)/son.length,5)*1000;
    son[s]=sin((float)s*TWO_PI/(freqEchant/freq))*((float)(son.length-s)/son.length)*min(1,(float)s*2/sL);
  }
  return son;
}

float[] generateEarn(int i, int sL) {
  float[] son = new float[sL];
  float freqBase = 4000+sin((float)i/10)*120;
  for (int s=0;s<son.length;s++) {
    float freq = freqBase;
    son[s]=sin((float)s*TWO_PI/(freqEchant/freq))*pow((float)(son.length-s)/son.length,5)*min(1,(float)s*4/sL);
  }
  return son;
}

float[] generateMove(int i, int sL) {
  float[] son = new float[sL];
  float freqBase = 2000+sin((float)i*TWO_PI/30)*1500;
  for (int s=0;s<son.length;s++) {
    float freq = freqBase + sin((float)(son.length-s)*TWO_PI/son.length)*500;
    son[s]=sin((float)s*TWO_PI/(freqEchant/freq))*((float)(son.length-s)/son.length)*min(1,(float)s*2/sL);
  }
  return son;
}

float[] generateLetsp(int i, int sL) {
  float[] son = new float[sL];
  float[] freqBase = new float[3];
  for (int f=0;f<freqBase.length;f++) {
    freqBase[f]=random(700)+20;
    if (f==freqBase.length-1)freqBase[f]=freqBase[0]+random(-10,10);
  }
  for (int s=0;s<son.length;s++) {
    son[s]=0;
    for (int f=0;f<freqBase.length;f++) {
      son[s]+=sin((float)s*TWO_PI/(freqEchant/freqBase[f]));
    }
    son[s]*=((float)(son.length-s)/son.length)*min(1,(float)s*5/sL)/freqBase.length;
  }
  return son;
}

float[] generateRand(int i, int sL) {
  float[] son = new float[sL];
  float[] freqBase = new float[floor(random(5))+1];
  for (int f=0;f<freqBase.length;f++) {
    freqBase[f]=random(700)+500;
    if (f==freqBase.length-1)freqBase[f]=freqBase[0]+random(-10,10);
  }
  for (int s=0;s<son.length;s++) {
    son[s]=0;
    for (int f=0;f<freqBase.length;f++) {
      son[s]+=sin((float)s*TWO_PI/(freqEchant/freqBase[f]));
    }
    son[s]*=((float)(son.length-s)/son.length)*min(1,(float)s*5/sL)/(freqBase.length+2);
  }
  return son;
}

void draw() {
  if (random(1000)<1) randSounds[floor(random(randSounds.length))].play(1);
  background(0);
  if (phase==0) {
    displayStats();
  }
  if (phase==1) {
    displayPodium();
  }
  if (phase==2) {
    if (thisFrameSkip>0) {
      thisFrameSkip--;
    }
    else {
      if (toBeExchanged==0) {
        currentAnimatedWorld=-1;
        phase=3;
        pizzaTime();
      } 
      else {
        toBeExchanged--;
        worlds[(currentPlayer-1+worlds.length)%worlds.length].population[targetRace]++;
        worlds[targetPlayer].population[targetRace]--;
        moveSounds[toBeExchanged%moveSounds.length].play(1);
      }
    }      
    displayStats();
  }
  if (phase==3) {
    if (thisFrameSkip>0) {
      thisFrameSkip--;
    } 
    else {
      thisFrameSkip=frameSkip;
      if (currentAnimatedWorld==-1) currentAnimatedWorld=0;
      if (worlds[currentAnimatedWorld].popNext()) currentAnimatedWorld++;
      if (currentAnimatedWorld>=worlds.length) {
        currentAnimatedWorld=-1;
        phase=4;
        for (int w=0;w<worlds.length;w++) {
          worlds[w].updatedTo=-1;
          worlds[w].totalPopulation=0;
          worlds[w].updatePopulation();
        }
      }
    }
    displayStats();
    fill(0xA0);
    noStroke();
    text("Creatures eat each other now.",140,90);
  }
  if (phase==4) {
    if (thisFrameSkip>0) {
      thisFrameSkip--;
    } 
    else {
      if (currentAnimatedWorld==-1) currentAnimatedWorld=0;
      if (worlds[currentAnimatedWorld].animScore()) currentAnimatedWorld++;
      if (currentAnimatedWorld>=worlds.length) {
        currentAnimatedWorld=-1;
        phase=0;
        letspSounds[floor(random(letspSounds.length))].play(1);        
        if (nbTurns==0) {
          phase=1;
          letspSounds[floor(random(letspSounds.length))].play(1);
        }
      }
    }
    displayStats();
    fill(0xA0);
    noStroke();
    text("Each player earns money for his remaining creatures.",50,90);
  }
  currentCharactersAnim=currentCharactersAnim+0.05;
}

void displayPodium() {
  for (int i=0;i<worlds.length;i++) {
    pushMatrix();
    translate(10+i*150,10);
    worlds[i].displayPodium();
    popMatrix();
  }
  noStroke();
  fill(0xF0);
  text(winner(),10,300);
  fill(0x20,0xFF,0xFF);  
  for (int i=0;i<worlds.length;i++) {
    text("Player "+(i+1)+" score : "+worlds[i].score,10,315+15*i);
  }
  fill(0xF0);
  text(proverb.theText,10,315+15*worlds.length,490,50);
}

void displayTurn() {
  noStroke();
  fill(0,0,0x80);
  text ("remaining turns : "+nbTurns,300,16);
  rect(300,25,nbTurns*10,10);
}

void displayStats() {
  displayTurn(); 
  displayGeneralStats();  
  for (int i=0;i<worlds.length;i++) {
    pushMatrix();
    translate(50+i*150,170);
    stroke(0x40);
    noFill();
    if (phase==0 && currentPlayer==i) stroke(0xFF);
    rect(currentPlayer-20,-30,140,340);
    worlds[i].displayScore();
    noStroke();
    fill(0xA0);
    text("Player "+(i+1),20,-10);
    translate(0,85);    
    worlds[i].displayPopulation();
    popMatrix();
  }
}

void pizzaTime() {
  for (int w=0;w<worlds.length;w++) {
    worlds[w].pizzaTime();
  }
}

void keyPressed() {
  if (phase==0) {
    if (keyCode==ENTER) {
      targetRace = -1;
      targetPlayer = -1;
      nextPlayer();
      toBeExchanged=0;
    }
    if (keyCode>96 && keyCode<97+nbRacesDefault) {
      targetRace = keyCode-97;
      targetPlayer = (currentPlayer+1)%worlds.length;      
      while (!worlds[targetPlayer].alive) targetPlayer = (targetPlayer+1)%worlds.length;    
      nextPlayer();
      toBeExchanged=min(worlds[targetPlayer].population[targetRace],maxExchange);
    }
  } 
  else if (phase==1) {
    phase=0;
    letspSounds[floor(random(letspSounds.length))].play(1);
    nbRacesDefault=(nbRacesDefault-3)%2+4;
    raceManager = new RaceManager();
    for (int i=0;i<worlds.length;i++) worlds[i] = new World(raceManager.nbRaces,i);
    nbTurns = worlds.length * 2;
    proverb = new Proverb();
  }
}

void nextPlayer() {
  currentPlayer = (currentPlayer+1)%worlds.length;
  while (!worlds[currentPlayer].alive) currentPlayer = (currentPlayer+1)%worlds.length;
  phase=2;
  nbTurns--;
}

void mousePressed() {
  if (freePlayerChoice) {
    targetPlayer=floor(mouseX/150)%worlds.length;
    targetRace=floor((mouseY-10)/20)%raceManager.nbRaces;
    toBeExchanged=worlds[targetPlayer].population[targetRace];
    nextPlayer();
  }
}

void stop() {
  //for (int i=0;i<sounds.length;i++) {
  //  sounds[i].close();
  //}
  //minim.stop();
  Ess.stop();
  super.stop();
}

void displayGeneralStats() {
  pushMatrix();
  translate(100,10);
  text ("each turn : ",-90,6);
  for (int i=0;i<nbRacesDefault;i++) {
    noStroke();
    fill(0xA0);
    raceManager.displayImageStill(i,10,i*15);
    text ("kills",25,i*15+6);
    int offsetX=72;
    for (int j=0;j<nbRacesDefault;j++) {
      for (int k=0;k<raceManager.eats[i][j];k++) {
        raceManager.displayImageStill(j,offsetX,i*15);
        offsetX+=10;
      }
    }
  }
  popMatrix();
  if (phase==0) {
    noStroke();
    fill(0xA0);
    text("Player "+(currentPlayer+1)+" chooses a kind of ",140,90);
    text("creature to steal from player "+((currentPlayer+1)%worlds.length+1)+".",120,100);
    text(maxExchange + " creatures max will be stolen. Use numeric pad.",60,110);
    fill(0xFF);
    for (int i=0;i<=nbRacesDefault;i++) {
      if (i<nbRacesDefault) {
        text((i+1)+" = ",70*(i+1)-(nbRacesDefault-4)*43,125);
        raceManager.displayImageStill(i,30+70*(i+1)-(nbRacesDefault-4)*43,118);
      }
      else {
        text("enter = pass",70*(i+1)-(nbRacesDefault-4)*43,125);
      }
    }
  }
}

String winner() {
  String result="Player ";
  int m=0;
  int w=-1;
  for (int i=0;i<worlds.length;i++) {
    if (worlds[i].score>m) {
      m=worlds[i].score;
      w=i;
    }
  }
  result+=(w+1)+" wins";
  for (int i=0;i<worlds.length;i++) {
    if (worlds[i].score==m && i!=w) {
      result+=" but player "+(i+1)+" also wins";
    }
  }
  result+=".";
  return result;
}

class Proverb {
  String[] tpA = {
    "Don't forget that ",
    "Next time remember that ",
    "The important thing you have to know is that ",
    "Now let's add one rule : ",
    "You didn't use this option : ",
    "Here's a simple trick :"
  };
  String[] colors = {
    "red",
    "green",
    "spiky",
    "strange"
  };
  String[] animals = {
    "fish",
    "frog",
    "shape",
    "creature"
  };
  String[] actions = {
    "reaches the bottom of the screen",
    "is completely extinct",
    "eats everything on the screen",
    "is owned by only one player"
  };
  String[] tpB = {
    tpA[floor(random(tpA.length))]+"you win a bonus when a "+colors[floor(random(colors.length))]+" "+animals[floor(random(animals.length))]+" "+actions[floor(random(actions.length))]+".",
    tpA[floor(random(tpA.length))]+"the secret level can onle be accessed when a "+colors[floor(random(colors.length))]+" "+animals[floor(random(animals.length))]+" "+actions[floor(random(actions.length))]+".",
    tpA[floor(random(tpA.length))]+"you have more chances to loose when a "+colors[floor(random(colors.length))]+" "+animals[floor(random(animals.length))]+" "+actions[floor(random(actions.length))]+".",
    tpA[floor(random(tpA.length))]+"the gameplay completely changes when a "+colors[floor(random(colors.length))]+" "+animals[floor(random(animals.length))]+" "+actions[floor(random(actions.length))]+".",
    tpA[floor(random(tpA.length))]+"money has no value unless a "+colors[floor(random(colors.length))]+" "+animals[floor(random(animals.length))]+" "+actions[floor(random(actions.length))]+".",
    "Here's how the eating part works : let's say green eats 1 red & 2 blues ; if there is at least 1 green in a player's set, each turn 1 red & 2 blue will disappear + additional 1 red & 2 blues for each 10 greens there."
  };
  String theText;
  Proverb() {
    theText=tpB[floor(random(tpB.length))];
  }
}

