/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.devices.jportaudio;

import com.jsyn.devices.AudioDeviceInputStream;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.devices.AudioDeviceOutputStream;
import com.portaudio.BlockingStream;
import com.portaudio.DeviceInfo;
import com.portaudio.HostApiInfo;
import com.portaudio.PortAudio;
import com.portaudio.StreamParameters;

public class JPortAudioDevice
implements AudioDeviceManager {
    private double suggestedOutputLatency = 0.03;
    private double suggestedInputLatency = 0.05;
    private static final int FRAMES_PER_BUFFER = 128;

    public JPortAudioDevice() {
        PortAudio.initialize();
    }

    @Override
    public int getDeviceCount() {
        return PortAudio.getDeviceCount();
    }

    @Override
    public String getDeviceName(int n) {
        DeviceInfo deviceInfo = PortAudio.getDeviceInfo((int)n);
        HostApiInfo hostApiInfo = PortAudio.getHostApiInfo((int)deviceInfo.hostApi);
        return deviceInfo.name + " - " + hostApiInfo.name;
    }

    @Override
    public int getDefaultInputDeviceID() {
        return PortAudio.getDefaultInputDevice();
    }

    @Override
    public int getDefaultOutputDeviceID() {
        return PortAudio.getDefaultOutputDevice();
    }

    @Override
    public int getMaxInputChannels(int n) {
        if (n < 0) {
            n = PortAudio.getDefaultInputDevice();
        }
        return PortAudio.getDeviceInfo((int)n).maxInputChannels;
    }

    @Override
    public int getMaxOutputChannels(int n) {
        if (n < 0) {
            n = PortAudio.getDefaultOutputDevice();
        }
        return PortAudio.getDeviceInfo((int)n).maxOutputChannels;
    }

    @Override
    public double getDefaultLowInputLatency(int n) {
        if (n < 0) {
            n = PortAudio.getDefaultInputDevice();
        }
        return PortAudio.getDeviceInfo((int)n).defaultLowInputLatency;
    }

    @Override
    public double getDefaultHighInputLatency(int n) {
        if (n < 0) {
            n = PortAudio.getDefaultInputDevice();
        }
        return PortAudio.getDeviceInfo((int)n).defaultHighInputLatency;
    }

    @Override
    public double getDefaultLowOutputLatency(int n) {
        if (n < 0) {
            n = PortAudio.getDefaultOutputDevice();
        }
        return PortAudio.getDeviceInfo((int)n).defaultLowOutputLatency;
    }

    @Override
    public double getDefaultHighOutputLatency(int n) {
        if (n < 0) {
            n = PortAudio.getDefaultOutputDevice();
        }
        return PortAudio.getDeviceInfo((int)n).defaultHighOutputLatency;
    }

    @Override
    public int setSuggestedOutputLatency(double d) {
        this.suggestedOutputLatency = d;
        return 0;
    }

    @Override
    public int setSuggestedInputLatency(double d) {
        this.suggestedInputLatency = d;
        return 0;
    }

    @Override
    public AudioDeviceOutputStream createOutputStream(int n, int n2, int n3) {
        return new JPAOutputStream(n, n2, n3);
    }

    @Override
    public AudioDeviceInputStream createInputStream(int n, int n2, int n3) {
        return new JPAInputStream(n, n2, n3);
    }

    @Override
    public String getName() {
        return "JPortAudio";
    }

    private class JPAInputStream
    extends JPAStream
    implements AudioDeviceInputStream {
        private JPAInputStream(int n, int n2, int n3) {
            this.samplesPerFrame = n3;
            StreamParameters streamParameters = new StreamParameters();
            streamParameters.channelCount = n3;
            if (n < 0) {
                n = PortAudio.getDefaultInputDevice();
            }
            streamParameters.device = n;
            streamParameters.suggestedLatency = JPortAudioDevice.this.suggestedInputLatency;
            int n4 = 0;
            System.out.println("Audio input from " + JPortAudioDevice.this.getDeviceName(n));
            this.blockingStream = PortAudio.openStream((StreamParameters)streamParameters, null, (int)n2, (int)128, (int)n4);
        }

        @Override
        public double read() {
            double[] dArray = new double[1];
            this.read(dArray, 0, 1);
            return dArray[0];
        }

        @Override
        public int read(double[] dArray) {
            return this.read(dArray, 0, dArray.length);
        }

        @Override
        public int read(double[] dArray, int n, int n2) {
            if (this.floatBuffer == null || this.floatBuffer.length < n2) {
                this.floatBuffer = new float[n2];
            }
            this.blockingStream.read(this.floatBuffer, n2 / this.samplesPerFrame);
            for (int i = 0; i < n2; ++i) {
                dArray[i + n] = this.floatBuffer[i];
            }
            return n2;
        }

        @Override
        public double getLatency() {
            return this.blockingStream.getInfo().inputLatency;
        }

        @Override
        public int available() {
            return this.blockingStream.getReadAvailable() * this.samplesPerFrame;
        }
    }

    private class JPAOutputStream
    extends JPAStream
    implements AudioDeviceOutputStream {
        private JPAOutputStream(int n, int n2, int n3) {
            this.samplesPerFrame = n3;
            StreamParameters streamParameters = new StreamParameters();
            streamParameters.channelCount = n3;
            if (n < 0) {
                n = PortAudio.getDefaultOutputDevice();
            }
            streamParameters.device = n;
            streamParameters.suggestedLatency = JPortAudioDevice.this.suggestedOutputLatency;
            int n4 = 0;
            System.out.println("Audio output on " + JPortAudioDevice.this.getDeviceName(n));
            this.blockingStream = PortAudio.openStream(null, (StreamParameters)streamParameters, (int)n2, (int)128, (int)n4);
        }

        @Override
        public void write(double d) {
            double[] dArray = new double[]{d};
            this.write(dArray, 0, 1);
        }

        @Override
        public void write(double[] dArray) {
            this.write(dArray, 0, dArray.length);
        }

        @Override
        public void write(double[] dArray, int n, int n2) {
            if (this.floatBuffer == null || this.floatBuffer.length < n2) {
                this.floatBuffer = new float[n2];
            }
            for (int i = 0; i < n2; ++i) {
                this.floatBuffer[i] = (float)dArray[i + n];
            }
            this.blockingStream.write(this.floatBuffer, n2 / this.samplesPerFrame);
        }

        @Override
        public double getLatency() {
            return this.blockingStream.getInfo().outputLatency;
        }
    }

    private class JPAStream {
        BlockingStream blockingStream;
        float[] floatBuffer = null;
        int samplesPerFrame;

        private JPAStream() {
        }

        public void close() {
            this.blockingStream.close();
        }

        public void start() {
            this.blockingStream.start();
        }

        public void stop() {
            this.blockingStream.stop();
        }
    }
}

