/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.ExponentialRamp;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.Pan;
import com.jsyn.unitgen.PowerOfTwo;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.TwoInDualOut;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.VoiceAllocator;
import com.jsyn.util.VoiceDescription;
import com.jsyn.util.VoiceOperation;
import com.softsynth.math.AudioMath;
import com.softsynth.shared.time.TimeStamp;

public class MultiChannelSynthesizer {
    private Synthesizer synth;
    private TwoInDualOut outputUnit;
    private ChannelContext[] channels;
    private static final int MAX_VELOCITY = 127;
    private double mMasterAmplitude = 0.25;

    public MultiChannelSynthesizer() {
        this(16);
    }

    public MultiChannelSynthesizer(int n) {
        this.channels = new ChannelContext[n];
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = new ChannelContext();
        }
    }

    public void setup(Synthesizer synthesizer, int n, int n2, int n3, VoiceDescription voiceDescription) {
        this.synth = synthesizer;
        if (this.outputUnit == null) {
            this.outputUnit = new TwoInDualOut();
            synthesizer.add(this.outputUnit);
        }
        ChannelGroupContext channelGroupContext = new ChannelGroupContext(n3, voiceDescription);
        for (int i = 0; i < n2; ++i) {
            this.channels[n + i].setup(channelGroupContext);
        }
    }

    public void programChange(int n, int n2) {
        ChannelContext channelContext = this.channels[n];
        channelContext.programChange(n2);
    }

    public void noteOff(int n, int n2, int n3) {
        double d = (double)n3 * 0.007874015748031496;
        this.noteOff(n, n2, d);
    }

    public void noteOff(int n, int n2, double d) {
        ChannelContext channelContext = this.channels[n];
        channelContext.noteOff(n2, d * this.mMasterAmplitude);
    }

    public void noteOff(int n, int n2, double d, TimeStamp timeStamp) {
        ChannelContext channelContext = this.channels[n];
        channelContext.noteOff(n2, d * this.mMasterAmplitude, timeStamp);
    }

    public void noteOn(int n, int n2, int n3) {
        double d = (double)n3 * 0.007874015748031496;
        this.noteOn(n, n2, d);
    }

    public void noteOn(int n, int n2, double d, TimeStamp timeStamp) {
        ChannelContext channelContext = this.channels[n];
        channelContext.noteOn(n2, d * this.mMasterAmplitude, timeStamp);
    }

    public void noteOn(int n, int n2, double d) {
        ChannelContext channelContext = this.channels[n];
        channelContext.noteOn(n2, d * this.mMasterAmplitude);
    }

    public void setPitchBend(int n, double d) {
        ChannelContext channelContext = this.channels[n];
        channelContext.setPitchBend(d);
    }

    public void setBendRange(int n, double d) {
        ChannelContext channelContext = this.channels[n];
        channelContext.setBendRange(d);
    }

    public void setPressure(int n, double d) {
        ChannelContext channelContext = this.channels[n];
        channelContext.setPressure(d);
    }

    public void setVibratoDepth(int n, double d) {
        ChannelContext channelContext = this.channels[n];
        channelContext.setVibratoDepth(d);
    }

    public void setTimbre(int n, double d) {
        ChannelContext channelContext = this.channels[n];
        channelContext.setTimbre(d);
    }

    public void setVolume(int n, double d) {
        ChannelContext channelContext = this.channels[n];
        channelContext.setVolume(d);
    }

    public void setPan(int n, double d) {
        ChannelContext channelContext = this.channels[n];
        channelContext.setPan(d);
    }

    public UnitOutputPort getOutput() {
        return this.outputUnit.output;
    }

    public void setMasterAmplitude(double d) {
        this.mMasterAmplitude = d;
    }

    public double getMasterAmplitude() {
        return this.mMasterAmplitude;
    }

    private class ChannelContext {
        private UnitOscillator lfo;
        private PowerOfTwo pitchToLinear;
        private LinearRamp timbreRamp;
        private LinearRamp pressureRamp;
        private ExponentialRamp volumeRamp;
        private Multiply volumeMultiplier;
        private Pan panner;
        private double vibratoRate = 5.0;
        private double bendRangeOctaves = 0.16666666666666666;
        private int presetIndex;
        private ChannelGroupContext groupContext;
        VoiceOperation voiceOperation = new VoiceOperation(){

            @Override
            public void operate(UnitVoice unitVoice) {
                unitVoice.usePreset(ChannelContext.this.presetIndex);
                ChannelContext.this.connectVoice(unitVoice);
            }
        };

        private ChannelContext() {
        }

        void setup(ChannelGroupContext channelGroupContext) {
            this.groupContext = channelGroupContext;
            this.pitchToLinear = new PowerOfTwo();
            MultiChannelSynthesizer.this.synth.add(this.pitchToLinear);
            this.lfo = new SineOscillator();
            MultiChannelSynthesizer.this.synth.add(this.lfo);
            this.timbreRamp = new LinearRamp();
            MultiChannelSynthesizer.this.synth.add(this.timbreRamp);
            this.timbreRamp.time.set(0.02);
            this.pressureRamp = new LinearRamp();
            MultiChannelSynthesizer.this.synth.add(this.pressureRamp);
            this.pressureRamp.time.set(0.02);
            this.volumeRamp = new ExponentialRamp();
            MultiChannelSynthesizer.this.synth.add(this.volumeRamp);
            this.volumeRamp.input.set(1.0);
            this.volumeRamp.time.set(0.02);
            this.volumeMultiplier = new Multiply();
            MultiChannelSynthesizer.this.synth.add(this.volumeMultiplier);
            this.panner = new Pan();
            MultiChannelSynthesizer.this.synth.add(this.panner);
            this.pitchToLinear.input.setValueAdded(true);
            this.lfo.output.connect(this.pitchToLinear.input);
            this.lfo.amplitude.set(0.0);
            this.lfo.frequency.set(this.vibratoRate);
            this.volumeRamp.output.connect(this.volumeMultiplier.inputB);
            this.volumeMultiplier.output.connect(this.panner.input);
            this.panner.output.connect(0, ((MultiChannelSynthesizer)MultiChannelSynthesizer.this).outputUnit.inputA, 0);
            this.panner.output.connect(1, ((MultiChannelSynthesizer)MultiChannelSynthesizer.this).outputUnit.inputB, 0);
        }

        private void connectVoice(UnitVoice unitVoice) {
            UnitInputPort unitInputPort;
            UnitInputPort unitInputPort2;
            UnitGenerator unitGenerator = unitVoice.getUnitGenerator();
            UnitInputPort unitInputPort3 = (UnitInputPort)unitGenerator.getPortByName("FreqScaler");
            if (unitInputPort3 != null) {
                unitInputPort3.disconnectAll();
                this.pitchToLinear.output.connect(unitInputPort3);
            }
            if ((unitInputPort2 = (UnitInputPort)unitGenerator.getPortByName("Timbre")) != null) {
                unitInputPort2.disconnectAll();
                this.timbreRamp.output.connect(unitInputPort2);
                this.timbreRamp.input.setup(unitInputPort2);
            }
            if ((unitInputPort = (UnitInputPort)unitGenerator.getPortByName("Pressure")) != null) {
                unitInputPort.disconnectAll();
                this.pressureRamp.output.connect(unitInputPort);
                this.pressureRamp.input.setup(unitInputPort);
            }
            unitVoice.getOutput().disconnectAll();
            unitVoice.getOutput().connect(this.volumeMultiplier.inputA);
        }

        void programChange(int n) {
            int n2 = n % this.groupContext.voiceDescription.getPresetCount();
            String string = this.groupContext.voiceDescription.getPresetNames()[n2];
            this.presetIndex = n2;
        }

        void noteOff(int n, double d) {
            this.groupContext.allocator.noteOff(n, MultiChannelSynthesizer.this.synth.createTimeStamp());
        }

        void noteOff(int n, double d, TimeStamp timeStamp) {
            this.groupContext.allocator.noteOff(n, timeStamp);
        }

        void noteOn(int n, double d) {
            this.noteOn(n, d, MultiChannelSynthesizer.this.synth.createTimeStamp());
        }

        void noteOn(int n, double d, TimeStamp timeStamp) {
            double d2 = AudioMath.pitchToFrequency(n);
            this.groupContext.allocator.noteOn(n, d2, d, this.voiceOperation, timeStamp);
        }

        public void setPitchBend(double d) {
            this.pitchToLinear.input.set(this.bendRangeOctaves * d);
        }

        public void setBendRange(double d) {
            this.bendRangeOctaves = d / 12.0;
        }

        public void setVibratoDepth(double d) {
            this.lfo.amplitude.set(d);
        }

        public void setVolume(double d) {
            double d2 = 1.5848931924611107E-5;
            double d3 = 1.0;
            double d4 = d3 / d2;
            double d5 = d2 * Math.pow(d4, d);
            this.volumeRamp.input.set(d5);
        }

        public void setPan(double d) {
            this.panner.pan.set(d);
        }

        public void setTimbre(double d) {
            double d2 = this.timbreRamp.input.getMinimum();
            double d3 = this.timbreRamp.input.getMaximum();
            double d4 = d2 + d * (d3 - d2);
            this.timbreRamp.input.set(d4);
        }

        public void setPressure(double d) {
            double d2 = this.pressureRamp.input.getMinimum();
            double d3 = this.pressureRamp.input.getMaximum();
            double d4 = d3 / d2;
            double d5 = d2 * Math.pow(d4, d);
            this.pressureRamp.input.set(d5);
        }
    }

    private class ChannelGroupContext {
        private VoiceDescription voiceDescription;
        private UnitVoice[] voices;
        private VoiceAllocator allocator;

        ChannelGroupContext(int n, VoiceDescription voiceDescription) {
            this.voiceDescription = voiceDescription;
            this.voices = new UnitVoice[n];
            for (int i = 0; i < n; ++i) {
                UnitVoice unitVoice = voiceDescription.createUnitVoice();
                UnitGenerator unitGenerator = unitVoice.getUnitGenerator();
                MultiChannelSynthesizer.this.synth.add(unitGenerator);
                this.voices[i] = unitVoice;
            }
            this.allocator = new VoiceAllocator(this.voices);
        }
    }
}

