/* autogenerated by Processing revision 1293 on 2025-04-18 */
import processing.core.*;
import processing.data.*;
import processing.event.*;
import processing.opengl.*;

import processing.sound.*;

import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;

public class gazoline extends PApplet {




int sizx = 500;
int sizy = 500;

float sol = sizy * 7 / 8;

Settings settings;
Player player;
Player[] players;
int nbDroid;
Droid[] droid;
boolean pressed[] = new boolean[128];
PFont font;

// Declare images and sounds
PImage plS, plR1L, plR2L, plRF1L, plRF2L, plR1R, plR2R, plRF1R, plRF2R,
  plStL, plStR, plJ1, plJ2, plF, plL, plFL, plFR, plD;
PImage dS, dD, dF, dC;
PImage back01, sol01;
SoundFile playerRespawn, droidDie, playerDie, playerBounce, playerLand,
  playerJump, playerHang, playerJet, droidMove, droidFire,
  playerSlide, playerStill, droidLaser, keyP, fond1, fond2, fond3,
  fond4;
boolean sound = true;

// Setup function
public void setup() {
  /* size commented out by preprocessor */;
  frameRate(50);
  sizx = width;
  sizy = height;

  /* noSmooth commented out by preprocessor */;
  colorMode(HSB);
  frameRate(60);
  noStroke();

  settings = new Settings();
  player = new Player(0);

  font = loadFont("VisitorTT1BRK-20.vlw");
  textFont(font);
  loadSound();
  loadGraphics();
  fond1.loop();
}

// Draw loop
public void draw() {
  switch(settings.mode) {
  case 0:
    menu();
    break;
  case 1:
    game();
    break;
  case 2:
    arcade();
    break;
  case 3:
    twoplayers();
    break;
  case 4:
    options();
    break;
  case 5:
    custom();
    break;
  case 6:
    gameOver();
    break;
  case 7:
    winner();
    break;
  }
}

// Load images
public void loadGraphics() {
  back01 = loadImage(dataPath("fond01.png"));
  sol01 = loadImage(dataPath("sol01.png"));
  plS = loadImage(dataPath("playerStill.png"));
  plR1L = loadImage(dataPath("playerRun1Left.png"));
  plR2L = loadImage(dataPath("playerRun2Left.png"));
  plRF1L = loadImage(dataPath("playerRunFast1Left.png"));
  plRF2L = loadImage(dataPath("playerRunFast2Left.png"));
  plStL = loadImage(dataPath("playerStartingLeft.png"));
  plR1R = loadImage(dataPath("playerRun1Right.png"));
  plR2R = loadImage(dataPath("playerRun2Right.png"));
  plRF1R = loadImage(dataPath("playerRunFast1Right.png"));
  plRF2R = loadImage(dataPath("playerRunFast2Right.png"));
  plStR = loadImage(dataPath("playerStartingRight.png"));
  plJ1 = loadImage(dataPath("playerJump1.png"));
  plJ2 = loadImage(dataPath("playerJump2.png"));
  plF = loadImage(dataPath("playerFall.png"));
  plL = loadImage(dataPath("playerLand.png"));
  plFL = loadImage(dataPath("playerFallLeft.png"));
  plFR = loadImage(dataPath("playerFallRight.png"));
  plD = loadImage(dataPath("playerDie.png"));
  dS = loadImage(dataPath("droidStill.png"));
  dD = loadImage(dataPath("droidDie.png"));
  dF = loadImage(dataPath("droidFire.png"));
  dC = loadImage(dataPath("droidClosed.png"));
}

// Key pressed
public void keyPressed() {
  if (key == CODED) pressed[keyCode] = true;
  else pressed[key & 0x7f] = true;
  if (settings.mode == 0) {
    keyP.play();
    if (keyCode == DOWN) {
      settings.selection = min(settings.selection + 1, 4);
    }
    if (keyCode == UP) {
      settings.selection = max(settings.selection - 1, 0);
    }
    if (keyCode == ENTER) {
      settings.start = true;
      settings.mode = settings.selection + 1;
      loadMode(settings.mode);
    }
  }
  else if (settings.mode == 4) {
    keyP.play();
    if (keyCode == DOWN) {
      settings.selection = min(settings.selection + 1, 5);
    }
    if (keyCode == UP) {
      settings.selection = max(settings.selection - 1, 0);
    }
    else if (settings.selection == 0) {
      if (keyCode == RIGHT) {
        settings.nbJoueurs = min(settings.nbJoueurs + 1, settings.nbJoueursMax);
      }
      if (keyCode == LEFT) {
        settings.nbJoueurs = max(settings.nbJoueurs - 1, 0);
      }
    }
    else if (settings.selection == 1) {
      if (keyCode == RIGHT) {
        settings.arcadeLevel++;
      }
      if (keyCode == LEFT) {
        settings.arcadeLevel = max(settings.arcadeLevel - 1, 0);
      }
    }    
    else if (settings.selection == 2 || settings.selection == 3 || settings.selection == 4) {
      if (keyCode == ENTER) {
        settings.keyToDefine = 2-(settings.selection-2);        
      } else if (keyCode == UP || keyCode == DOWN) {
        settings.keyToDefine = -1;
      } else {
        if (settings.keyToDefine != -1) {
          settings.touchesSet[settings.playerToDefine][settings.keyToDefine] = key;
          settings.playerToDefine = (settings.playerToDefine+1)%settings.nbJoueurs;
        }
      }
    }
    /*
    else if (settings.selection == 3) {
      if (keyCode == ENTER) {
        sound ^= true;
        if (sound) {
          fond4.loop();
        } else {
          fond4.stop();
        }
      }
    }
    */
    else if (settings.selection == 5) {
      if (keyCode == ENTER) {
        if (!settings.start) {
          settings.mode = 0;
          loadMode(0);
        }
      }
    }
  }
  if (settings.mode == 2) {
    if (keyCode == ENTER) {
      if (!settings.start) {
        settings.mode = 0;
        loadMode(0);
      }
    }
  }
  else if (settings.mode == 3) {
    if (keyCode == ENTER) {
      if (!settings.start) {
        settings.mode = 0;
        loadMode(0);
      }
    }
  }
  else if (settings.mode == 1) {
    if (keyCode == UP) {// DEBUG
      // settings.start=true;
      // settings.currentLevel++;
    }
    if (keyCode == BACKSPACE) {
      settings.start = true;
    }
    if (keyCode == ENTER) {
      if (!settings.start) {
        settings.mode = 0;
        loadMode(0);
      }
    }
  }
  else if (settings.mode == 5) {
    if (keyCode == BACKSPACE) {
      loadMode(5);
    }
  }
  else if (settings.mode == 6 || settings.mode == 7) {
    if (keyCode == ENTER) {
      settings.mode = 0;
      loadMode(0);
    }
  }
}

public void keyReleased() {
  if (key == CODED) pressed[keyCode] = false;
  else pressed[key & 0x7f] = false;
  settings.start = false;
}

// Menu function
public void menu() {
  background(192);
  textAlign(CENTER, CENTER);
  noStroke();
  fill(0, 255, 127);
  text("Gazoline", sizx / 2, sizy * 1 / 7);
  text("Hardcore tutorial", sizx / 2, sizy * 2 / 7);
  text("Arcade", sizx / 2, sizy * 3 / 7);
  text("Multiplayer", sizx / 2, sizy * 4 / 7);
  text("Options", sizx / 2, sizy * 5 / 7);
  text("Custom", sizx / 2, sizy * 6 / 7);
  pushMatrix();
  translate(0, (settings.selection + 2) * sizy / 7);
  image(dS, sizx * 1 / 10 - dS.width / 2, -dS.height / 2);
  image(dS, sizx * 9 / 10 - dS.width / 2, -dS.height / 2);
  stroke(0, 255, 255);
  fill(0, 0);
  strokeWeight(2);
  line(sizx * 1 / 10 + 2, 0, sizx * 3 / 10, 0);
  line(sizx * 9 / 10 - 2, 0, sizx * 7 / 10, 0);
  rect(sizx * 3 / 10, -sizy / 20, sizx * 4 / 10, sizy * 2 / 20);
  strokeWeight(1);
  popMatrix();
}

public void game() {
  if (settings.currentLevel == 0) {
    if (settings.start) {
      settings.start = false;
      nbDroid = 2;
      droid = new Droid[nbDroid];
      droid[0] = new DroidGentle(250, 415, 45, 0);
      droid[1] = new DroidGentle(350, 415, 90, 0);
      player.place(50, 400, true);
      settings.labelA = "Use " + PApplet.parseChar(settings.touchesSet[0][0]) + " and " + PApplet.parseChar(settings.touchesSet[0][2]) + " to go right and left.";
      settings.labelB = "To kill an eye, just touch it.";
      settings.labelC = "There are two eyes next to you, kill them.";
    }
    standardLevel();
  } else if (settings.currentLevel == 1) {
    if (settings.start) {
      settings.start = false;
      nbDroid = 3;
      droid = new Droid[nbDroid];
      droid[0] = new DroidGentle(300, 400, 45, 0);
      droid[1] = new DroidGentle(350, 350, 90, 0);
      droid[2] = new DroidGentle(400, 340, 135, 0);
      player.place(50, 400, true);
      settings.labelA = "Press " + PApplet.parseChar(settings.touchesSet[0][1]) + " to jump.";
      settings.labelB = "";
      settings.labelC = "";
    }
    standardLevel();
  } else if (settings.currentLevel == 2) {
    if (settings.start) {
      settings.start = false;
      nbDroid = 1;
      droid = new Droid[nbDroid];
      droid[0] = new DroidGentle(350, 250, 120, 2);
      player.place(50, 400, true);
      settings.labelA = "Grab the red line by holding down " + PApplet.parseChar(settings.touchesSet[0][1]) + ".";
      settings.labelB = "Release " + PApplet.parseChar(settings.touchesSet[0][1]) + " to propel yourself.";
      settings.labelC = "";
    }
    standardLevel();
  } else if (settings.currentLevel == 3) {
    if (settings.start) {
      settings.start = false;
      nbDroid = 3;
      droid = new Droid[nbDroid];
      droid[0] = new DroidGentle(200, 200, 60, 2);
      droid[1] = new DroidGentle(250, 250, 90, 2);
      droid[2] = new DroidGentle(300, 300, 120, 2);
      player.place(50, 400, true);
      settings.labelA = "Try killing several eyes without landing";
      settings.labelB = "to make a combo.";
      settings.labelC = "";
    }
    standardLevel();
  } else if (settings.currentLevel == 4) {
      if (settings.start) {
        settings.start = false;
        nbDroid = 5;
        droid = new DroidStill[nbDroid];
        droid[0] = new DroidStill(200, 200, 100, 1, 0.7f);
        droid[1] = new DroidStill(230, 200, 100, 1, 0.6f);
        droid[2] = new DroidStill(260, 200, 100, 1, 0.5f);
        droid[3] = new DroidStill(290, 200, 100, 1, 0.4f);
        droid[4] = new DroidStill(320, 200, 100, 1, 0.3f);
        player.place(50, 400, true);
        settings.labelA = "These eyes are dangerous.";
        settings.labelB = "Try not to be on their line";
        settings.labelC = "when it becomes yellow !";
      }
      standardLevel();
    } else if (settings.currentLevel == 5) {
      if (settings.start) {
        settings.start = false;
        nbDroid = 2;
        droid = new Droid[nbDroid];
        droid[0] = new Droid(sizx * 1 / 3, 300);
        droid[1] = new Droid(sizx * 2 / 3, 300);
        player.place(50, 400, true);
        settings.labelA = "Some eyes like to move.";
        settings.labelB = "";
        settings.labelC = "";
      }
      standardLevel();
    } else if (settings.currentLevel == 6) {
      if (settings.start) {
        settings.start = false;
        nbDroid = 10;
        droid = new Droid[nbDroid];
        for (int i = 0; i < nbDroid; i++) {
          droid[i] = new Droid(sizx / 2, sizy * 1 / 3);
        }
        player.place(50, 400, true);
        settings.labelA = "Ok, now the fun part.";
        settings.labelB = "";
        settings.labelC = "";
      }
      standardLevel();
    } else if (settings.currentLevel == 7) {
      if (settings.start) {
        settings.start = false;
        nbDroid = 1;
        droid = new DroidGater[nbDroid];
        droid[0] = new DroidGater(320, 350, 90, 3, 0.3f);
        player.place(50, 400, true);
        settings.labelA = "This one only tries to destroy you.";
        settings.labelB = "";
        settings.labelC = "";
      }
      standardLevel();
    } else if (settings.currentLevel == 8) {
      if (settings.start) {
        settings.start = false;
        nbDroid = 2;
        droid = new Droid[nbDroid];
        droid[0] = new DroidGater(320, 200, 100, 3, 0.9f);
        droid[1] = new DroidGentle(200, 340, 70, 2);
        player.place(50, 400, true);
        settings.labelA = "Press backspace to restart a level.";
        settings.labelB = "";
        settings.labelC = "";
      }
      standardLevel();
    } else if (settings.currentLevel == 9) {
      if (settings.start) {
        settings.start = false;
        nbDroid = 6;
        droid = new Droid[nbDroid];
        droid[0] = new DroidGater(180, 370, 60, 3, 1.4f);
        droid[1] = new DroidGater(220, 360, 120, 3, 1.3f);
        droid[2] = new DroidGater(260, 350, 60, 3, 1.2f);
        droid[3] = new DroidGater(300, 350, 120, 3, 1.1f);
        droid[4] = new DroidGater(340, 360, 60, 3, 1.0f);
        droid[5] = new DroidGater(380, 370, 120, 3, 0.9f);
        player.place(50, 400, true);
        settings.labelA = "";
        settings.labelB = "";
        settings.labelC = "";
      }
      standardLevel();
    } else if (settings.currentLevel == 10) {
      if (settings.start) {
        settings.start = false;
        nbDroid = 6;
        droid = new Droid[nbDroid];
        droid[0] = new DroidGater(100, 350, 90, 3, 1.5f);
        droid[1] = new DroidGater(200, 350, 90, 3, 2);
        droid[2] = new DroidGater(300, 350, 90, 3, 2);
        droid[3] = new DroidGater(400, 350, 90, 3, 1.5f);
        droid[4] = new DroidStill(150, 200, 90, 2, 0.5f);
        droid[5] = new DroidStill(350, 200, 90, 2, 0.5f);
        player.place(250, 400, true);
        settings.labelA = "";
        settings.labelB = "";
        settings.labelC = "";
      }
      standardLevel();
    } else if (settings.currentLevel == 11) {
      if (settings.start) {
        settings.start = false;
        nbDroid = 4;
        droid = new Droid[nbDroid];
        droid[0] = new DroidStill(130, 315, 100, 0, 0);
        droid[1] = new DroidGater(200, 270, -110, 3, 5);
        droid[2] = new DroidGater(200, 380, 110, 3, 5);
        droid[3] = new DroidStill(300, 170, 90, 2, 0);
        player.place(400, 400, true);
        settings.labelA = "";
        settings.labelB = "";
        settings.labelC = "";
      }
      standardLevel();
    } else if (settings.currentLevel == 12) {
      if (settings.start) {
        settings.start = false;
        nbDroid = 10;
        droid = new Droid[nbDroid + 1];
        int nbPath = nbDroid + 1;
        float[] pathX = new float[nbPath];
        float[] pathY = new float[nbPath];
        for (int i = 0; i < nbDroid + 1; i++) {
          pathX[i] = (float) (sizx / 2)
              + cos(TWO_PI * i / nbPath + 1) * 200;
          pathY[i] = (float) (sizy * 2 / 5)
              + sin(TWO_PI * i / nbPath) * 100;
          droid[i] = new DroidPath(pathX[i], pathY[i],
              ((((float) i + 5) % nbDroid) / nbDroid) * 80 + 50,
              floor((float) i * 2 / nbDroid + 2), 0.7f, pathX,
              pathY, i, i * 100 / nbDroid);
        }
        player.place(380, 400, true);
        settings.labelA = "";
        settings.labelB = "";
        settings.labelC = "";
      }
      standardLevel();
    } else if (settings.currentLevel == 13) {
      settings.mode = 7;
    }
}

// Helper method to run a standard level
public void standardLevel() {
  image(back01, 0, 0);
  smooth();
  player.keys();
  player.deplace();
  noSmooth();
  player.dessine();
  smooth();
  for (int i = 0; i < nbDroid; i++) {
    droid[i].agit();
    droid[i].dessine();
  }
  image(sol01, 0, 0);
  fill(0);
  textAlign(RIGHT);
  text(player.getLife() + " lives left", 450, 30);
  fill(0);
  textAlign(LEFT);
  text(settings.labelA, 50, 70);
  text(settings.labelB, 50, 90);
  text(settings.labelC, 50, 110);
  if (!checkSurvivors()) {
    settings.start = true;
    settings.currentLevel++;
  }
  if (player.getLife() <= 0) {
    settings.mode = 6; // Game over
  }
}

public void arcade() {
  background(0);
  image(back01, 0, 0);

  if (settings.start) {
    settings.start = false;
    nbDroid = settings.arcadeLevel;
    droid = new Droid[nbDroid];
    for (int i = 0; i < nbDroid; i++) {
      droid[i] = new Droid(random(width - 20), random(height / 2));
    }
    player.place(sizx / 2, sol - 20, true);
    player.setLife(3);
  }

  smooth();
  player.keys();
  player.deplace();
  noSmooth();
  player.dessine();

  smooth();
  for (int i = 0; i < nbDroid; i++) {
    droid[i].agit();
    droid[i].dessine();
  }

  image(sol01, 0, 0);

  fill(0);
  textAlign(RIGHT);
  text(player.getLife() + " lives left", sizx - 50, 30);

  if (!checkSurvivors()) {
    settings.start = true;
    settings.arcadeLevel++; // Increase difficulty each round
  }

  if (player.getLife() <= 0) {
    settings.mode = 6; // Game over
  }
}

// Helper method to check surviving droids
public boolean checkSurvivors() {
  for (int i = 0; i < nbDroid; i++) {
    if (droid[i].vivant) return true;
  }
  return false;
}

public void twoplayers() {
  background(0);
  image(back01, 0, 0);

  if (settings.start) {
    settings.start = false;
    players = new Player[2];
    players[0] = new Player(0);
    players[1] = new Player(1);
    players[0].place(100, sol - 20, true);
    players[1].place(sizx - 100, sol - 20, true);
    players[0].setLife(3);
    players[1].setLife(3);

    nbDroid = 10;
    droid = new Droid[nbDroid];
    for (int i = 0; i < nbDroid; i++) {
      droid[i] = new Droid(random(width - 20), random(height / 2));
    }
  }

  smooth();
  for (int i = 0; i < 2; i++) {
    players[i].keys();
    players[i].deplace();
  }

  noSmooth();
  for (int i = 0; i < 2; i++) {
    players[i].dessine();
  }

  smooth();
  for (int i = 0; i < nbDroid; i++) {
    droid[i].agit();
    droid[i].dessine();
  }

  image(sol01, 0, 0);

  fill(0);
  textAlign(LEFT);
  text("P1: " + players[0].getLife() + " lives", 50, 30);
  textAlign(RIGHT);
  text("P2: " + players[1].getLife() + " lives", sizx - 50, 30);

  if (players[0].getLife() <= 0 && players[1].getLife() <= 0) {
    settings.mode = 6; // Game over
  } else if (!checkSurvivors()) {
    settings.mode = 7; // Players win
  }
}

public void options() {
  background(50);

  fill(255);
  textAlign(CENTER, TOP);
  text("Options", sizx / 2, 20);

  String[] labels = {
    "Number of players: " + settings.nbJoueurs,
    "Arcade starting level: " + settings.arcadeLevel,
    "Key Left P"+(settings.playerToDefine+1)+" : " + PApplet.parseChar(settings.touchesSet[settings.playerToDefine][2]),
    "Key Jump: P"+(settings.playerToDefine+1)+" : " + PApplet.parseChar(settings.touchesSet[settings.playerToDefine][1]),
    "Key Right: P"+(settings.playerToDefine+1)+" : " + PApplet.parseChar(settings.touchesSet[settings.playerToDefine][0]),
    "Back to menu"
  };

  for (int i = 0; i < labels.length; i++) {
    fill(settings.selection == i ? color(255, 255, 0) : color(255));
    text(labels[i], sizx / 2, 100 + i * 50);
  }

}

public void custom() {
  standardLevel();
}

public void gameOver() {
  background(0);
  fill(255, 50, 50);
  textAlign(CENTER, CENTER);
  textSize(32);
  text("GAME OVER", sizx / 2, sizy / 2 - 20);

  textSize(16);
  text("Press ENTER to return to menu", sizx / 2, sizy / 2 + 30);

  if (pressed[ENTER]) {
    pressed[ENTER] = false;
    settings.mode = 0; // return to menu
    settings.start = true;
  }
}

public void winner() {
  background(0);
  fill(50, 255, 50);
  textAlign(CENTER, CENTER);
  textSize(32);
  text("YOU WIN!", sizx / 2, sizy / 2 - 20);

  textSize(16);
  text("Press ENTER to return to menu", sizx / 2, sizy / 2 + 30);

  if (pressed[ENTER]) {
    pressed[ENTER] = false;
    settings.mode = 0; // return to menu
    settings.start = true;
  }
}

// Settings Class
class Settings {
  int nbJoueursMax = 5;
  int[][] touchesSet = new int[nbJoueursMax][3];
  int mode = 0;
  int selection = 0;
  int currentLevel = 0;
  boolean start = true;
  String labelA = "", labelB = "", labelC = "";
  int comboDec = 0, comboDisp = 0;
  int keyToDefine = -1;
  int nbJoueurs = 2;
  int arcadeLevel = 10;
  int playerToDefine = 0;

  Settings() {
    for (int i = 0; i < nbJoueursMax; i++) {
      touchesSet[i][0] = 's';
      touchesSet[i][1] = 'd';
      touchesSet[i][2] = 'f';
    }
  }
}

class Player {
  int[] touches = new int[3];
  float x, y;// coordonn\u00e9es
  float vX, vY;// vitesse relative
  boolean saut = true;// en train de sauter
  boolean sautPret = true;// pret \u00e0 sauter
  int sprite = 0;// sprite \u00e0 afficher
  int altSp = 0;
  int sprSpeed = 10;// nombre de frames sur une anim
  float siz = 19;// taille du sprite
  int hanged = -1;// accroch\u00e9 \u00e0 quel ?
  float spiderX = -1;
  float spiderY = -1;
  float longFil = 0;// longueur du fil
  float balance;// d\u00e9placement sur la circonf\u00e9rence
  float balPos;// position sur la circonf\u00e9rence
  boolean dbJump = false;// en cours de deuxi\u00e8me saut
  boolean vivant = true;
  int combo = 0;
  int life = 0;

  Player(int j) {
    this.x = sizx / 2;
    this.y = sizy * 2 / 3;
    touches[0] = settings.touchesSet[j][0];
    touches[1] = settings.touchesSet[j][1];
    touches[2] = settings.touchesSet[j][2];
  }

  public void keys() {
    altSp++;
    if (vivant) {
      float hauteurFric = max(1, (float) (sizy - y) * 4 / sizy);
      if (pressed[touches[0]]) {
        if (!saut && vX >= 0) {
          if (sound)
            playerSlide.play();
        }
        vX = min(vX, -2);
        vX -= 0.2f / hauteurFric;
        if (sprite < 1 || sprite > 5) {// left 1=starting 2=R1 3=R2
          // 4=RF1 5=RF2
          if (!saut) {
            altSp = 0;
            sprite = 1;
          }
        }
        if (altSp > sprSpeed * 2 / 3) {
          if (altSp < sprSpeed * 3) {
            if (altSp % sprSpeed < sprSpeed / 2) {
              sprite = 2;
            } else {
              sprite = 3;
            }
          } else {
            if (altSp % sprSpeed < sprSpeed / 2) {
              sprite = 4;
            } else {
              sprite = 5;
            }
          }
        }
      }
      if (pressed[touches[2]]) {
        if (!saut && vX <= 0) {
          if (sound)
            playerSlide.play();
        }
        vX = max(vX, 2);
        vX += 0.2f / hauteurFric;
        if (sprite < 6 || sprite > 10) {// left 6=starting 7=R1 8=R2
          // 9=RF1 10=RF2
          if (!saut) {
            altSp = 0;
            sprite = 6;
          }
        }
        if (altSp > sprSpeed * 2 / 3) {
          if (altSp < sprSpeed * 3) {
            if (altSp % sprSpeed < sprSpeed / 2) {
              sprite = 7;
            } else {
              sprite = 8;
            }
          } else {
            if (altSp % sprSpeed < sprSpeed / 2) {
              sprite = 9;
            } else {
              sprite = 10;
            }
          }
        }
      }
      vX = constrain(vX, -5, 5);
      if (pressed[touches[1]]) {
        if (sautPret) {
          vY -= 7;
          if (sound)
            playerJump.play();
          saut = true;
          sautPret = false;
        }
        if (vY <= -1) {
          if (altSp % sprSpeed < sprSpeed / 2) {
            sprite = 11;
          } else {
            sprite = 12;
          }
        }
      } else {
        if (!dbJump) {
          vY = max(vY, -3);
        }
      }
    }
  }

  public void deplace() {
    if (vivant) {
      if (hanged == -1) {
        x += (vX);
        if (x < 0 || x > sizx - siz) {
          x = constrain(x, 0, sizx - siz);
          vX = 0;
        }
        if (abs(vX) < 1) {
          if (abs(vX) > 0) {
            if (sound)
              playerStill.play();
            vX = 0;
          }
          if (vY > -1 && !saut) {
            if (sprite != 14 || altSp > sprSpeed * 3) {
              sprite = 0;
            }
          }
          if (vY > 1) {
            sprite = 13;
          }
        }
        if (vY > 2) {
          if (vX <= -2) {
            sprite = 15;
          }
          if (vX >= 2) {
            sprite = 16;
          }
        }
        y += vY;
        vY += 0.3f;// gravit\u00e9
        if (!pressed[touches[2]] && !pressed[touches[0]] && !dbJump) {
          vX /= 1.3f;
        }
        if (y + siz > sol) {
          combo = 0;
          dbJump = false;
          y = sol - siz;
          vY = 0;
          if (saut) {
            sprite = 14;
            saut = false;
            altSp = 0;
            sautPret = false;
            if (sound)
              playerLand.play();
          } else {
            altSp++;
          }
          if (!pressed[touches[1]]) {
            sautPret = true;
          }
        }
        if (pressed[touches[1]] && y < sol - siz * 2) {
          for (int i = 0; i < nbDroid; i++) {
            if (droid[i].getVivant()) {
              if (droid[i].getPhase() == 2) {// s'accroche ?
                boolean accroche = false;
                float aParc = ceil(sqrt(sq(vX) + sq(vY)));// longueur
                // \u00e0
                // parcourir
                for (int i2 = 0; i2 < aParc && !accroche; i2++) {
                  float yDep = vY * (float) i2 / aParc;
                  float xDep = vX * (float) i2 / aParc;
                  float aA = atan2(
                    (y + yDep)
                    - (droid[i].getY() + droid[i]
                    .getSiz() / 2),
                    ((x + xDep) + siz / 2)
                    - (droid[i].getX() + droid[i]
                    .getSiz() / 2));
                  float aB = atan2(
                    (y + siz)
                    - (droid[i].getY() + droid[i]
                    .getSiz() / 2),
                    (x + siz * 1 / 3)
                    - (droid[i].getX() + droid[i]
                    .getSiz() / 2));
                  float aC = atan2(
                    (y + siz)
                    - (droid[i].getY() + droid[i]
                    .getSiz() / 2),
                    (x + siz * 2 / 3)
                    - (droid[i].getX() + droid[i]
                    .getSiz() / 2));
                  float aMin = (min(aA, min(aB, aC)) + TWO_PI)
                    % TWO_PI;
                  float aMax = (max(aA, max(aB, aC)) + TWO_PI)
                    % TWO_PI;
                  float distance = longueur(x + xDep
                    + (siz / 2), y + yDep, droid[i]
                    .getX(), droid[i].getY());
                  if ((droid[i].getTirA() + TWO_PI)
                    % TWO_PI <= aMax
                    && (droid[i].getTirA() + TWO_PI)
                    % TWO_PI >= aMin) {
                    hanged = i;
                    accroche = true;
                    spiderX = (float) droid[i].getX()
                      + (droid[i].getSiz() / 2)
                      + distance
                      * cos(droid[i].getTirA());
                    spiderY = (float) droid[i].getY()
                      + (droid[i].getSiz() / 2)
                      + distance
                      * sin(droid[i].getTirA());
                    x = spiderX - (siz / 2);
                    y = spiderY;
                    vY = 0;
                    longFil = 1;
                    balPos = PI / 2;
                    balance = (vX / 5) * (-PI / 20);
                    if (sound)
                      playerHang.play();
                  }
                }
              }
            }
          }
        }
        for (int i = 0; i < nbDroid; i++) {
          if (droid[i].getPhase() == 3 && droid[i].getVivant()) {// meurt
            // ?
            boolean mort = false;
            float aA = atan2(
              y
              - (droid[i].getY() + droid[i]
              .getSiz() / 2),
              (x + siz / 2)
              - (droid[i].getX() + droid[i]
              .getSiz() / 2));
            float aB = atan2(
              (y + siz)
              - (droid[i].getY() + droid[i]
              .getSiz() / 2), (x)
              - (droid[i].getX() + droid[i]
              .getSiz() / 2));
            float aC = atan2(
              (y + siz)
              - (droid[i].getY() + droid[i]
              .getSiz() / 2), (x + siz)
              - (droid[i].getX() + droid[i]
              .getSiz() / 2));
            float aMin = (min(aA, min(aB, aC)) + TWO_PI)
              % TWO_PI;
            float aMax = (max(aA, max(aB, aC)) + TWO_PI)
              % TWO_PI;
            if ((droid[i].getTirA() + TWO_PI) % TWO_PI <= aMax
              && (droid[i].getTirA() + TWO_PI) % TWO_PI >= aMin) {
              mort = true;
              float distance = longueur(x + (siz / 2), y,
                droid[i].getX(), droid[i].getY());
              x = (float) droid[i].getX()
                + (droid[i].getSiz() / 2) + distance
                * cos(droid[i].getTirA()) - (siz / 2);
              y = (float) droid[i].getY()
                + (droid[i].getSiz() / 2) + distance
                * sin(droid[i].getTirA());
              vivant = false;
              hanged = -1;
              vY = -10;
              vX = constrain(
                (x + siz / 2)
                - (droid[i].getX() + droid[i]
                .getSiz() / 2), -10, 10);
              if (abs(vX) < 1) {
                vX = -2;
              }
              life--;
              if (sound)
                playerDie.play();
            }
            float aParc = ceil(sqrt(sq(vX) + sq(vY)));// longueur
            // \u00e0
            // parcourir
            for (int i2 = 0; i2 < aParc && !mort; i2++) {
              float yDep = vY * i2 / aParc;
              float xDep = vX * i2 / aParc;
              if (abs(atan2(y + yDep - droid[i].getY(),
                (x + siz / 2) + xDep - droid[i].getX())
                - droid[i].getTirA()) < PI / 100) {
                mort = true;
                float distance = longueur(x + (siz / 2), y,
                  droid[i].getX(), droid[i].getY());
                x = (float) droid[i].getX()
                  + (droid[i].getSiz() / 2)
                  + distance
                  * cos(droid[i].getTirA())
                  - (siz / 2);
                y = (float) droid[i].getY()
                  + (droid[i].getSiz() / 2)
                  + distance
                  * sin(droid[i].getTirA());
                vivant = false;
                hanged = -1;
                vY = -10;
                vX = constrain((x + siz / 2)
                  - (droid[i].getX() + droid[i]
                  .getSiz() / 2), -10, 10);
                if (abs(vX) < 1) {
                  vX = -2;
                }
                life--;
                if (sound)
                  playerDie.play();
              }
            }
          }
        }
      } else {
        sprite = 17;
        if (spiderY + longFil + siz + 3 < sol) {
          longFil += 2;
        }
        balance -= (balPos - (PI / 2)) / (longFil * 4);
        balPos += balance;
        y = spiderY + longFil * sin(balPos);
        x = spiderX + longFil * cos(balPos) - (siz / 2);
        x = constrain(x, 0, sizx - siz);
        if (!pressed[touches[1]]) {
          hanged = -1;
          vY = sin(balPos + PI)
            * constrain(longFil, 3, min(15, y / 25));
          vX = cos(balPos + PI)
            * constrain(longFil, 3, min(15, y / 25));
          dbJump = true;
          if (sound)
            playerJet.play();
        } else if (droid[hanged].getPhase() != 2) {
          hanged = -1;
          dbJump = false;
        }
      }
      for (int i = 0; i < nbDroid; i++) {
        if (droid[i].getVivant()) {
          if (x + siz / 2 >= droid[i].getX()
            && x + siz / 2 <= droid[i].getX()
            + droid[i].getSiz()
            && y + siz / 2 >= droid[i].getY()
            && y + siz / 2 <= droid[i].getY()
            + droid[i].getSiz()) {
            droid[i].vivant = false;
            droid[i].creve = 10;
            if (sound)
              droidDie.play();
            combo++;
          }
        }
      }
    } else {// if !vivant
      sprite = 18;
      vY += 0.5f;
      vX *= 0.95f;
      y += vY;
      x += vX;
      if (x < 0 || x > sizx - siz) {
        x = constrain(x, 0, sizx - siz);
        vX = -vX;
      }
      if (y + 12 >= sol) {
        y = sol - 12;
        vY = -vY * 2 / 3;
        if (abs(vY) > 2) {
          if (sound)
            playerBounce.play();
        } else {
          vivant = true;
          if (sound)
            playerRespawn.play();
        }
      }
    }
  }

  public void dessine() {
    if (sprite == 0) {
      image(plS, x, y);
    }
    if (sprite == 1) {
      image(plStL, x, y);
    }
    if (sprite == 2) {
      image(plR1L, x, y);
    }
    if (sprite == 3) {
      image(plR2L, x, y);
    }
    if (sprite == 4) {
      image(plRF1L, x, y);
    }
    if (sprite == 5) {
      image(plRF2L, x, y);
    }
    if (sprite == 6) {
      image(plStR, x, y);
    }
    if (sprite == 7) {
      image(plR1R, x, y);
    }
    if (sprite == 8) {
      image(plR2R, x, y);
    }
    if (sprite == 9) {
      image(plRF1R, x, y);
    }
    if (sprite == 10) {
      image(plRF2R, x, y);
    }
    if (sprite == 11) {
      image(plJ1, x, y);
    }
    if (sprite == 12) {
      image(plJ2, x, y);
    }
    if (sprite == 13) {
      image(plF, x, y);
    }
    if (sprite == 14) {
      image(plL, x, y);
    }
    if (sprite == 15) {
      image(plFL, x, y);
    }
    if (sprite == 16) {
      image(plFR, x, y);
    }
    if (sprite == 17) {
      stroke(0);
      fill(0, 0, 255);
      ellipse(x + (siz / 2), y + 3, 6, 6);
      point(x + (siz / 2), y + 3);
      line(x + (siz / 2) - 2, y + 6,
        x + (siz / 2) - 5 + balance * 50, y + 10);
      line(x + (siz / 2) + 2, y + 6,
        x + (siz / 2) + 5 + balance * 50, y + 10);
      if (hanged != -1) {
        line(x + (siz / 2), y, spiderX, spiderY);
      } else {
        line(x + (siz / 2), y, x + (siz / 2), y - 3);
      }
    }
    if (sprite == 18) {
      image(plD, x, y);
    }
  }

  public void place(float x, float y, boolean still) {
    if (still) {
      vX = 0;
      vY = 0;
      vivant = true;
      dbJump = false;
      hanged = -1;
    }
    this.x = x;
    this.y = y;
  }

  public void setLife(int life) {
    this.life = life;
  }

  public int getCombo() {
    return combo;
  }

  public int getLife() {
    return life;
  }
}

class Droid {
  float x, y;// coordonnées
  float xD, yD;// destination
  int phase = 0;// 0=arr\u00eat\u00e9 1=d\u00e9place 2=tire 3=fait le mal
  float t = 0;// timer
  float tirA = 0;// angle de tir
  float siz = 18;
  float freqFonct = 1;// fréquence de fonctionnement
  boolean vivant = true;
  int creve = 10;

  Droid() {
    this.x = random(width - siz);
    this.y = random(height * 3 / 7) + (height / 7);
    this.freqFonct = random(0.1f, 0.8f);
    this.vivant = true;
  }

  Droid(float x, float y) {
    this.x = x;
    this.y = y;
    this.freqFonct = random(0.1f, 0.8f);
    this.vivant = true;
  }

  public void agit() {
    if (vivant) {
      t += freqFonct;
      if (t > 100) {
        t = 0;
        phase = (phase + 1) % 4;
        if (phase == 1) {
          moveSet();
        }
        if (phase == 2) {
          tirSet();
          if (sound)
            droidLaser.play();
        }
        if (phase == 3) {
          fireSet();
        }
      }
      if (phase == 0) {
      }
      if (phase == 1) {
        move();
      }
    }
  }

  public void dessine() {
    if (vivant) {
      if (phase == 0) {
        image(dC, x, y);
      }
      if (phase == 1) {
        image(dS, x, y);
      }
      if (phase == 2) {
        image(dS, x, y);
        stroke(0, 255 - max((t - 80) * 255 / 20, 0), 255);
        strokeWeight(2);
        line(x + siz / 2, y + siz / 2, x + siz / 2 + cos(tirA)
          * 1000, y + siz / 2 + sin(tirA) * 1000);
        strokeWeight(1);
      }
      if (phase == 3) {
        image(dF, x, y);
        stroke(32, 255, 255);
        strokeWeight(5);
        line(x + siz / 2, y + siz / 2, x + siz / 2 + cos(tirA)
          * 1000, y + siz / 2 + sin(tirA) * 1000);
        strokeWeight(1);
      }
    } else {
      if (creve > 0) {
        creve--;
        image(dD, x, y);
      }
    }
  }

  public void moveSet() {
    xD = random(width - siz);
    yD = random(height * 3 / 7) + (height / 7);
    if (sound)
      droidMove.play();
  }

  public void move() {
    x = x * 4 / 5 + xD * 1 / 5;
    y = y * 4 / 5 + yD * 1 / 5;
  }

  public void tirSet() {
    tirA = PI / 4 + random(PI / 2) + (x * 2 / sizx - 1) * (PI / 4);
  }

  public void fireSet() {
    t = 95;
    if (sound)
      droidFire.play();
  }

  public boolean getVivant() {
    return vivant;
  }

  public int getPhase() {
    return phase;
  }

  public float getX() {
    return x;
  }

  public float getY() {
    return y;
  }

  public float getSiz() {
    return siz;
  }

  public float getTirA() {
    return tirA;
  }
}

class DroidGentle extends Droid {
  DroidGentle(float x, float y, float tirA, int phase) {
    this.x = x;
    this.y = y;
    this.tirA = (tirA * PI / 180);
    this.phase = phase;
    this.vivant = true;
  }

  public void agit() {
  }
}

class DroidStill extends Droid {
  DroidStill(float x, float y, float tirA, int phase, float freqFonct) {
    this.x = x;
    this.y = y;
    this.tirA = (tirA * PI / 180);
    this.phase = phase;
    this.vivant = true;
    this.freqFonct = freqFonct;
  }

  public void moveSet() {
    t = 99;
  }

  public void move() {
  }

  public void tirSet() {
  }
}

class DroidGater extends Droid {
  DroidGater(float x, float y, float tirA, int phase, float freqFonct) {
    this.x = x;
    this.y = y;
    this.tirA = (tirA * PI / 180);
    this.phase = phase;
    this.vivant = true;
    this.freqFonct = freqFonct;
  }

  public void tirSet() {
    t = 95;
  }

  public void fireSet() {
  }

  public void moveSet() {
    t = 99;
  }

  public void move() {
  }
}

class DroidPath extends Droid {
  int currentPath;
  float[] pathX;
  float[] pathY;

  DroidPath(float x, float y, float tirA, int phase, float freqFonct,
    float[] pathX, float[] pathY, int currentPath, float t) {
    this.currentPath = currentPath;
    this.x = x;
    this.y = y;
    this.tirA = (tirA * PI / 180);
    this.phase = phase;
    this.vivant = true;
    this.freqFonct = freqFonct;
    this.pathX = pathX;
    this.pathY = pathY;
    this.t = t;
  }

  public void moveSet() {
    currentPath = (currentPath + 1) % pathX.length;
    xD = pathX[currentPath];
    yD = pathY[currentPath];
    if (sound)
      droidMove.play();
  }

  public void tirSet() {
  }
}

public void loadMode(int mode) {
  if (mode == 0) {
    settings.selection = 0;
    if (sound) {
      loadSoundBackground(1);
    }
  }
  if (mode == 1) {
    player.setLife(5);
    settings.currentLevel = 0;
    settings.start = true;
    loadSoundBackground(2);
  }
  if (mode == 2) {
    nbDroid = settings.arcadeLevel;
    droid = new Droid[nbDroid];
    for (int i = 0; i < nbDroid; i++) {
      droid[i] = new Droid();
    }
    loadSoundBackground(3);
  }
  if (mode == 3) {
    players = new Player[settings.nbJoueurs];
    for (int i = 0; i < settings.nbJoueurs; i++) {
      players[i] = new Player(i);
      players[i].place((i + 1) * sizx / (settings.nbJoueurs + 1),
        400, true);
    }
    nbDroid = settings.arcadeLevel;
    droid = new Droid[nbDroid];
    for (int i = 0; i < nbDroid; i++) {
      droid[i] = new Droid();
    }
    loadSoundBackground(3);
  }
  if (mode == 4) {
    settings.selection = 0;
    loadSoundBackground(4);
  }
  if (mode == 5) {
    String[] cus = loadStrings(dataPath("customLevel.txt"));
    if (settings.start) {
      player.setLife(PApplet.parseInt(cus[0]));
      settings.start = false;
    }
    nbDroid = PApplet.parseInt(cus[1]);
    droid = new Droid[nbDroid];
    int cusI = 2;
    for (int i = 0; i < nbDroid; i++) {
      if (PApplet.parseInt(cus[cusI]) == 0) {
        droid[i] = new DroidGentle(PApplet
          .parseFloat(cus[cusI + 1]), PApplet
          .parseFloat(cus[cusI + 2]), PApplet
          .parseFloat(cus[cusI + 3]), PApplet
          .parseInt(cus[cusI + 4]));
        cusI += 5;
      } else if (PApplet.parseInt(cus[cusI]) == 1) {
        droid[i] = new DroidStill(
          PApplet.parseFloat(cus[cusI + 1]), PApplet
          .parseFloat(cus[cusI + 2]), PApplet
          .parseFloat(cus[cusI + 3]), PApplet
          .parseInt(cus[cusI + 4]), PApplet
          .parseFloat(cus[cusI + 5]));
        cusI += 6;
      } else if (PApplet.parseInt(cus[cusI]) == 2) {
        droid[i] = new DroidGater(
          PApplet.parseFloat(cus[cusI + 1]), PApplet
          .parseFloat(cus[cusI + 2]), PApplet
          .parseFloat(cus[cusI + 3]), PApplet
          .parseInt(cus[cusI + 4]), PApplet
          .parseFloat(cus[cusI + 5]));
        cusI += 6;
      } else if (PApplet.parseInt(cus[cusI]) == 3) {
        int nbPath = PApplet.parseInt(cus[cusI + 1]);
        cusI += 2;
        float[] pathX = new float[nbPath];
        float[] pathY = new float[nbPath];
        for (int i2 = 0; i2 < nbPath; i2++) {
          pathX[i2] = PApplet.parseFloat(cus[cusI + i2]);
        }
        cusI += nbPath;
        for (int i2 = 0; i2 < nbPath; i2++) {
          pathY[i2] = PApplet.parseFloat(cus[cusI + i2]);
        }
        cusI += nbPath;
        droid[i] = new DroidPath(PApplet.parseFloat(cus[cusI + 0]),
          PApplet.parseFloat(cus[cusI + 1]), PApplet
          .parseFloat(cus[cusI + 2]), PApplet
          .parseInt(cus[cusI + 3]), PApplet
          .parseFloat(cus[cusI + 4]), pathX, pathY,
          PApplet.parseInt(cus[cusI + 5]), PApplet
          .parseFloat(cus[cusI + 6]));
        cusI += 7;
      } else if (PApplet.parseInt(cus[cusI]) == 4) {
        droid[i] = new Droid(PApplet.parseFloat(cus[cusI + 1]),
          PApplet.parseFloat(cus[cusI + 2]));
        cusI += 3;
      } else if (PApplet.parseInt(cus[cusI]) == 5) {
        droid[i] = new Droid();
        cusI += 1;
      }
    }
    player.place(PApplet.parseFloat(cus[cusI]), PApplet
      .parseFloat(cus[cusI + 1]), PApplet
      .parseBoolean(cus[cusI + 2]));
    cusI += 3;
    loadSoundBackground(3);
  }
}

public void loadSoundBackground(int i) {
  if (sound) {
    fond1.stop();
    fond2.stop();
    fond3.stop();
    fond4.stop();
    if (i == 1)
      fond1.loop();
    if (i == 2)
      fond2.loop();
    if (i == 3)
      fond3.loop();
    if (i == 4)
      fond4.loop();
  }
}

public float longueur(float x, float y, float x2, float y2) {
  return sqrt(sq(x2 - x) + sq(y2 - y));
}

public void loadSound() {
  playerRespawn = new SoundFile(this, dataPath("playerRespawn.wav"));
  droidDie = new SoundFile(this, dataPath("droidDie.wav"));
  playerDie = new SoundFile(this, dataPath("playerDie.wav"));
  playerBounce = new SoundFile(this, dataPath("playerBounce.wav"));
  playerLand = new SoundFile(this, dataPath("playerLand.wav"));
  playerJump = new SoundFile(this, dataPath("playerJump.wav"));
  playerHang = new SoundFile(this, dataPath("playerHang.wav"));
  playerJet = new SoundFile(this, dataPath("playerJet.wav"));
  droidMove = new SoundFile(this, dataPath("droidMove.wav"));
  droidFire = new SoundFile(this, dataPath("droidFire.wav"));
  playerSlide = new SoundFile(this, dataPath("playerSlide.wav"));
  playerStill = new SoundFile(this, dataPath("playerStill.wav"));
  droidLaser = new SoundFile(this, dataPath("droidLaser.wav"));
  keyP = new SoundFile(this, dataPath("keyP.wav"));
  fond1 = new SoundFile(this, dataPath("fond01.wav"));
  fond2 = new SoundFile(this, dataPath("fond02.wav"));
  fond3 = new SoundFile(this, dataPath("fond03.wav"));
  fond4 = new SoundFile(this, dataPath("fond04.wav"));
}


  public void settings() { size(500, 500, P2D);
noSmooth(); }

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "gazoline" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
