<?php
 
	function deleteNode($node) {
		deleteChildren($node);
		$parent = $node->parentNode;
		$oldnode = $parent->removeChild($node);
	}

	function deleteChildren($node) {
		while (isset($node->firstChild)) {
			deleteChildren($node->firstChild);
			$node->removeChild($node->firstChild);
		}
	}

	if (isset($_POST['userName']) && 
		isset($_POST['password']) && 
		isset($_POST['artistName']) &&
		isset($_POST['value'])) {
		$userName = $_POST['userName'];
		$password = $_POST['password'];
		$artistName = urldecode($_POST['artistName']);
		$value = $_POST['value'];
	}

	$baseXml = 'stocks.xml';
	$doc = new DOMDocument();
	$doc->Load($baseXml);	

	$goodPassword = false;
	$users = $doc->getElementsByTagName('users')->item(0)->getElementsByTagName('user');
	for ($i=0 ; $i < $users->length && !$userFound ; $i++) {
		$thisUserName = $users->item($i)->getAttribute("name");
		if ($thisUserName == $userName) {
			$currentUser = $users->item($i);
			if ($users->item($i)->getAttribute("password") == md5($password)) {
				$goodPassword = true;
			}
		}
	}
	
	$saveNeeded = false;
	
	if ($goodPassword) {
		if ($currentUser->getAttribute("wealth")-$value >= 0) {
			$stocks = $currentUser->getElementsByTagName('stocks')->item(0)->getElementsByTagName('stock');
			$stocksFound = false;
			for ($i=0 ; $i < $stocks->length ; $i++) {
				$thisArtistName = $stocks->item($i)->getAttribute("name");
				if ($thisArtistName == $artistName) {
					$value = max($value,-$stocks->item($i)->getAttribute("value"));
					$stocksFound = true;
 					if ($stocks->item($i)->getAttribute("value") >= -$value) {
						$stocks->item($i)->setAttribute("value",$stocks->item($i)->getAttribute("value")+$value);
						$currentUser->setAttribute("wealth",$currentUser->getAttribute("wealth")-$value);
						if ($stocks->item($i)->getAttribute("value")<=0) deleteNode($stocks->item($i));
						$saveNeeded = true;
						echo "Transaction done.";
					} else {
						echo "You don't have any stock from this artist to sell yet.";
					}
				}
			}
			if (!$stocksFound) {
				if ($value >= 0) {
					$newStock = $doc->createElement('stock');
					$newStock->setAttribute('name', $artistName);
					$newStock->setAttribute('value', $value);
					
					$artistDocUrl = "http://ws.audioscrobbler.com/2.0/?method=artist.getinfo&artist=" . urlencode($artistName) . "&api_key=4a655ba001707c0f93ae90e4ee8d2cf5";
					$artistDoc = new DOMDocument("1.0","utf-8");
					$artistDoc->Load($artistDocUrl);

					$newStock->setAttribute('plays', $artistDoc->getElementsByTagName('artist')->item(0)->getElementsByTagName('stats')->item(0)->getElementsByTagName('playcount')->item(0)->nodeValue);
					$newStock->setAttribute('direction', "new");
					
					$currentUser->setAttribute("wealth",$currentUser->getAttribute("wealth")-$value);
					$currentUser->getElementsByTagName('stocks')->item(0)->appendChild($newStock);
					$saveNeeded = true;
					echo "New artist was added to your stocks.";
				} else {
					echo "You don't have any stock from this artist to sell yet.";
				}
			}
		} else {
			echo "You don't have enough money to do that.";
		}
	} else {
		echo 'Something went wrong.';
	}

	if ($saveNeeded) {
		$doc->formatOutput = true;
		$doc->preserveWhiteSpace = false;
		$doc->saveXML();
		$doc->save($baseXml);
	}
	
?>