 <html>
    
    <head>
        <style type="text/css">
            body {
                background-color:#F0F0F0;
            }
            a {
                color:#0000FF;
                cursor:pointer
            }
            a:link {
                text-decoration:none
            }
            a:hover {
                color:#FFFFFF;
            }
            .box {
                margin:5px;
                border-width: 15px;
                -moz-border-image: url(tube-cadre.png) 36 round;
                -webkit-border-image: url(tube-cadre.png) 36 round;
                -o-border-image: url(tube-cadre.png) 36 round;
                border-image: url(tube-cadre.png) 36 fill round;
				border-style:solid;
            }
            #promptBox {
                float:left;
                width:230px;
                height:120px;
            }
            #infos {
                float:left;
                width:230px;
                height:120px;
            }
            #clearFloat {
                clear: both;
            }
            #search {
                float: left;
                width:300px;
                height:170px;
            }
            #artist {
                float:left;
                width:300px;
                min-height:350px;
            }
            #actions {
                float:left;
                width:500px;
                min-height:400px;
            }
            #tops {
                float:left;
                width:200px;
                min-height:560px;
            }
        </style>
        <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js"></script>
        <script type="text/javascript">
            var apiKey = "...";

            var userName = "";
            var password = "";
            var wealth = "";

            var lastQuery = "";
            var deployedArtist = "";
            var suggestions = new Array();
            var stocksArtists = new Array();

            var topUsers = new Array();

            $(document).ready(function () {
                putLogInBoxes();
                updateTops();
                if (getCookie('userName').length > 0) {
                    $('#userNameInput').val(getCookie('userName'));
                    $('#passwordInput').val(getCookie('password'));
                    logIn();
                } else {
                    disconnect();
                }
                setInterval("timedUpdate()", 5000);
                promptBox("Welcome");
            });

            function timedUpdate() {
                updateTops();
                updateUserData();
            }

            function promptBox(message) {
                $('#promptBox').html(message);
            }

            function setCookie(c_name, value, exdays) {
                var exdate = new Date();
                exdate.setDate(exdate.getDate() + exdays);
                var c_value = escape(value) + ((exdays == null) ? "" : "; expires=" + exdate.toUTCString());
                document.cookie = c_name + "=" + c_value;
            }

            function getCookie(c_name) {
                var i, x, y, ARRcookies = document.cookie.split(";");
                for (i = 0; i < ARRcookies.length; i++) {
                    x = ARRcookies[i].substr(0, ARRcookies[i].indexOf("="));
                    y = ARRcookies[i].substr(ARRcookies[i].indexOf("=") + 1);
                    x = x.replace(/^\s+|\s+$/g, "");
                    if (x == c_name) return unescape(y);
                }
            }

            function updateTops() {
                $.ajax({
                    type: "GET",
                    url: "stocks.xml",
                    success: function (result) {
                        var users = result.documentElement.getElementsByTagName('users')[0].getElementsByTagName('user');
                        var unsortedUsers = new Array();
                        for (var i = 0; i < users.length; i++) {
                            var thisUserObj = {
                                name: users[i].getAttribute('name'),
                                wealth: users[i].getAttribute('wealth')
                            };
                            unsortedUsers.push(thisUserObj);
                        }
                        topUsers = new Array();
                        while (unsortedUsers.length > 0) {
                            bestIndex = -1;
                            bestValue = -1;
                            for (var i = 0; i < unsortedUsers.length; i++) {
                                var thisValue = parseInt(unsortedUsers[i].wealth);
                                if (i == 0 || thisValue > bestValue) {
                                    bestIndex = i;
                                    bestValue = thisValue;
                                }
                            }
                            topUsers.push(unsortedUsers[bestIndex]);
                            unsortedUsers.splice(bestIndex, 1);
                        }
                        var lineToAdd = "top users : <br/>";
                        for (var i = 0; i < Math.min(topUsers.length, 20); i++) {
                            lineToAdd += topUsers[i].name + " ==> ";
                            lineToAdd += Math.floor(topUsers[i].wealth) + " $ <br/>";
                        }
                        $('#tops').html(lineToAdd);
                    }
                })
            }

            function disconnect() {
                putLogInBoxes();
                $('#artistActions').html("");
                setCookie('userName', userName, 365);
                setCookie('password', password, 365);
                updateUserData();
                promptBox("You logged out.");
            }

            function putLogInBoxes() {
                var lineToAdd = '';
                lineToAdd += 'username : <input id="userNameInput" type="text" value="' + userName + '"/><br/>';
                lineToAdd += 'password : <input id="passwordInput" type="password" value="' + password + '"/><br/>';
                userName = "";
                password = "";
                lineToAdd += '<a onClick="logIn()">LOG IN</a><br/>';
                lineToAdd += '<a onClick="register()">REGISTER</a><br/>';
                $('#logIn').html(lineToAdd);
            }

            function logIn() {
                userName = $('#userNameInput').val();
                password = $('#passwordInput').val();
                $.ajax({
                    type: "GET",
                    url: "checkPassword.php?name=" + userName + "&password=" + password,
                    success: function (result) {
                        if (result == "true") {
                            $('#logIn').html('<a onClick="disconnect()">disconnect</a>');
                            promptBox("You logged in.");
                            setCookie('userName', userName, 365);
                            setCookie('password', password, 365);
                            updateUserData();
                        } else {
                            promptBox("Username and password don't match.");
                        }
                    }
                });
            }

            function updateUserData() {
                if (userName.length > 0) {
                    $.ajax({
                        type: "GET",
                        url: "stocks.xml",
                        success: function (result) {
                            var users = result.documentElement.getElementsByTagName('users')[0].getElementsByTagName('user');
                            for (var i = 0; i < users.length; i++) {
                                if (users[i].getAttribute("name") == userName) {
                                    wealth = users[i].getAttribute("wealth");
                                    var stocks = users[i].getElementsByTagName('stocks')[0].getElementsByTagName('stock');
                                    var lineToAdd = "";
                                    lineToAdd += '<table>';
									lineToAdd += '<tr><td></td><td>plays</td><td>your stocks<td/></tr>';
                                    stocksArtists = new Array();
                                    for (var j = 0; j < stocks.length; j++) {
                                        var artistName = stocks[j].getAttribute("name");
                                        stocksArtists[j] = encodeURIComponent(artistName);
                                        lineToAdd += '<tr>';
                                        lineToAdd += '<td>';
                                        lineToAdd += '<a onClick="buyStocks(' + j + ',1)"><img src="plus.png" /></a> <a onClick="buyStocks(' + j + ',-1)"><img src="minus.png" /></a> ';
                                        lineToAdd += '</td><td>';
                                        lineToAdd += " " + stocks[j].getAttribute("direction") + " ";
                                        lineToAdd += '</td><td>';
                                        lineToAdd += " " + Math.floor(stocks[j].getAttribute("value")) + " $ ";
                                        lineToAdd += '</td><td>';
                                        lineToAdd += '<a onClick="deployInfos(0,\'' + j + '\')">' + artistName + '</a> ';
                                        lineToAdd += '</td>';
                                        lineToAdd += '</tr>';
                                    }
                                    lineToAdd += '<table>';
                                    $("#actions").html(lineToAdd);
                                }
                            }
                            $('#userName').html('user : ' + userName);
                            $('#userData').html('wealth : ' + Math.floor(wealth) + ' $');
                        }
                    });
                } else {
                    wealth = "";
                    $('#userName').html('');
                    $('#userData').html('');
                    $("#actions").html('');
                }
            }

            function register() {
                var userName = $('#userNameInput').val();
                var password = $('#passwordInput').val();
                var goodNameFormat = false;
                if (userName.length > 0 && password.length > 0) {
                    if (/^[a-zA-Z]*$/.test(userName) && /^[a-zA-Z]*$/.test(password)) {
                        goodNameFormat = true;
                        $.ajax({
                            type: "GET",
                            url: "addUser.php?name=" + userName + "&password=" + password,
                            success: function (result) {
                                promptBox(result);
                                logIn();
                            }
                        });
                    }
                }
                if (!goodNameFormat) promptBox('Please use A-Z/a-z letters<br/>in both username and passwords.<br/>');
            }

            function deployInfos(source, index) {
                deployedArtist = "";
                if (source == 0) deployedArtist = stocksArtists[index];
                if (source == 1) deployedArtist = suggestions[index];
                $.ajax({
                    type: "GET",
                    dataType: "xml",
                    url: "http://ws.audioscrobbler.com/2.0/?method=artist.getinfo&artist=" + deployedArtist + "&api_key=" + apiKey,
                    success: function (result) {
                        var name = result.documentElement.getElementsByTagName('artist')[0].getElementsByTagName('name')[0].firstChild.nodeValue;
                        var playCount = result.documentElement.getElementsByTagName('artist')[0].getElementsByTagName('stats')[0].getElementsByTagName('playcount')[0].firstChild.nodeValue;
                        var listeners = result.documentElement.getElementsByTagName('artist')[0].getElementsByTagName('stats')[0].getElementsByTagName('listeners')[0].firstChild.nodeValue;
                        try {
                            var imageUrl = result.documentElement.getElementsByTagName('artist')[0].getElementsByTagName('image')[2].firstChild.nodeValue;
                        } catch (e) {
                            imageUrl = "unknown.png"
                        }
                        var pageUrl = result.documentElement.getElementsByTagName('artist')[0].getElementsByTagName('url')[0].firstChild.nodeValue;
                        var lineToAdd = "";
                        lineToAdd += name + '<br/>';
                        lineToAdd += '<img src="' + imageUrl + '" /><br/>';
                        lineToAdd += 'current play count : ' + playCount + '<br/>';
                        lineToAdd += 'current listeners  : ' + listeners + '<br/>';
                        lineToAdd += '<a href="' + pageUrl + '" target="_blank">view last.fm page</a><br/>';
                        $('#artistInfos').html(lineToAdd);
                        if (userName.length > 0) {
                            var lineToAdd = "";
                            lineToAdd += '<a onClick="buyStocks(-1,1)"><img src="plus.png" /></a> buy stocks<br/>';
                            lineToAdd += '<a onClick="buyStocks(-1,-1)"><img src="minus.png" /></a> sell stocks<br/>';
                            $('#artistActions').html(lineToAdd);
                        }
                    }
                });
            }

            function buyStocks(source, value) {
                var artistName = "";
                if (source == -1) artistName = deployedArtist;
                else artistName = stocksArtists[source];
                $.ajax({
                    type: "POST",
                    url: "buy.php",
                    data: {
                        userName: userName,
                        password: password,
                        artistName: artistName,
                        value: value
                    },
                    success: function (result) {
                        promptBox(result);
                        updateUserData();
                        updateTops();
                    }
                });
            }

            function searchArtists() {
                var query = encodeURIComponent($("#searchInput").val());
                if (query != lastQuery) {
                    lastQuery = query;
                    if (query.length > 0) {
                        $('#suggestions').html('... wait ...');
                        $.ajax({
                            type: "GET",
                            dataType: "xml",
                            url: "http://ws.audioscrobbler.com/2.0/?method=artist.search&artist=" + query + "&limit=5&api_key=" + apiKey,
                            success: function (result) {
                                var artists = result.documentElement.getElementsByTagName('results')[0].getElementsByTagName('artistmatches')[0].getElementsByTagName('artist');
                                $('#suggestions').html("");
                                suggestions = new Array();
                                for (var i = 0; i < Math.min(artists.length, 5); i++) {
                                    var pageUrl = artists[i].getElementsByTagName('url')[0].firstChild.nodeValue;
                                    var artistName = artists[i].getElementsByTagName('name')[0].firstChild.nodeValue;
                                    var lineToAdd = "";
                                    suggestions[i] = encodeURIComponent(artistName);
                                    lineToAdd += '<a onClick="deployInfos(1,\'' + i + '\')">' + artistName + '</a><br/> ';
                                    $("#suggestions").append(lineToAdd);
                                }
                            }
                        });
                    } else {
                        $('#suggestions').html('');
                    }
                }
            }
        </script>
    </head>
    
    <body>
        <table>
            <tr>
                <td style="vertical-align:top;">
                    <div class="box" id="infos">
                        </p>
                        <p id="userName"></p>
                        <p id="userData"></p>
                        <p id="logIn">
                    </div>
                    <div class="box" id="promptBox"></div>
                    <div id="clearFloat" />
                    <div class="box" id="actions"></div>
                </td>
                <td style="vertical-align:top;">
                    <div class="box" id="search">Search for an artist :
                        <br/>
                        <input id="searchInput" type="text" onkeyup="searchArtists()" />
                        <p id="suggestions" />
                    </div>
                    <div id="clearFloat" />
                    <div class="box" id="artist">
                        <p id="artistInfos"></p>
                        <p id="artistActions"></p>
                    </div>
                </td>
                <td style="vertical-align:top;">
                    <div class="box" id="tops"></div>
                </td>
            </tr>
        </table>
    </body>

</html>