/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PVector;

public class maze
extends PApplet {
    int pxS = 7;
    int siz = 70;
    Player player;
    boolean[][] px;
    boolean[][] toReach;

    public void setup() {
        this.size(this.siz * this.pxS, this.siz * this.pxS);
        this.frameRate(20.0f);
        this.player = new Player(this.siz / 2, this.siz / 2);
        this.px = new boolean[this.siz][this.siz];
        this.toReach = new boolean[this.siz][this.siz];
        int n = 0;
        while (n < this.siz) {
            int n2 = 0;
            while (n2 < this.siz) {
                this.px[n2][n] = false;
                this.toReach[n2][n] = false;
                ++n2;
            }
            ++n;
        }
        this.drawCorridor(this.siz / 2, this.siz / 2);
    }

    public void draw() {
        int n;
        if (this.keyPressed) {
            if (this.keyCode == 38) {
                this.player.move(0, -1);
            }
            if (this.keyCode == 40) {
                this.player.move(0, 1);
            }
            if (this.keyCode == 37) {
                this.player.move(-1, 0);
            }
            if (this.keyCode == 39) {
                this.player.move(1, 0);
            }
        }
        this.background(0);
        this.noStroke();
        this.fill(255);
        int n2 = 0;
        while (n2 < this.siz) {
            n = 0;
            while (n < this.siz) {
                if (this.px[n][n2]) {
                    this.rect(n * this.pxS, n2 * this.pxS, this.pxS, this.pxS);
                }
                ++n;
            }
            ++n2;
        }
        this.fill(0.0f, 255.0f, 0.0f, 160.0f);
        n2 = 0;
        while (n2 < this.siz) {
            n = 0;
            while (n < this.siz) {
                ++n;
            }
            ++n2;
        }
        this.fill(255.0f, 0.0f, 0.0f);
        this.rect(this.player.x * this.pxS + 1, this.player.y * this.pxS + 1, this.pxS - 2, this.pxS - 2);
    }

    public void drawCorridor(int n, int n2) {
        this.px[n][n2] = true;
        while (!this.deadEnd(n, n2)) {
            int n3 = 0;
            int n4 = 0;
            while (!(n3 == 0 ^ n4 == 0)) {
                n3 = maze.floor(this.random(-1.0f, 2.0f));
                n4 = maze.floor(this.random(-1.0f, 2.0f));
            }
            if (!this.freeCorridor(n + n3, n2 + n4)) continue;
            this.drawCorridor(n + n3, n2 + n4);
        }
    }

    public boolean freeCorridor(int n, int n2) {
        if (this.px[n][n2]) {
            return false;
        }
        int n3 = 0;
        int n4 = -1;
        while (n4 < 2) {
            int n5 = -1;
            while (n5 < 2) {
                if (n + n5 < 0 || n2 + n4 < 0 || n + n5 >= this.siz || n2 + n4 >= this.siz) {
                    return false;
                }
                if (this.px[n + n5][n2 + n4]) {
                    if (n5 != 0 && n4 != 0) {
                        if (!this.px[n][n2 + n4] && !this.px[n + n5][n2]) {
                            return false;
                        }
                    } else {
                        ++n3;
                    }
                }
                ++n5;
            }
            ++n4;
        }
        return n3 <= 1 && n3 != 0;
    }

    public boolean deadEnd(int n, int n2) {
        int n3 = -1;
        while (n3 < 2) {
            int n4 = -1;
            while (n4 < 2) {
                if (n4 == 0 ^ n3 == 0 && this.freeCorridor(n + n4, n2 + n3)) {
                    return false;
                }
                ++n4;
            }
            ++n3;
        }
        return true;
    }

    public PVector findWayOutOf(int n, int n2, int n3, int n4) {
        PVector pVector = null;
        if (maze.abs(n - this.player.x) < 20 && maze.abs(n2 - this.player.y) < 20) {
            this.toReach[n][n2] = true;
            int n5 = -1;
            while (n5 < 2) {
                int n6 = -1;
                while (n6 < 2) {
                    PVector pVector2;
                    if (n6 == 0 ^ n5 == 0 && (n6 != n3 || n5 != n4) && this.px[n + n6][n2 + n5] && (pVector2 = this.findWayOutOf(n + n6, n2 + n5, -n6, -n5)) != null) {
                        pVector = pVector2;
                    }
                    ++n6;
                }
                ++n5;
            }
        } else {
            return new PVector(n, n2);
        }
        return pVector;
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"--bgcolor=#c0c0c0", "maze"});
    }

    class Player {
        int x;
        int y;

        Player(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public void move(int n, int n2) {
            if (maze.this.px[this.x + n][this.y + n2]) {
                int n3;
                this.x += n;
                this.y += n2;
                int n4 = 0;
                while (n4 < maze.this.siz) {
                    n3 = 0;
                    while (n3 < maze.this.siz) {
                        maze.this.toReach[n3][n4] = false;
                        ++n3;
                    }
                    ++n4;
                }
                PVector pVector = maze.this.findWayOutOf(this.x, this.y, 0, 0);
                n3 = 0;
                while (n3 < maze.this.siz) {
                    int n5 = 0;
                    while (n5 < maze.this.siz) {
                        maze.this.px[n5][n3] = maze.this.toReach[n5][n3];
                        ++n5;
                    }
                    ++n3;
                }
                if (pVector != null) {
                    maze.this.drawCorridor((int)pVector.x, (int)pVector.y);
                }
            }
        }
    }
}

