/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class Animation {
    int nbImages;
    Image[] images;
    int id;
    int[][][] conditions;
    boolean[][] blocked;
    int[][] result;

    public int getNbImages() {
        return this.nbImages;
    }

    public Animation(String ref, int scale, int id, int[][][] conditions, boolean[][] blocked, int[][] result) {
        this.conditions = conditions;
        this.blocked = blocked;
        this.result = result;
        this.id = id;
        this.nbImages = 0;
        while (this.getClass().getClassLoader().getResource(String.valueOf(ref) + "_" + this.nbImages + ".png") != null) {
            ++this.nbImages;
        }
        this.images = new Image[this.nbImages];
        try {
            int i = 0;
            while (i < this.nbImages) {
                URL url = this.getClass().getClassLoader().getResource(String.valueOf(ref) + "_" + i + ".png");
                BufferedImage sourceImage = ImageIO.read(url);
                GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                this.images[i] = gc.createCompatibleImage(sourceImage.getWidth() * scale, sourceImage.getHeight() * scale, 2);
                this.images[i].getGraphics().drawImage(sourceImage.getScaledInstance(sourceImage.getWidth() * scale, sourceImage.getHeight() * scale, scale), 0, 0, null);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getConditionX() {
        return this.conditions.length;
    }

    public int getConditionY() {
        return this.conditions[0].length;
    }

    public int getResultX() {
        return this.result.length;
    }

    public int getResultY() {
        return this.result[0].length;
    }

    public int getBlockedX() {
        return this.blocked.length;
    }

    public int getBlockedY() {
        return this.blocked[0].length;
    }

    public int getResultOf(int x, int y) {
        return this.result[x][y];
    }

    public boolean fitsConditions(int[][] consider) {
        boolean fits = true;
        int x = 0;
        while (x < this.conditions.length) {
            int y = 0;
            while (y < this.conditions[x].length) {
                boolean fits2 = false;
                int i = 0;
                while (i < this.conditions[x][y].length) {
                    if (this.conditions[x][y][i] == consider[x][y] || this.conditions[x][y][i] == -1) {
                        fits2 = true;
                    }
                    ++i;
                }
                boolean bl = fits = fits && fits2;
                if (!fits) {
                    return false;
                }
                ++y;
            }
            ++x;
        }
        return true;
    }

    public boolean getBlocked(int x, int y) {
        return this.blocked[x][y];
    }

    public Image getImage(int frame) {
        return this.images[frame];
    }
}

