/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class AnimationSystem {
    Vector<Animation> animations = new Vector();
    int scale;
    int tileSize;
    Vector<PlayingAnimation> pAnimations = new Vector();
    boolean[][] blocked;
    int[][] tiles;

    public boolean[][] getBlocked() {
        return this.blocked;
    }

    public int[][] getTiles() {
        return this.tiles;
    }

    AnimationSystem(int scale, int tileSize) {
        this.scale = scale;
        this.tileSize = tileSize;
        this.loadSettingsFromFile();
    }

    private void loadSettingsFromFile() {
        String settings = "";
        InputStream stream = Game.class.getResourceAsStream("animations/anims.txt");
        try {
            int loaded = stream.read();
            while (loaded != -1) {
                settings = String.valueOf(settings) + (char)loaded;
                loaded = stream.read();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] settingsList = this.makeAnArray(settings);
        settingsList = this.removeComments(settingsList);
        this.createAnimationsFrom(settingsList);
    }

    private void createAnimationsFrom(String[] list) {
        int nbIds = 0;
        int i = 0;
        while (i < list.length) {
            String ref = "animations/" + list[i++];
            int i2 = ++i;
            while (!list[i2].equals("")) {
                ++i2;
            }
            int[][][] conditions = this.processConditions(list, i, i2);
            i2 = i = i2 + 1;
            while (!list[i2].equals("")) {
                ++i2;
            }
            boolean[][] blocked = this.processBlocked(list, i, i2);
            i2 = i = i2 + 1;
            while (!list[i2].equals("")) {
                ++i2;
            }
            int[][] result = this.processResult(list, i, i2);
            i = i2;
            this.animations.add(new Animation(ref, this.scale, nbIds, conditions, blocked, result));
            ++nbIds;
            ++i;
        }
    }

    private int[][] processResult(String[] list, int i, int i2) {
        int yLength = i2 - i;
        int xLength = 0;
        int i3 = i;
        while (i3 < i2) {
            int nbTilesInThisLine = 0;
            int i4 = 0;
            while (i4 < list[i3].length()) {
                if (list[i3].charAt(i4) == ';') {
                    ++nbTilesInThisLine;
                }
                ++i4;
            }
            xLength = Math.max(nbTilesInThisLine, xLength);
            ++i3;
        }
        int[][] result = new int[xLength][yLength];
        int i32 = i;
        while (i32 < i2) {
            int currentX = 0;
            int previousIndex = 0;
            int i4 = 0;
            while (i4 < list[i32].length()) {
                if (list[i32].charAt(i4) == ';') {
                    result[currentX][i32 - i] = list[i32].substring(previousIndex, i4).equalsIgnoreCase("s") ? -1 : Integer.parseInt(list[i32].substring(previousIndex, i4));
                    previousIndex = i4 + 1;
                    ++currentX;
                }
                ++i4;
            }
            ++i32;
        }
        return result;
    }

    private boolean[][] processBlocked(String[] list, int i, int i2) {
        int yLength = i2 - i;
        int xLength = 0;
        int i3 = i;
        while (i3 < i2) {
            int nbTilesInThisLine = 0;
            int i4 = 0;
            while (i4 < list[i3].length()) {
                if (list[i3].charAt(i4) == ';') {
                    ++nbTilesInThisLine;
                }
                ++i4;
            }
            xLength = Math.max(nbTilesInThisLine, xLength);
            ++i3;
        }
        boolean[][] blocked = new boolean[xLength][yLength];
        int i32 = i;
        while (i32 < i2) {
            int currentX = 0;
            int previousIndex = 0;
            int i4 = 0;
            while (i4 < list[i32].length()) {
                if (list[i32].charAt(i4) == ';') {
                    blocked[currentX][i32 - i] = list[i32].substring(previousIndex, i4).equalsIgnoreCase("y");
                    previousIndex = i4 + 1;
                    ++currentX;
                }
                ++i4;
            }
            ++i32;
        }
        return blocked;
    }

    private int[][][] processConditions(String[] list, int i, int i2) {
        int yLength = i2 - i;
        int xLength = 0;
        int i3 = i;
        while (i3 < i2) {
            int nbTilesInThisLine = 0;
            int i4 = 0;
            while (i4 < list[i3].length()) {
                if (list[i3].charAt(i4) == ';') {
                    ++nbTilesInThisLine;
                }
                ++i4;
            }
            xLength = Math.max(nbTilesInThisLine, xLength);
            ++i3;
        }
        int[][][] conditions = new int[xLength][yLength][];
        int i32 = i;
        while (i32 < i2) {
            int currentX = 0;
            Vector<Integer> possibilities = new Vector<Integer>(0);
            int previousIndex = 0;
            int i4 = 0;
            while (i4 < list[i32].length()) {
                if (list[i32].charAt(i4) == ';') {
                    if (list[i32].substring(previousIndex, i4).equalsIgnoreCase("a")) {
                        possibilities.add(-1);
                    } else {
                        possibilities.add(Integer.parseInt(list[i32].substring(previousIndex, i4)));
                    }
                    previousIndex = i4 + 1;
                    conditions[currentX][i32 - i] = new int[possibilities.size()];
                    int i5 = 0;
                    while (i5 < conditions[currentX][i32 - i].length) {
                        conditions[currentX][i32 - i][i5] = (Integer)possibilities.get(i5);
                        ++i5;
                    }
                    ++currentX;
                    possibilities = new Vector(0);
                } else if (list[i32].charAt(i4) == ',') {
                    possibilities.add(Integer.parseInt(list[i32].substring(previousIndex, i4)));
                    previousIndex = i4 + 1;
                }
                ++i4;
            }
            ++i32;
        }
        return conditions;
    }

    private String[] removeComments(String[] settingsList) {
        int i = 0;
        while (i < settingsList.length) {
            int i2 = 0;
            while (i2 < settingsList[i].length()) {
                if (settingsList[i].charAt(i2) == '/') {
                    settingsList[i] = settingsList[i].substring(0, i2);
                }
                ++i2;
            }
            ++i;
        }
        return settingsList;
    }

    private String[] makeAnArray(String string) {
        Vector<String> list = new Vector<String>();
        int previousIndex = 0;
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == '\n') {
                list.add(string.substring(previousIndex, i - 1));
                previousIndex = i + 1;
            }
            ++i;
        }
        String[] settingsList = new String[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            settingsList[i2] = (String)list.get(i2);
            ++i2;
        }
        return settingsList;
    }

    public void checkForNew(int[][] tiles, boolean[][] blocked, Point pSelected, Point pSelected2) {
        this.tiles = tiles;
        this.blocked = blocked;
        int x = 0;
        while (x < tiles.length) {
            int y = 0;
            while (y < tiles[x].length) {
                int i = this.animations.size() - 1;
                while (i >= 0) {
                    int nbTilesX = this.animations.get(i).getConditionX();
                    int nbTilesY = this.animations.get(i).getConditionY();
                    if (x + nbTilesX <= tiles.length && y + nbTilesY <= tiles[0].length) {
                        int[][] consider = new int[nbTilesX][nbTilesY];
                        int x2 = 0;
                        while (x2 < nbTilesX) {
                            int y2 = 0;
                            while (y2 < nbTilesY) {
                                consider[x2][y2] = tiles[x2 + x][y2 + y];
                                ++y2;
                            }
                            ++x2;
                        }
                        if (this.animations.get(i).fitsConditions(consider) && (pSelected.getX() < (double)x || pSelected.getX() >= (double)(x + nbTilesX) || pSelected.getY() < (double)y || pSelected.getY() >= (double)(y + nbTilesY)) && (pSelected2.getX() < (double)x || pSelected2.getX() >= (double)(x + nbTilesX) || pSelected2.getY() < (double)y || pSelected2.getY() >= (double)(y + nbTilesY))) {
                            int y2;
                            boolean alreadyBlocked = false;
                            int x22 = x;
                            while (x22 < x + nbTilesX) {
                                y2 = y;
                                while (y2 < y + nbTilesY) {
                                    if (blocked[x22][y2]) {
                                        alreadyBlocked = true;
                                    }
                                    ++y2;
                                }
                                ++x22;
                            }
                            if (!alreadyBlocked) {
                                this.pAnimations.add(new PlayingAnimation(i, 0, x, y));
                                x22 = x;
                                while (x22 < x + nbTilesX) {
                                    y2 = y;
                                    while (y2 < y + nbTilesY) {
                                        if (this.animations.get(i).getBlocked(x22 - x, y2 - y)) {
                                            blocked[x22][y2] = true;
                                        }
                                        ++y2;
                                    }
                                    ++x22;
                                }
                                i = -1;
                            }
                        }
                    }
                    --i;
                }
                ++y;
            }
            ++x;
        }
    }

    public void requestNextFrames() {
        int i = 0;
        while (i < this.pAnimations.size()) {
            this.pAnimations.get(i).nextFrame();
            if (this.pAnimations.get(i).getFrame() >= this.animations.get(this.pAnimations.get(i).getId()).getNbImages()) {
                int y;
                int x = 0;
                while (x < this.animations.get(this.pAnimations.get(i).getId()).getResultX()) {
                    y = 0;
                    while (y < this.animations.get(this.pAnimations.get(i).getId()).getResultY()) {
                        if (this.animations.get(this.pAnimations.get(i).getId()).getResultOf(x, y) != -1) {
                            this.tiles[x + this.pAnimations.get((int)i).getX()][y + this.pAnimations.get((int)i).getY()] = this.animations.get(this.pAnimations.get(i).getId()).getResultOf(x, y);
                        }
                        ++y;
                    }
                    ++x;
                }
                x = 0;
                while (x < this.animations.get(this.pAnimations.get(i).getId()).getBlockedX()) {
                    y = 0;
                    while (y < this.animations.get(this.pAnimations.get(i).getId()).getBlockedY()) {
                        if (this.animations.get(this.pAnimations.get(i).getId()).getBlocked(x, y)) {
                            this.blocked[x + this.pAnimations.get((int)i).getX()][y + this.pAnimations.get((int)i).getY()] = false;
                        }
                        ++y;
                    }
                    ++x;
                }
                this.pAnimations.remove(i);
            }
            ++i;
        }
    }

    public void displayAnimations(Graphics2D g) {
        int i = 0;
        while (i < this.pAnimations.size()) {
            PlayingAnimation anim = this.pAnimations.get(i);
            g.drawImage(this.animations.get(anim.getId()).getImage(anim.getFrame()), anim.getX() * this.tileSize * this.scale, anim.getY() * this.tileSize * this.scale, null);
            ++i;
        }
    }
}

