/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Game
extends Canvas {
    private static final long serialVersionUID = 1L;
    boolean gameRunning = true;
    private BufferStrategy strategy;
    private boolean[] keysPressed = new boolean[1024];
    private Graphics2D g;
    private int tileSize = 16;
    private int nbTilesX = 4;
    private int nbTilesY = 4;
    private int[][] tiles = new int[this.nbTilesX][this.nbTilesY];
    private boolean[][] blocked = new boolean[this.nbTilesX][this.nbTilesY];
    Tileset tileset = new Tileset();
    int scale = 3;
    int width = this.tileSize * this.nbTilesX * this.scale;
    int height = this.tileSize * this.nbTilesY * this.scale;
    Point selectedTile = new Point(0, 0);
    boolean moveDone = false;
    private int frameRate = 8;
    private boolean oneTileSelected = false;
    private Vector<Tile> uTiles = new Vector();
    private boolean enterPressed = false;
    private Point tileToSwitchWith = new Point(0, 0);
    JModFilePlayer player = new JModFilePlayer();
    private AnimationSystem animationSystem = new AnimationSystem(this.scale, this.tileSize);

    public Game() {
        JFrame container = new JFrame("Then, things started to disappear");
        JPanel panel = (JPanel)container.getContentPane();
        panel.setPreferredSize(new Dimension(this.width, this.height));
        panel.setLayout(null);
        this.setBounds(0, 0, this.width, this.height);
        panel.add(this);
        this.setIgnoreRepaint(true);
        container.pack();
        container.setResizable(false);
        container.setVisible(true);
        container.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.addKeyListener(new KeyInputHandler());
        this.requestFocus();
        this.createBufferStrategy(2);
        this.strategy = this.getBufferStrategy();
        this.tileset.loadTiles(this.scale);
        this.loadTilesMap();
        this.loadUTiles();
        InputStream stream = Game.class.getResourceAsStream("data/1.xm");
        this.player.play(stream, "data/1.xm");
        this.player.start();
    }

    public void mainGameLoop() {
        long lastTime = System.currentTimeMillis();
        while (this.gameRunning) {
            this.g = (Graphics2D)this.strategy.getDrawGraphics();
            this.keyboard();
            this.clearScreen();
            this.displayTiles();
            this.specialAnimations();
            this.displaySelected();
            this.g.dispose();
            this.strategy.show();
            if (System.currentTimeMillis() - lastTime < (long)(1000 / this.frameRate)) continue;
            this.requestNextFrames();
            lastTime = System.currentTimeMillis();
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void specialAnimations() {
        if (this.oneTileSelected) {
            this.animationSystem.checkForNew(this.tiles, this.blocked, this.tileToSwitchWith, this.selectedTile);
        } else {
            this.animationSystem.checkForNew(this.tiles, this.blocked, new Point(-1, -1), new Point(-1, -1));
        }
        this.blocked = this.animationSystem.getBlocked();
        this.tiles = this.animationSystem.getTiles();
        this.animationSystem.displayAnimations(this.g);
    }

    private void requestNextFrames() {
        this.tileset.requestNextFrames();
        this.animationSystem.requestNextFrames();
        this.blocked = this.animationSystem.getBlocked();
        this.tiles = this.animationSystem.getTiles();
        int i = 0;
        while (i < this.uTiles.size()) {
            this.uTiles.get(i).nextFrame();
            ++i;
        }
    }

    private void loadUTiles() {
        this.uTiles.add(new Tile("tiles/selec_0", this.scale, 0));
        this.uTiles.add(new Tile("tiles/selec_1", this.scale, 1));
        this.uTiles.add(new Tile("tiles/selec_2", this.scale, 2));
    }

    private void loadTilesMap() {
        InputStream stream = Game.class.getResourceAsStream("data/1.map");
        try {
            int y = 0;
            while (y < this.nbTilesY) {
                int x = 0;
                while (x < this.nbTilesX) {
                    this.tiles[x][y] = stream.read();
                    this.blocked[x][y] = false;
                    ++x;
                }
                ++y;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void keyboard() {
        if (this.keysPressed[37] && !this.moveDone) {
            this.selectedTile.translate(-1, 0);
            this.moveDone = true;
        }
        if (this.keysPressed[38] && !this.moveDone) {
            this.selectedTile.translate(0, -1);
            this.moveDone = true;
        }
        if (this.keysPressed[39] && !this.moveDone) {
            this.selectedTile.translate(1, 0);
            this.moveDone = true;
        }
        if (this.keysPressed[40] && !this.moveDone) {
            this.selectedTile.translate(0, 1);
            this.moveDone = true;
        }
        if (!(this.keysPressed[37] || this.keysPressed[38] || this.keysPressed[39] || this.keysPressed[40])) {
            this.moveDone = false;
        }
        this.selectedTile.move((int)Math.min((double)(this.nbTilesX - 1), Math.max(0.0, this.selectedTile.getX())), (int)Math.min((double)(this.nbTilesY - 1), Math.max(0.0, this.selectedTile.getY())));
        if (this.keysPressed[10]) {
            if (!this.enterPressed) {
                this.enterPressed = true;
                if (this.oneTileSelected) {
                    if (!this.blocked[(int)this.selectedTile.getX()][(int)this.selectedTile.getY()] && !this.blocked[(int)this.tileToSwitchWith.getX()][(int)this.tileToSwitchWith.getY()]) {
                        int temp = this.tiles[(int)this.selectedTile.getX()][(int)this.selectedTile.getY()];
                        this.tiles[(int)this.selectedTile.getX()][(int)this.selectedTile.getY()] = this.tiles[(int)this.tileToSwitchWith.getX()][(int)this.tileToSwitchWith.getY()];
                        this.tiles[(int)this.tileToSwitchWith.getX()][(int)this.tileToSwitchWith.getY()] = temp;
                        this.oneTileSelected = false;
                    }
                } else {
                    this.tileToSwitchWith.move((int)this.selectedTile.getX(), (int)this.selectedTile.getY());
                    this.oneTileSelected = true;
                }
            }
        } else {
            this.enterPressed = false;
        }
    }

    private void displaySelected() {
        int x = (int)(this.selectedTile.getX() * (double)this.tileSize * (double)this.scale);
        int y = (int)(this.selectedTile.getY() * (double)this.tileSize * (double)this.scale);
        if (!this.oneTileSelected) {
            this.g.drawImage(this.uTiles.get(0).getCurrentImage(), x, y, null);
        } else {
            int x2 = (int)(this.tileToSwitchWith.getX() * (double)this.tileSize * (double)this.scale);
            int y2 = (int)(this.tileToSwitchWith.getY() * (double)this.tileSize * (double)this.scale);
            this.g.drawImage(this.uTiles.get(2).getCurrentImage(), x2, y2, null);
            this.g.drawImage(this.uTiles.get(1).getCurrentImage(), x, y, null);
        }
    }

    private void displayTiles() {
        int x = 0;
        while (x < this.nbTilesX) {
            int y = 0;
            while (y < this.nbTilesY) {
                if (!this.blocked[x][y]) {
                    this.g.drawImage(this.tileset.getCurrentImage(this.tiles[x][y]), x * this.tileSize * this.scale, y * this.tileSize * this.scale, null);
                }
                ++y;
            }
            ++x;
        }
    }

    public static void main(String[] argv) {
        Game g = new Game();
        g.mainGameLoop();
    }

    private void clearScreen() {
        this.g.setColor(Color.black);
        this.g.fillRect(0, 0, this.width, this.height);
    }

    public int selectedTileID() {
        return this.tiles[(int)this.selectedTile.getX()][(int)this.selectedTile.getY()];
    }

    private class KeyInputHandler
    extends KeyAdapter {
        private KeyInputHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            ((Game)Game.this).keysPressed[e.getKeyCode()] = true;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            ((Game)Game.this).keysPressed[e.getKeyCode()] = false;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\u001b') {
                System.exit(0);
            }
        }
    }
}

