/*
 * Decompiled with CFR 0.152.
 */
import com.vwp.sound.mod.modplay.Player;
import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.player.PlayerException;
import com.vwp.sound.mod.sound.output.JavaSoundOutput;
import com.vwp.sound.mod.sound.output.SoundDataFormat;
import java.io.InputStream;

public class JModFilePlayer {
    public static final int BITS = 16;
    public static final int RATE = 44100;
    public static final int CHANNELS = 2;
    public static final boolean INTERPOLATE = true;
    public static final int BUFFERSIZE = 500;
    private Module module;
    private PlayerThread pt;

    public void play(InputStream stream, String name) {
        try {
            this.module = ModuleLoader.getModuleLoader(stream, name).getModule();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pt = this.createPlayerThread(this.module);
        this.pt.start();
    }

    private PlayerThread createPlayerThread(Module module) {
        Player player = new Player();
        try {
            player.init(new JavaSoundOutput(new SoundDataFormat(16, 44100, 2), 500), true);
            player.load(module);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PlayerThread playerthread = new PlayerThread(player);
        playerthread.setPause(true);
        return playerthread;
    }

    public void start() {
        this.pt.setPause(false);
    }

    public void stop() {
        this.pt.setPause(true);
    }

    public void destroy() {
        this.pt.quit();
    }

    public void switchPause() {
        if (this.pt.getPause()) {
            this.pt.setPause(false);
        } else {
            this.pt.setPause(true);
        }
    }

    private static class PlayerThread
    extends Thread {
        private Player player;
        private boolean run = true;
        private boolean pause = false;

        public boolean isRun() {
            return this.run;
        }

        public void setRun(boolean run) {
            this.run = run;
        }

        public void setPause(boolean pause) {
            this.pause = pause;
        }

        public boolean getPause() {
            return this.pause;
        }

        public PlayerThread(Player player) {
            this.player = player;
        }

        @Override
        public void run() {
            while (this.run) {
                if (!this.pause) {
                    try {
                        if (this.player.play()) continue;
                        this.player.setPosition(0);
                    }
                    catch (PlayerException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            System.out.println(this.run);
            this.run = false;
            this.player.close();
        }

        public void quit() {
            this.run = false;
        }
    }
}

