/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class Tile {
    Image[] images;
    int id;
    int currentImage = 0;
    int nbImages;

    public Tile(String ref, int scale, int id) {
        this.id = id;
        this.nbImages = 0;
        while (this.getClass().getClassLoader().getResource(String.valueOf(ref) + "_" + this.nbImages + ".png") != null) {
            ++this.nbImages;
        }
        this.images = new Image[this.nbImages];
        try {
            int i = 0;
            while (i < this.nbImages) {
                URL url = this.getClass().getClassLoader().getResource(String.valueOf(ref) + "_" + i + ".png");
                BufferedImage sourceImage = ImageIO.read(url);
                GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                this.images[i] = gc.createCompatibleImage(sourceImage.getWidth() * scale, sourceImage.getHeight() * scale, 2);
                this.images[i].getGraphics().drawImage(sourceImage.getScaledInstance(sourceImage.getWidth() * scale, sourceImage.getHeight() * scale, scale), 0, 0, null);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Image[] getImages() {
        return this.images;
    }

    public Image getImage(int i) {
        return this.images[i];
    }

    public Image getCurrentImage() {
        return this.images[this.currentImage];
    }

    public int getId() {
        return this.id;
    }

    public void nextFrame() {
        this.currentImage = (this.currentImage + 1) % this.nbImages;
    }
}

