/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class PlayList
implements Iterator {
    private Vector list;
    private int position;
    private String playListName = "no-name";

    public PlayList(String string) throws IOException {
        this.playListName = string;
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
        this.loadList(lineNumberReader);
    }

    public PlayList(String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("\n");
        }
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(stringBuffer.toString()));
        this.loadList(lineNumberReader);
    }

    private void loadList(LineNumberReader lineNumberReader) throws IOException {
        this.position = -1;
        this.list = new Vector();
        String string = null;
        while ((string = lineNumberReader.readLine()) != null) {
            File file = new File(string = string.trim());
            if (!file.exists() || !file.isFile()) continue;
            this.list.add(string);
        }
    }

    public String getPlayListName() {
        return this.playListName;
    }

    @Override
    public boolean hasNext() {
        return this.position + 1 < this.list.size();
    }

    public Object next() {
        if (this.hasNext()) {
            return this.list.elementAt(++this.position);
        }
        throw new NoSuchElementException();
    }

    public String nextFileName() {
        return (String)this.next();
    }

    @Override
    public void remove() {
        this.list.removeElementAt(this.position);
    }

    public int getNumberOfFileNames() {
        return this.list.size();
    }

    public String getRandomFileName() {
        int n = (int)(Math.random() * (double)this.list.size());
        this.position = n - 1;
        return this.nextFileName();
    }
}

