/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay;

import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.player.DefaultMixer;
import com.vwp.sound.mod.modplay.player.FastMixer;
import com.vwp.sound.mod.modplay.player.InterpolatingMixer;
import com.vwp.sound.mod.modplay.player.ModuleState;
import com.vwp.sound.mod.modplay.player.PlayerException;
import com.vwp.sound.mod.sound.output.Output;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class Player {
    private ModuleState ms;
    private Output out;
    private Class lowLevelMixerClass;

    public boolean init(Output output, boolean bl) {
        this.out = output;
        this.lowLevelMixerClass = bl ? InterpolatingMixer.class : FastMixer.class;
        return true;
    }

    public boolean load(String string) throws InvalidFormatException, IOException {
        ModuleLoader moduleLoader = ModuleLoader.getModuleLoader(new File(string));
        Module module = moduleLoader.getModule();
        return this.load(module);
    }

    public boolean load(InputStream inputStream, String string) throws InvalidFormatException, IOException {
        ModuleLoader moduleLoader = ModuleLoader.getModuleLoader(inputStream, string);
        Module module = moduleLoader.getModule();
        return this.load(module);
    }

    public boolean load(Module module) {
        Instrument[] instrumentArray = module.getInstruments();
        int n = module.getPatternAtPos(0).getTrackCount();
        DefaultMixer defaultMixer = new DefaultMixer(this.out, this.lowLevelMixerClass, n);
        this.ms = new ModuleState(module, defaultMixer);
        defaultMixer.setAmplification(this.getDefaultAmplification());
        return this.out.open();
    }

    public boolean play() throws PlayerException {
        return this.ms.play();
    }

    public boolean close() {
        return this.out.close();
    }

    public ModuleState getModuleState() {
        return this.ms;
    }

    public Module getModule() {
        return this.getModuleState().getModule();
    }

    public double getDefaultAmplification() {
        return (double)this.getModuleState().getModule().getPatternAtPos(0).getTrackCount() / 4.0;
    }

    public void setAmplification(double d) {
        this.getModuleState().getMixer().setAmplification(d);
    }

    public double getAmplification() {
        return this.getModuleState().getMixer().getAmplification();
    }

    public void mute(int n, boolean bl) {
        this.getModuleState().getMixer().setMute(n, bl);
    }

    public void mute(boolean[] blArray) {
        for (int i = 0; i < blArray.length && i < this.getModule().getTrackCount(); ++i) {
            this.mute(i, blArray[i]);
        }
    }

    public void setVolume(double d) {
        this.getModuleState().getMixer().setVolume(d);
    }

    public double getVolume() {
        return this.getModuleState().getMixer().getVolume();
    }

    public void setBalance(double d) {
        this.getModuleState().getMixer().setBalance(d);
    }

    public double getBalance() {
        return this.getModuleState().getMixer().getBalance();
    }

    public void setSeparation(double d) {
        this.getModuleState().getMixer().setSeparation(d);
    }

    public double getSeparation() {
        return this.getModuleState().getMixer().getSeparation();
    }

    public void setPosition(int n) {
        this.getModuleState().setPosition(n);
    }

    public int getPosition() {
        return this.getModuleState().getPosition();
    }

    public int getDivision() {
        return this.getModuleState().getDivision();
    }

    public int getTick() {
        return this.getModuleState().getTick();
    }

    public int getNote(int n) {
        return this.getModuleState().getModule().getPatternAtPos(this.getPosition()).getTrack(n).getNote(this.getDivision());
    }
}

