/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.loader.S3MUnits;
import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.module.Pattern;
import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.module.Track;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoEffect;
import com.vwp.sound.mod.util.io.RandomAccess;
import com.vwp.sound.mod.util.io.RandomAccessArray;
import java.io.IOException;
import java.util.ArrayList;

public class ITLoader
extends ModuleLoader {
    private Module module;

    public ITLoader(String string, byte[] byArray) throws IOException, InvalidFormatException {
        this.load(string, new RandomAccessArray(byArray));
    }

    private void load(String string, RandomAccess randomAccess) throws IOException, InvalidFormatException {
        int n;
        int n2;
        String string2 = randomAccess.readString(4);
        String string3 = randomAccess.readZeroPaddedString(26);
        randomAccess.skipBytes(2);
        int n3 = randomAccess.readUnsignedShort();
        int n4 = randomAccess.readUnsignedShort();
        int n5 = randomAccess.readUnsignedShort();
        int n6 = randomAccess.readUnsignedShort();
        short s = randomAccess.readShort();
        int n7 = (s & 0xFF00) >> 8;
        int n8 = s & 0xFF;
        String string4 = "ImpulseTracker " + n8 + "." + n7;
        short s2 = randomAccess.readShort();
        int n9 = (s2 & 0xFF00) >> 8;
        int n10 = s2 & 0xFF;
        String string5 = n10 + "." + n9;
        int n11 = randomAccess.readUnsignedShort();
        int n12 = randomAccess.readUnsignedShort();
        boolean bl = (n12 & 1) > 0;
        double d = (double)randomAccess.readUnsignedByte() / 128.0;
        double d2 = (double)randomAccess.readUnsignedByte() / 128.0;
        double d3 = d * d2;
        int n13 = randomAccess.readUnsignedByte();
        int n14 = randomAccess.readUnsignedByte();
        randomAccess.readUnsignedByte();
        randomAccess.readUnsignedByte();
        int n15 = randomAccess.readUnsignedShort();
        int n16 = randomAccess.readUnsignedInt();
        String string6 = bl ? this.readMessage(randomAccess, n16, n15) : null;
        randomAccess.skipBytes(4);
        double[] dArray = new double[64];
        for (int i = 0; i < dArray.length; ++i) {
            n2 = randomAccess.readUnsignedByte();
            if ((n2 & 0x80) > 0) {
                n2 &= 0xFFFFFF7F;
            } else if (n2 == 100) {
                n2 = 0;
            }
            dArray[i] = (double)(i - 32) / 32.0;
        }
        double[] dArray2 = new double[64];
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            dArray2[n2] = (double)randomAccess.readUnsignedByte() / 64.0;
        }
        int[] nArray = new int[n3];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = randomAccess.readUnsignedByte();
        }
        n = randomAccess.readUnsignedInt();
        int n17 = randomAccess.readUnsignedInt();
        int n18 = randomAccess.readUnsignedInt();
        randomAccess.seek(n17);
        Sample[] sampleArray = this.loadSamples(randomAccess, n5);
        randomAccess.seek(n);
        Instrument[] instrumentArray = this.loadInstruments(randomAccess, n4, sampleArray);
        randomAccess.seek(n18);
        Pattern[] patternArray = this.loadPatterns(randomAccess, n6);
        this.module = new Module(string3, string2, string4, instrumentArray, patternArray, nArray, 0, n14, n13, d3, 0, dArray2, dArray);
        this.module.setDescription(string6);
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    private String readMessage(RandomAccess randomAccess, int n, int n2) throws IOException {
        long l = randomAccess.getPosition();
        randomAccess.seek(n);
        String string = randomAccess.readZeroPaddedString(n2);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\r') continue;
            cArray[i] = 10;
        }
        randomAccess.seek(l);
        return new String(cArray);
    }

    private Sample[] loadSamples(RandomAccess randomAccess, int n) throws IOException, InvalidFormatException {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.loadSample(randomAccess));
        }
        return arrayList.toArray(new Sample[0]);
    }

    private Sample loadSample(RandomAccess randomAccess) throws IOException, InvalidFormatException {
        String string = randomAccess.readString(4);
        if (!string.equals("IMPS")) {
            throw new InvalidFormatException("Sample ID should be 'IMPS', was '" + string + "'");
        }
        randomAccess.readString(12);
        randomAccess.readUnsignedByte();
        randomAccess.readUnsignedByte();
        int n = randomAccess.readUnsignedByte();
        this.isEnabled(n, 0);
        boolean bl = this.isEnabled(n, 1);
        this.isEnabled(n, 2);
        this.isEnabled(n, 3);
        boolean bl2 = this.isEnabled(n, 4);
        this.isEnabled(n, 5);
        boolean bl3 = this.isEnabled(n, 6);
        this.isEnabled(n, 7);
        double d = (double)randomAccess.readUnsignedByte() / 64.0;
        String string2 = randomAccess.readZeroPaddedString(26);
        boolean bl4 = this.isEnabled(randomAccess.readUnsignedByte(), 0);
        int n2 = randomAccess.readUnsignedByte();
        this.isEnabled(n2, 7);
        double d2 = (double)this.clear(n2, 7) / 64.0;
        int n3 = randomAccess.readUnsignedInt();
        int n4 = randomAccess.readUnsignedInt();
        int n5 = randomAccess.readUnsignedInt();
        int n6 = randomAccess.readUnsignedByte();
        randomAccess.readUnsignedInt();
        randomAccess.readUnsignedInt();
        int n7 = randomAccess.readUnsignedInt();
        randomAccess.readUnsignedByte();
        randomAccess.readUnsignedByte();
        randomAccess.readUnsignedByte();
        randomAccess.readUnsignedByte();
        int n8 = bl2 ? (bl3 ? 2 : 1) : 0;
        Sample sample = new Sample(string, string2, d, d2, n3, n8, n4, n5, 0.0, 0.0, new S3MUnits(n6, false));
        long l = randomAccess.getPosition();
        randomAccess.seek(n7);
        sample.setData(this.loadSampleData(randomAccess, n3, bl4, bl));
        randomAccess.seek(l);
        return sample;
    }

    private short[] loadSampleData(RandomAccess randomAccess, int n, boolean bl, boolean bl2) {
        return new short[0];
    }

    private Instrument[] loadInstruments(RandomAccess randomAccess, int n, Sample[] sampleArray) {
        Instrument[] instrumentArray = new Instrument[n];
        for (int i = 0; i < instrumentArray.length; ++i) {
            instrumentArray[i] = new Instrument("", new int[0], sampleArray, new AutoEffect[0], 0.0);
        }
        return instrumentArray;
    }

    private Pattern[] loadPatterns(RandomAccess randomAccess, int n) {
        Track[] trackArray = new Track[64];
        for (int i = 0; i < trackArray.length; ++i) {
            trackArray[i] = new Track(1);
        }
        Pattern[] patternArray = new Pattern[n];
        for (int i = 0; i < patternArray.length; ++i) {
            patternArray[i] = new Pattern(trackArray, 1);
        }
        return patternArray;
    }

    private boolean isEnabled(int n, int n2) {
        return (n & 1 << n2) > 0;
    }

    private int clear(int n, int n2) {
        return n & ~(1 << n2);
    }
}

