/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.loader.ModUnits;
import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.module.ModuleUnits;
import com.vwp.sound.mod.modplay.module.Pattern;
import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.module.Track;
import com.vwp.sound.mod.util.Util;
import com.vwp.sound.mod.util.io.RandomAccess;
import com.vwp.sound.mod.util.io.RandomAccessArray;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class ModLoader
extends ModuleLoader {
    private static final int ID_OFFSET = 1080;
    private Module module;

    public ModLoader(String string, byte[] byArray) throws InvalidFormatException, IOException {
        this.module = this.load(string, byArray);
    }

    private Module load(String string, byte[] byArray) throws InvalidFormatException, IOException {
        RandomAccessArray randomAccessArray = new RandomAccessArray(byArray);
        String string2 = "";
        randomAccessArray.seek(1080L);
        String string3 = ModLoader.readID(randomAccessArray);
        IDInfo iDInfo = ModLoader.getIdInfo(string3);
        string2 = iDInfo.tracker;
        string3 = iDInfo.id;
        int n = iDInfo.trackCount;
        int n2 = iDInfo.instrumentCount;
        randomAccessArray.seek(0L);
        String string4 = ModLoader.readName(randomAccessArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        ModLoader.skip(dataInputStream, 20);
        Instrument[] instrumentArray = this.loadInstruments(dataInputStream, n2);
        int n3 = dataInputStream.readByte() & 0xFF;
        byte by = dataInputStream.readByte();
        randomAccessArray.seek(20 + n2 * 30 + 2);
        int[] nArray = ModLoader.loadPositions(n3, randomAccessArray);
        int n4 = ModLoader.getPatternCount(nArray);
        ModLoader.skip(dataInputStream, 128);
        if (!string3.equals("NOID")) {
            ModLoader.skip(dataInputStream, 4);
        }
        Pattern[] patternArray = this.loadPatterns(dataInputStream, n4, n, n2, new ModUnits(7093789.2, false));
        this.loadSampleData(dataInputStream, instrumentArray);
        double d = 0.0;
        double d2 = 1.0;
        double[] dArray = new double[]{d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2, d2, d, d, d2};
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i];
            dArray3[i] = 1.0;
        }
        return new Module(string4, string3, string2, instrumentArray, patternArray, nArray, by, 125, 6, 1.0, 1, dArray3, dArray2);
    }

    private void loadSampleData(DataInputStream dataInputStream, Instrument[] instrumentArray) throws IOException {
        for (int i = 0; i < instrumentArray.length; ++i) {
            Sample sample = instrumentArray[i].getSampleByNum(0);
            short[] sArray = new short[sample.getLength()];
            for (int j = 0; j < sArray.length; ++j) {
                sArray[j] = (short)((dataInputStream.readByte() & 0xFF) << 8);
            }
            sample.setData(sArray);
        }
    }

    private Instrument[] loadInstruments(DataInputStream dataInputStream, int n) throws IOException {
        Instrument[] instrumentArray = new Instrument[n];
        Sample[] sampleArray = new Sample[n];
        ModUnits modUnits = new ModUnits(7093789.2, false);
        for (int i = 0; i < n; ++i) {
            String string = Util.readZeroPaddedString(dataInputStream, 22);
            int n2 = 2 * (dataInputStream.readShort() & 0xFFFF);
            int n3 = dataInputStream.readByte();
            if (n3 > 7) {
                n3 |= 0xFFFFFFF0;
            }
            double d = (double)n3 / 8.0;
            double d2 = (double)dataInputStream.readByte() / 64.0;
            int n4 = 2 * (dataInputStream.readShort() & 0xFFFF);
            int n5 = 2 * (dataInputStream.readShort() & 0xFFFF);
            int n6 = n5 > 2 ? 1 : 0;
            sampleArray[i] = new Sample("sample-" + i, string, d2, 0.0, n2, n6, n4, n5, 0.0, d, modUnits);
        }
        int[] nArray = new int[60];
        for (int i = 0; i < n; ++i) {
            instrumentArray[i] = new Instrument(sampleArray[i].getName(), nArray, new Sample[]{sampleArray[i]}, null, 0.0);
        }
        return instrumentArray;
    }

    private Pattern[] loadPatterns(DataInputStream dataInputStream, int n, int n2, int n3, ModuleUnits moduleUnits) throws InvalidFormatException, IOException {
        Pattern[] patternArray = new Pattern[n];
        for (int i = 0; i < n; ++i) {
            int n4;
            Track[] trackArray = new Track[n2];
            for (n4 = 0; n4 < n2; ++n4) {
                trackArray[n4] = new Track(64);
            }
            for (n4 = 0; n4 < 64; ++n4) {
                for (int j = 0; j < n2; ++j) {
                    int n5 = dataInputStream.readInt();
                    int n6 = (n5 & 0xF00) >> 8;
                    int n7 = (n5 & 0xF0) >>> 4;
                    int n8 = n5 & 0xF;
                    int n9 = (n5 & 0xFFF0000) >> 16;
                    n6 = ModLoader.translateEffectNum(n6, n7);
                    if ((double)n9 > 1712.0) {
                        n9 = 1712;
                    } else if (n9 > 0 && (double)n9 < 57.0) {
                        n9 = 57;
                    }
                    int n10 = n9 != 0 ? (int)Math.round(moduleUnits.period2note(n9)) : -2;
                    int n11 = (n5 & 0xF0000000) >>> 24 | (n5 & 0xF000) >> 12;
                    if (--n11 >= n3 || n11 < 0) {
                        n11 = -1;
                    }
                    trackArray[j].initDivision(n4, n11, n10, new int[]{n6}, new int[]{n7}, new int[]{n8});
                }
            }
            patternArray[i] = new Pattern(trackArray, 64);
        }
        return patternArray;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    public static int translateEffectNum(int n, int n2) throws InvalidFormatException {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                switch (n2) {
                    case 0: {
                        return 16;
                    }
                    case 1: {
                        return 17;
                    }
                    case 2: {
                        return 18;
                    }
                    case 3: {
                        return 19;
                    }
                    case 4: {
                        return 20;
                    }
                    case 5: {
                        return 21;
                    }
                    case 6: {
                        return 22;
                    }
                    case 7: {
                        return 23;
                    }
                    case 8: {
                        return 24;
                    }
                    case 9: {
                        return 25;
                    }
                    case 10: {
                        return 26;
                    }
                    case 11: {
                        return 27;
                    }
                    case 12: {
                        return 28;
                    }
                    case 13: {
                        return 29;
                    }
                    case 14: {
                        return 30;
                    }
                    case 15: {
                        return 31;
                    }
                }
                break;
            }
            case 15: {
                return 15;
            }
        }
        throw new InvalidFormatException("Illegal effect number: " + n + ":" + n2);
    }

    public static IDInfo getIdInfo(String string) {
        return IDInfo.getIDInfo(string);
    }

    public static String readID(RandomAccess randomAccess) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n++ < 4) {
            stringBuffer.append((char)randomAccess.read());
        }
        return stringBuffer.toString();
    }

    public static String readName(RandomAccess randomAccess) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = -1;
        while (n++ < 20 && (n2 = randomAccess.read()) != 0) {
            stringBuffer.append((char)n2);
        }
        randomAccess.skipBytes(20 - n);
        return stringBuffer.toString();
    }

    public static int[] loadPositions(int n, RandomAccess randomAccess) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = randomAccess.readByte() & 0xFF;
        }
        return nArray;
    }

    public static int getPatternCount(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (n >= nArray[i]) continue;
            n = nArray[i];
        }
        return ++n;
    }

    public static class IDInfo {
        public static final String PROTRACKER = "ProTracker";
        public static final String FASTTRACKER_2 = "FastTracker 2";
        public static final String NOISETRACKER = "NoiseTracker";
        public static final String STARTREKKER = "StarTrekker";
        public static final String UNKNOWN_TRACKER = "Unknown";
        public static final String SOUNDTRACKER = "SoundTracker";
        public static final String TAKETRACKER = "TakeTracker";
        public static final String OCTALYZER = "Octalyzer";
        public static final String OKTALYZER = "Oktalyzer";
        public static final String ID_MK = "M.K.";
        public static final String ID_MK_EXT = "M!K!";
        public static final String ID_NT = "N.T.";
        public static final String ID_FLT4 = "FLT4";
        public static final String ID_FLT8 = "FLT8";
        public static final String ID_2CHN = "2CHN";
        public static final String ID_4CHN = "4CHN";
        public static final String ID_6CHN = "6CHN";
        public static final String ID_8CHN = "8CHN";
        public static final String ID_OKTA = "OKTA";
        public static final String ID_CD81 = "CD81";
        public static final String ID_OCTA = "OCTA";
        public static final String ID_POSTFIX_CH = "CH";
        public static final String ID_PREFIX_TDZ = "TDZ";
        public static final String ID_NONE = "NOID";
        public String tracker;
        public String id;
        public int trackCount;
        public int instrumentCount;

        public static IDInfo getIDInfo(String string) {
            String string2 = null;
            int n = -1;
            int n2 = -1;
            if (string.equals(ID_2CHN)) {
                string2 = FASTTRACKER_2;
                n = 2;
                n2 = 31;
            } else if (string.equals(ID_MK) || string.equals(ID_MK_EXT)) {
                string2 = PROTRACKER;
                n = 4;
                n2 = 31;
            } else if (string.equals(ID_NT)) {
                string2 = NOISETRACKER;
                n = 4;
                n2 = 31;
            } else if (string.equals(ID_FLT4)) {
                string2 = STARTREKKER;
                n = 4;
                n2 = 31;
            } else if (string.equals(ID_4CHN)) {
                string2 = UNKNOWN_TRACKER;
                n = 4;
                n2 = 31;
            } else if (string.equals(ID_6CHN)) {
                string2 = FASTTRACKER_2;
                n = 6;
                n2 = 31;
            } else if (string.equals(ID_8CHN)) {
                string2 = FASTTRACKER_2;
                n = 8;
                n2 = 31;
            } else if (string.equals(ID_FLT8)) {
                string2 = STARTREKKER;
                n = 8;
                n2 = 31;
            } else if (string.equals(ID_OKTA) || string.equals(ID_CD81)) {
                string2 = OKTALYZER;
                n = 8;
                n2 = 31;
            } else if (string.equals(ID_OCTA)) {
                string2 = OCTALYZER;
                n = 8;
                n2 = 31;
            } else if (string.endsWith(ID_POSTFIX_CH)) {
                n = (short)Integer.parseInt(string.substring(0, 2));
                string2 = (n & 1) == 0 ? FASTTRACKER_2 : TAKETRACKER;
                n2 = 31;
            } else if (string.startsWith(ID_PREFIX_TDZ)) {
                string2 = TAKETRACKER;
                n = (short)Integer.parseInt(string.substring(3, 1));
                n2 = 31;
            } else {
                string = ID_NONE;
                string2 = SOUNDTRACKER;
                n = 4;
                n2 = 15;
            }
            IDInfo iDInfo = new IDInfo();
            iDInfo.trackCount = n;
            iDInfo.instrumentCount = n2;
            iDInfo.tracker = string2;
            iDInfo.id = string;
            return iDInfo;
        }
    }
}

