/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.module.ModuleUnits;

public class ModUnits
implements ModuleUnits {
    public static final String NAME = "mod";
    private static double maxNote;
    private static double minNote;
    private static double minPeriod;
    private static double maxPeriod;
    private static double ac;
    public static final double TRADITIONAL_MAX_PERIOD = 856.0;
    public static final double TRADITIONAL_MIN_PERIOD = 113.0;
    public static final double NEW_MAX_PERIOD = 1712.0;
    public static final double NEW_MIN_PERIOD = 57.0;
    public static final double PAL = 7093789.2;
    public static final double NTSC = 7159090.5;

    public ModUnits(double d, boolean bl) {
        ac = d;
        if (bl) {
            minPeriod = 113.0;
            maxPeriod = 856.0;
            maxNote = this.period2note(minPeriod);
            minNote = this.period2note(maxPeriod);
        } else {
            minPeriod = 57.0;
            maxPeriod = 1712.0;
            maxNote = this.period2note(minPeriod);
            minNote = this.period2note(maxPeriod);
        }
    }

    public double period2rate(double d) {
        return ac / (2.0 * d);
    }

    public double rate2period(double d) {
        return ac / (2.0 * d);
    }

    @Override
    public double period2note(double d) {
        return this.rate2note(this.period2rate(d));
    }

    @Override
    public double note2period(double d) {
        return this.rate2period(this.note2rate(d));
    }

    @Override
    public double note2rate(double d) {
        double d2 = ac / (2.0 * maxPeriod);
        return d2 * Math.pow(2.0, d / 12.0);
    }

    @Override
    public double rate2note(double d) {
        double d2 = ac / (2.0 * maxPeriod);
        return 12.0 * Math.log(d / d2) / Math.log(2.0);
    }

    @Override
    public double addPeriod(double d, double d2) {
        return this.period2note(this.note2period(d) + d2);
    }

    @Override
    public double getUpperNoteLimit() {
        return maxNote;
    }

    @Override
    public double getLowerNoteLimit() {
        return minNote;
    }

    public double getAmigaClock() {
        return ac;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

