/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.loader.ITLoader;
import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.loader.ModLoader;
import com.vwp.sound.mod.modplay.loader.S3MLoader;
import com.vwp.sound.mod.modplay.loader.STMLoader;
import com.vwp.sound.mod.modplay.loader.XMLoader;
import com.vwp.sound.mod.modplay.loader.ZippedModuleLoader;
import com.vwp.sound.mod.modplay.module.Module;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class ModuleLoader {
    public static final int UNKNOWN = 0;
    public static final int MOD = 1;
    public static final int XM = 2;
    public static final int S3M = 3;
    public static final int STM = 4;
    public static final int IT = 5;
    public static final int ZIP = 6;
    protected static final String EXT_MOD = ".mod";
    protected static final String EXT_XM = ".xm";
    protected static final String EXT_S3M = ".s3m";
    protected static final String EXT_STM = ".stm";
    protected static final String EXT_IT = ".it";
    protected static final String EXT_ZIP = ".zip";

    public static ModuleLoader getModuleLoader(int n, String string, File file) throws InvalidFormatException, IOException {
        return ModuleLoader.getModuleLoader(n, string, ModuleLoader.getData(file));
    }

    public static ModuleLoader getModuleLoader(int n, String string, URL uRL) throws InvalidFormatException, IOException {
        return ModuleLoader.getModuleLoader(n, string, ModuleLoader.getData(uRL));
    }

    public static ModuleLoader getModuleLoader(URL uRL) throws InvalidFormatException, IOException {
        return ModuleLoader.getModuleLoader(ModuleLoader.getType(uRL.toExternalForm()), uRL.toExternalForm(), ModuleLoader.getData(uRL));
    }

    public static ModuleLoader getModuleLoader(File file) throws InvalidFormatException, IOException {
        return ModuleLoader.getModuleLoader(ModuleLoader.getType(file.getAbsolutePath()), file.getAbsolutePath(), ModuleLoader.getData(file));
    }

    public static ModuleLoader getModuleLoader(InputStream inputStream, String string) throws InvalidFormatException, IOException {
        return ModuleLoader.getModuleLoader(ModuleLoader.getType(string), string, ModuleLoader.getData(inputStream));
    }

    public static ModuleLoader getModuleLoader(String string, byte[] byArray) throws InvalidFormatException, IOException {
        return ModuleLoader.getModuleLoader(ModuleLoader.getType(string), string, byArray);
    }

    public static ModuleLoader getModuleLoader(int n, String string, byte[] byArray) throws InvalidFormatException, IOException {
        switch (n) {
            case 1: {
                return new ModLoader(string, byArray);
            }
            case 3: {
                return new S3MLoader(string, byArray);
            }
            case 4: {
                return new STMLoader(string, byArray);
            }
            case 2: {
                return new XMLoader(string, byArray);
            }
            case 5: {
                return new ITLoader(string, byArray);
            }
            case 6: {
                return new ZippedModuleLoader(string, byArray);
            }
        }
        return null;
    }

    private static int getType(String string) {
        if (string.toLowerCase().endsWith(EXT_MOD)) {
            return 1;
        }
        if (string.toLowerCase().endsWith(EXT_S3M)) {
            return 3;
        }
        if (string.toLowerCase().endsWith(EXT_XM)) {
            return 2;
        }
        if (string.toLowerCase().endsWith(EXT_STM)) {
            return 4;
        }
        if (string.toLowerCase().endsWith(EXT_IT)) {
            return 5;
        }
        if (string.toLowerCase().endsWith(EXT_ZIP)) {
            return 6;
        }
        return 0;
    }

    private static byte[] getData(URL uRL) throws IOException {
        return ModuleLoader.getData(uRL.openStream());
    }

    private static byte[] getData(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            throw new IOException("No such file: " + file.getAbsolutePath());
        }
        return ModuleLoader.getData(new FileInputStream(file));
    }

    protected static byte[] getData(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[102400];
        int n = -1;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public abstract Module getModule();

    protected static void skip(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = n;
        while ((n2 = (int)((long)n2 - dataInputStream.skip(n2))) > 0) {
        }
    }
}

