/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.loader.ModLoader;
import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.loader.S3MUnits;
import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.module.Pattern;
import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.module.Track;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoEffect;
import com.vwp.sound.mod.modplay.player.autoeffect.Fadeout;
import com.vwp.sound.mod.util.io.RandomAccess;
import com.vwp.sound.mod.util.io.RandomAccessArray;
import java.io.IOException;

public class S3MLoader
extends ModuleLoader {
    public Module module;
    private boolean first = true;

    public S3MLoader(String string, byte[] byArray) throws InvalidFormatException, IOException {
        RandomAccessArray randomAccessArray = new RandomAccessArray(byArray);
        this.module = this.loadModule(randomAccessArray);
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    private Module loadModule(RandomAccess randomAccess) throws InvalidFormatException, IOException {
        int n;
        String string = this.readModuleName(randomAccess);
        this.verifyID(randomAccess);
        this.verifyFileType(randomAccess);
        randomAccess.skipBytes(2);
        int n2 = this.readWord(randomAccess);
        int n3 = this.readWord(randomAccess);
        int n4 = this.readWord(randomAccess);
        int n5 = this.readWord(randomAccess);
        boolean bl = (n5 & 1) != 0;
        boolean bl2 = (n5 & 2) != 0;
        boolean bl3 = (n5 & 4) != 0;
        boolean bl4 = (n5 & 8) != 0;
        boolean bl5 = (n5 & 0x10) != 0;
        boolean bl6 = (n5 & 0x20) != 0;
        int n6 = this.readWord(randomAccess) & 0xFFF;
        int n7 = randomAccess.read();
        randomAccess.skipBytes(1);
        String string2 = ModLoader.readID(randomAccess);
        int n8 = randomAccess.read();
        int n9 = randomAccess.read();
        int n10 = randomAccess.read();
        int n11 = randomAccess.read() & 0x7F;
        int n12 = randomAccess.read();
        boolean bl7 = randomAccess.read() == 252;
        randomAccess.skipBytes(10);
        int[] nArray = new int[32];
        for (int i = 0; i < 32; ++i) {
            nArray[i] = randomAccess.read();
        }
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray2[n] = randomAccess.read();
        }
        for (n = 0; n < n2; ++n) {
            if (nArray2[n] <= n4) continue;
            nArray2[n] = n4;
        }
        Instrument[] instrumentArray = new Instrument[n3];
        for (int i = 0; i < n3; ++i) {
            instrumentArray[i] = this.loadInstrument(randomAccess, i);
        }
        Pattern[] patternArray = new Pattern[n4 + 1];
        for (int i = 0; i < n4; ++i) {
            patternArray[i] = this.loadPattern(randomAccess);
        }
        patternArray[n4] = new Pattern(this.loadEmptyTracks(32), 64);
        double d = 0.1875;
        double d2 = 0.75;
        double[] dArray = new double[32];
        double[] dArray2 = new double[32];
        for (int i = 0; i < nArray.length; ++i) {
            int n13 = nArray[i];
            if (n13 == 255 || n13 == 127) {
                dArray[i] = 0.5;
            } else {
                int n14 = n13 & 0x7F;
                if (n14 >= 16) {
                    throw new InvalidFormatException("Adlib channels not supported: " + n14);
                }
                dArray[i] = n14 < 8 ? d : d2;
            }
            dArray2[i] = 1.0;
        }
        this.module = new Module(string, string2, "ScreamTracker " + S3MLoader.parseTrackerVersion(n6), instrumentArray, patternArray, nArray2, 0, n10, n9, 1.0, 1, dArray2, dArray);
        return this.module;
    }

    public static String parseTrackerVersion(int n) {
        return (n >> 8 & 0xF) + "." + (n & 0xFF);
    }

    private Track[] loadEmptyTracks(int n) {
        Track[] trackArray = new Track[n];
        for (int i = 0; i < n; ++i) {
            trackArray[i] = new Track(64);
            for (int j = 0; j < 64; ++j) {
                trackArray[i].initDivision(j, -1, -2, null, null, null);
            }
        }
        return trackArray;
    }

    private Pattern loadPattern(RandomAccess randomAccess) throws IOException {
        int n = this.readWord(randomAccess);
        long l = randomAccess.getPosition();
        randomAccess.seek(n * 16);
        Track[] trackArray = this.loadEmptyTracks(32);
        int n2 = this.readWord(randomAccess);
        for (int i = 0; i < 64; ++i) {
            int n3 = -1;
            while ((n3 = randomAccess.read() & 0xFF) != 0) {
                int n4;
                int n5 = n3 & 0x1F;
                int n6 = -2;
                int n7 = -1;
                int n8 = -1;
                int n9 = -1;
                int n10 = 0;
                int n11 = 0;
                boolean bl = false;
                if ((n3 & 0x20) != 0) {
                    n6 = randomAccess.read() & 0xFF;
                    if (n6 == 255) {
                        n6 = -2;
                    } else if (n6 == 254) {
                        bl = true;
                        n6 = -2;
                    } else {
                        n4 = n6 & 0xF;
                        int n12 = n6 >>> 4;
                        n6 = n4 + n12 * 12;
                    }
                    n7 = (randomAccess.read() & 0xFF) - 1;
                }
                if ((n3 & 0x40) != 0) {
                    n8 = randomAccess.read() & 0xFF;
                }
                if ((n3 & 0x80) != 0) {
                    n9 = randomAccess.read() & 0xFF;
                    n4 = randomAccess.read() & 0xFF;
                    n10 = n4 >>> 4;
                    n11 = n4 & 0xF;
                }
                n4 = 0;
                if (n9 != -1) {
                    ++n4;
                }
                if (n8 != -1) {
                    ++n4;
                }
                if (bl) {
                    ++n4;
                }
                int[] nArray = new int[n4];
                int[] nArray2 = new int[n4];
                int[] nArray3 = new int[n4];
                int n13 = 0;
                if (n8 != -1) {
                    nArray[n13] = 12;
                    nArray2[n13] = n8 >>> 4;
                    nArray3[n13] = n8 & 0xF;
                    ++n13;
                }
                if (n9 != -1) {
                    int[] nArray4 = this.translateEffect(n9, n10, n11);
                    nArray[n13] = nArray4[0];
                    nArray2[n13] = nArray4[1];
                    nArray3[n13] = nArray4[2];
                    ++n13;
                }
                if (bl) {
                    nArray[n13] = 50;
                    nArray2[n13] = 0;
                    nArray3[n13] = 0;
                    ++n13;
                }
                trackArray[n5].initDivision(i, n7, n6, nArray, nArray2, nArray3);
            }
        }
        Pattern pattern = new Pattern(trackArray, 64);
        randomAccess.seek(l);
        return pattern;
    }

    private int[] translateEffect(int n, int n2, int n3) {
        switch (n) {
            case -1: {
                return new int[]{-1, 0, 0};
            }
            case 1: {
                return new int[]{15, n2, n3};
            }
            case 2: {
                return new int[]{11, n2, n3};
            }
            case 3: {
                return new int[]{13, n2, n3};
            }
            case 4: {
                if (n2 != 15 && n3 != 15) {
                    return new int[]{10, n2, n3};
                }
                if (n2 == 15) {
                    return new int[]{27, 0, n3};
                }
                if (n3 == 15) {
                    return new int[]{26, 0, n2};
                }
            }
            case 5: {
                if (n2 < 14) {
                    return new int[]{41, n2, n3};
                }
                if (n2 == 14) {
                    return new int[]{45, 0, n3};
                }
                if (n2 == 15) {
                    return new int[]{56, 0, n3};
                }
            }
            case 6: {
                if (n2 < 14) {
                    return new int[]{40, n2, n3};
                }
                if (n2 == 14) {
                    return new int[]{44, 0, n3};
                }
                if (n2 == 15) {
                    return new int[]{55, 0, n3};
                }
            }
            case 7: {
                return new int[]{42, n2, n3};
            }
            case 8: {
                break;
            }
            case 9: {
                return new int[]{60, n2, n3};
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 20: {
                return new int[]{15, n2, n3};
            }
        }
        return new int[]{-1, 0, 0};
    }

    private Instrument loadInstrument(RandomAccess randomAccess, int n) throws InvalidFormatException, IOException {
        int n2 = this.readWord(randomAccess);
        long l = randomAccess.getPosition();
        randomAccess.seek(n2 * 16);
        int n3 = randomAccess.read();
        String string = this.readInstrumentFileName(randomAccess);
        randomAccess.skipBytes(1);
        int n4 = this.readWord(randomAccess) * 16;
        int n5 = this.readWord(randomAccess);
        randomAccess.skipBytes(2);
        int n6 = this.readWord(randomAccess);
        randomAccess.skipBytes(2);
        int n7 = this.readWord(randomAccess);
        randomAccess.skipBytes(2);
        int n8 = randomAccess.read();
        int n9 = randomAccess.read();
        int n10 = randomAccess.read();
        int n11 = randomAccess.read();
        boolean bl = (n11 & 1) != 0;
        boolean bl2 = (n11 & 2) != 0;
        boolean bl3 = (n11 & 4) != 0;
        int n12 = this.readWord(randomAccess);
        randomAccess.skipBytes(2);
        randomAccess.skipBytes(12);
        String string2 = this.readInstrumentName(randomAccess);
        String string3 = ModLoader.readID(randomAccess);
        int[] nArray = new int[1200];
        Sample sample = null;
        if (n3 != 0) {
            sample = new Sample("sample-" + n, string2, (double)n8 / 64.0, 0.5, n5, bl ? 1 : 0, n6, n7 - n6, 0.0, 0.0, new S3MUnits(n12, false));
            sample.setData(this.readSampleData(randomAccess, n4, n5, bl2, bl3, n));
        }
        AutoEffect[] autoEffectArray = new AutoEffect[]{new Fadeout(1.0)};
        Instrument instrument = new Instrument(string2, nArray, new Sample[]{sample}, autoEffectArray, 0.5);
        randomAccess.seek(l);
        return instrument;
    }

    private short[] readSampleData(RandomAccess randomAccess, int n, int n2, boolean bl, boolean bl2, int n3) throws InvalidFormatException, IOException {
        long l = randomAccess.getPosition();
        randomAccess.seek(n);
        short[] sArray = null;
        if (!bl && !bl2) {
            sArray = new short[n2];
            for (int i = 0; i < sArray.length; ++i) {
                int n4 = randomAccess.read() & 0xFF;
                sArray[i] = (short)((n4 << 8) - 32768);
            }
        } else if (!bl && bl2) {
            sArray = new short[n2 * 2];
            for (int i = 0; i < sArray.length; ++i) {
                sArray[i] = (short)((randomAccess.read() & 0xFF) + (randomAccess.read() & 0xFF) * 256 - 32768);
            }
        } else {
            throw new InvalidFormatException("Unsupported sample format: " + (bl ? "stereo" : "mono") + " " + (bl2 ? "16" : "8") + " bit");
        }
        randomAccess.seek(l);
        return sArray;
    }

    private String readInstrumentFileName(RandomAccess randomAccess) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n++ < 12) {
            stringBuffer.append((char)randomAccess.read());
        }
        return stringBuffer.toString();
    }

    private String readInstrumentName(RandomAccess randomAccess) throws IOException {
        long l = randomAccess.getPosition();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n++ < 28 && (n2 = randomAccess.read()) != 0) {
            stringBuffer.append((char)n2);
        }
        randomAccess.seek(l + 28L);
        return stringBuffer.toString();
    }

    private String readModuleName(RandomAccess randomAccess) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        while (randomAccess.getPosition() < 20L && (n = randomAccess.read()) != 0) {
            stringBuffer.append((char)n);
        }
        randomAccess.seek(28L);
        return stringBuffer.toString();
    }

    private void verifyID(RandomAccess randomAccess) throws IOException, InvalidFormatException {
        int n = randomAccess.read();
        if (n != 26) {
            throw new InvalidFormatException("Id = " + n + ", 0x01A expected!");
        }
    }

    private int readWord(RandomAccess randomAccess) throws IOException {
        return randomAccess.read() + 256 * randomAccess.read();
    }

    private void verifyFileType(RandomAccess randomAccess) throws IOException, InvalidFormatException {
        int n = randomAccess.read();
        if (n != 16) {
            throw new InvalidFormatException("Song type = " + n + ", 16 expected");
        }
    }
}

